/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class GenericFileFilter
extends FileFilter {
    private Vector m_suffix = new Vector();
    private String m_description;

    public GenericFileFilter() {
        this.m_description = "?";
    }

    public GenericFileFilter(String desc) {
        this.m_description = desc;
    }

    public GenericFileFilter(String suffix, String desc) {
        this.m_suffix.add(suffix.toUpperCase());
        this.m_description = desc;
    }

    public void addSuffix(String suffix) {
        this.m_suffix.add(suffix.toUpperCase());
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String suffix = this.getSuffix(f).toUpperCase();
        return this.m_suffix.contains(suffix);
    }

    public String getDescription() {
        return this.m_description;
    }

    private String getSuffix(File f) {
        String fstr = f.getAbsolutePath();
        int lastDot = fstr.lastIndexOf(46);
        if (lastDot >= 0 && lastDot + 1 < fstr.length()) {
            return fstr.substring(lastDot + 1);
        }
        return "";
    }
}

