/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class ConflictContainer<K, T> {
    final LinkedList<Conflict> conflicts = Lists.newLinkedList();
    private final Map<K, Conflict> conflictsByParticipant = Maps.newHashMap();
    private final Map<K, Collection<? extends T>> elements = Maps.newHashMap();
    private final Multimap<K, K> targetToSource = LinkedHashMultimap.create();

    ConflictContainer() {
    }

    public Conflict newElement(K target, Collection<? extends T> candidates, @Nullable K replacedBy) {
        Collection replacementSource;
        if (candidates.isEmpty()) {
            return null;
        }
        this.elements.put(target, candidates);
        if (replacedBy != null) {
            this.targetToSource.put(replacedBy, target);
            if (this.elements.containsKey(replacedBy)) {
                return this.registerConflict(target, replacedBy);
            }
        }
        if (!(replacementSource = this.targetToSource.get(target)).isEmpty()) {
            return this.registerConflict((K)replacementSource, target);
        }
        if (candidates.size() > 1) {
            return this.registerConflict(target, target);
        }
        return null;
    }

    private Conflict registerConflict(Collection<K> targets, K replacedBy) {
        assert (!targets.isEmpty());
        Collection<T> candidates = this.elements.get(replacedBy);
        assert (candidates != null);
        LinkedHashSet<K> participants = new LinkedHashSet<K>(targets);
        participants.add(replacedBy);
        for (Object participant : participants) {
            Conflict c = this.conflictsByParticipant.get(participant);
            if (c == null) continue;
            c.candidates = candidates;
            c.participants.addAll(participants);
            return c;
        }
        Conflict c = new Conflict(participants, candidates);
        this.conflicts.add(c);
        for (Object participant : participants) {
            this.conflictsByParticipant.put(participant, c);
        }
        return c;
    }

    private Conflict registerConflict(K target, K replacedBy) {
        return this.registerConflict((K)Collections.singletonList(target), replacedBy);
    }

    public int getSize() {
        return this.conflicts.size();
    }

    public Conflict popConflict() {
        assert (!this.conflicts.isEmpty());
        Conflict conflict = this.conflicts.pop();
        for (Object participant : conflict.participants) {
            this.conflictsByParticipant.remove(participant);
        }
        return conflict;
    }

    public boolean isEmpty() {
        return this.conflicts.isEmpty();
    }

    boolean hasMatchingConflict(Predicate<T> predicate) {
        if (this.isEmpty()) {
            return false;
        }
        return this.conflicts.stream().flatMap(conflict -> conflict.candidates.stream()).anyMatch(predicate);
    }

    class Conflict {
        final Set<K> participants;
        Collection<? extends T> candidates;

        public Conflict(Set<K> participants, Collection<? extends T> candidates) {
            this.participants = participants;
            this.candidates = candidates;
        }

        public String toString() {
            return Joiner.on((String)",").join(this.participants) + ":" + Joiner.on((String)",").join(this.candidates);
        }
    }
}

