/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.CallInterceptingMetaClass;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.InstrumentedGroovyCallsHelper;

@NonNullApi
public class InstrumentedGroovyMetaClassHelper {
    public static void addInvocationHooksInClosureDispatchObject(@Nullable Object object, boolean isEffectivelyInstrumented) {
        if (object == null) {
            return;
        }
        if (isEffectivelyInstrumented) {
            InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(object.getClass());
        }
    }

    public static void addInvocationHooksToEffectivelyInstrumentClosure(Closure<?> closure) {
        InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(closure.getThisObject().getClass());
        InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(closure.getOwner().getClass());
        InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(closure.getDelegate().getClass());
    }

    public static void addInvocationHooksToMetaClassIfInstrumented(Class<?> javaClass, String callableName) {
        if (Instrumented.INTERCEPTOR_RESOLVER.isAwareOfCallSiteName(callableName)) {
            InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(javaClass);
        }
    }

    public static void addInvocationHooksToMetaClass(Class<?> javaClass) {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        MetaClass originalMetaClass = metaClassRegistry.getMetaClass(javaClass);
        if (!(originalMetaClass instanceof CallInterceptingMetaClass)) {
            metaClassRegistry.setMetaClass(javaClass, (MetaClass)InstrumentedGroovyMetaClassHelper.interceptedMetaClass(javaClass, metaClassRegistry, originalMetaClass));
        }
    }

    private static CallInterceptingMetaClass interceptedMetaClass(Class<?> javaClass, MetaClassRegistry metaClassRegistry, MetaClass originalMetaClass) {
        return new CallInterceptingMetaClass(metaClassRegistry, javaClass, originalMetaClass, InstrumentedGroovyCallsHelper.INSTANCE, Instrumented.INTERCEPTOR_RESOLVER);
    }
}

