/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeThrowsChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.annotations.ThrowUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J.\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\"\u001a\u00020\u0013*\u0004\u0018\u00010#H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "cancellationExceptionAndSupersClassIds", "", "Lorg/jetbrains/kotlin/name/ClassId;", "cancellationExceptionFqName", "Lorg/jetbrains/kotlin/name/FqName;", "throwsClassId", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInheritance", "", "throwsAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "decodeThrowsFilter", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getInheritedThrows", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getClassTypes", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "hasUnresolvedArgument", "Lorg/jetbrains/kotlin/fir/FirElement;", "ThrowsFilter", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeThrowsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,185:1\n2624#2,3:186\n1655#2,8:189\n1603#2,9:197\n1855#2:206\n1856#2:208\n1612#2:209\n800#2,11:210\n1549#2:221\n1620#2,2:222\n1622#2:225\n800#2,11:226\n1549#2:237\n1620#2,3:238\n1#3:207\n47#4:224\n*S KotlinDebug\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker\n*L\n61#1:186,3\n79#1:189,8\n85#1:197,9\n85#1:206\n85#1:208\n85#1:209\n176#1:210,11\n177#1:221\n177#1:222,2\n177#1:225\n178#1:226,11\n179#1:237\n179#1:238,3\n85#1:207\n177#1:224\n*E\n"})
public final class FirNativeThrowsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeThrowsChecker INSTANCE = new FirNativeThrowsChecker();
    @NotNull
    private static final ClassId throwsClassId;
    @NotNull
    private static final FqName cancellationExceptionFqName;
    @NotNull
    private static final Set<ClassId> cancellationExceptionAndSupersClassIds;

    private FirNativeThrowsChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirAnnotationCall throwsAnnotation;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, throwsClassId, context.getSession());
        FirAnnotationCall firAnnotationCall = throwsAnnotation = firAnnotation instanceof FirAnnotationCall ? (FirAnnotationCall)firAnnotation : null;
        if (!this.checkInheritance(declaration, throwsAnnotation, context, reporter)) {
            return;
        }
        if (this.hasUnresolvedArgument(throwsAnnotation)) {
            return;
        }
        Object object = throwsAnnotation;
        if (object == null || (object = this.getClassTypes((FirAnnotationCall)object, context.getSession())) == null) {
            return;
        }
        Object classTypes = object;
        if (classTypes.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getTHROWS_LIST_EMPTY(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        FirElement firElement = declaration;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"SUSPEND_KEYWORD");
        if (FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            boolean bl;
            block9: {
                Iterable $this$none$iv = (Iterable)classTypes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!CollectionsKt.contains((Iterable)cancellationExceptionAndSupersClassIds, (Object)ConeTypeUtilsKt.getClassId(it))) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getMISSING_EXCEPTION_IN_THROWS_ON_SUSPEND(), (Object)cancellationExceptionFqName, (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkInheritance(FirDeclaration declaration, FirAnnotationCall throwsAnnotation, CheckerContext context, DiagnosticReporter reporter) {
        if (!(declaration instanceof FirSimpleFunction)) {
            return true;
        }
        Iterable $this$distinctBy$iv = this.getInheritedThrows((FirSimpleFunction)declaration, throwsAnnotation, context).entrySet();
        boolean $i$f$distinctBy = false;
        HashSet<ThrowsFilter> set$iv = new HashSet<ThrowsFilter>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Map.Entry it = (Map.Entry)e$iv;
            boolean bl = false;
            ThrowsFilter key$iv = (ThrowsFilter)it.getValue();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List inherited = list$iv;
        if (inherited.size() >= 2) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$distinctBy$iv = inherited;
            KtDiagnosticFactory1<Collection<FirRegularClassSymbol>> ktDiagnosticFactory1 = FirNativeErrors.INSTANCE.getINCOMPATIBLE_THROWS_INHERITED();
            AbstractKtSourceElement abstractKtSourceElement = declaration.getSource();
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$mapNotNull = false;
            set$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirRegularClassSymbol it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)it.getKey());
                if ((coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context.getSession()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)list2, (DiagnosticContext)context, null, 16, null);
            return false;
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((List)inherited);
        if (entry == null) {
            return true;
        }
        Map.Entry entry2 = entry;
        FirNamedFunctionSymbol overriddenMember = (FirNamedFunctionSymbol)entry2.getKey();
        ThrowsFilter overriddenThrows = (ThrowsFilter)entry2.getValue();
        FirAnnotationCall firAnnotationCall = throwsAnnotation;
        if ((firAnnotationCall != null ? firAnnotationCall.getSource() : null) != null && !Intrinsics.areEqual((Object)this.decodeThrowsFilter(throwsAnnotation, context.getSession()), (Object)overriddenThrows)) {
            FirRegularClassSymbol containingClassSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overriddenMember);
            FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context.getSession()) : null;
            if (containingClassSymbol != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_THROWS_OVERRIDE(), (Object)containingClassSymbol, (DiagnosticContext)context, null, 16, null);
            }
            return false;
        }
        return true;
    }

    private final Map<FirNamedFunctionSymbol, ThrowsFilter> getInheritedThrows(FirSimpleFunction function2, FirAnnotationCall throwsAnnotation, CheckerContext context) {
        Set visited2 = new LinkedHashSet();
        Map result2 = new LinkedHashMap();
        FirNativeThrowsChecker.getInheritedThrows$getInheritedThrows(visited2, context, function2, result2, throwsAnnotation, function2.getSymbol());
        return result2;
    }

    private final boolean hasUnresolvedArgument(FirElement $this$hasUnresolvedArgument) {
        if ($this$hasUnresolvedArgument instanceof FirWrappedArgumentExpression) {
            return this.hasUnresolvedArgument(((FirWrappedArgumentExpression)$this$hasUnresolvedArgument).getExpression());
        }
        if ($this$hasUnresolvedArgument instanceof FirResolvable && FirReferenceUtilsKt.isError(((FirResolvable)$this$hasUnresolvedArgument).getCalleeReference())) {
            return true;
        }
        if ($this$hasUnresolvedArgument instanceof FirVarargArgumentsExpression) {
            for (FirExpression argument2 : ((FirVarargArgumentsExpression)$this$hasUnresolvedArgument).getArguments()) {
                if (!this.hasUnresolvedArgument(argument2)) continue;
                return true;
            }
        }
        if ($this$hasUnresolvedArgument instanceof FirCall) {
            for (FirExpression argument2 : ((FirCall)$this$hasUnresolvedArgument).getArgumentList().getArguments()) {
                if (!this.hasUnresolvedArgument(argument2)) continue;
                return true;
            }
        }
        return false;
    }

    private final ThrowsFilter decodeThrowsFilter(FirAnnotationCall throwsAnnotation, FirSession session) {
        Object object = throwsAnnotation;
        return new ThrowsFilter(object != null && (object = this.getClassTypes((FirAnnotationCall)object, session)) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeKotlinType> getClassTypes(FirAnnotationCall $this$getClassTypes, FirSession session) {
        List list2;
        FirVarargArgumentsExpression firVarargArgumentsExpression;
        List<FirExpression> arguments2 = $this$getClassTypes.getArgumentList().getArguments();
        List<FirExpression> list3 = CollectionsKt.firstOrNull(arguments2);
        FirVarargArgumentsExpression firVarargArgumentsExpression2 = firVarargArgumentsExpression = list3 instanceof FirVarargArgumentsExpression ? (FirVarargArgumentsExpression)((Object)list3) : null;
        if (firVarargArgumentsExpression != null && (list3 = firVarargArgumentsExpression.getArguments()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            FirAnnotationContainer $this$arguments$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$filterIsInstanceTo$iv$iv2;
            void $this$filterIsInstance$iv2;
            Iterable iterable = list3;
            boolean $i$f$filterIsInstance22 = false;
            void var8_9 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof FirGetClassCall)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                FirGetClassCall firGetClassCall = (FirGetClassCall)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                $this$arguments$iv = (FirCall)it;
                boolean $i$f$getArguments = false;
                collection.add(((FirExpression)CollectionsKt.first($this$arguments$iv.getArgumentList().getArguments())).getTypeRef());
            }
            Iterable $i$f$map22 = (List)destination$iv$iv2;
            boolean $i$f$filterIsInstance32 = false;
            destination$iv$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirResolvedTypeRef)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Iterable $i$f$filterIsInstance32 = (List)destination$iv$iv3;
            boolean $i$f$map = false;
            destination$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                $this$arguments$iv = (FirResolvedTypeRef)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl = false;
                collection.add(TypeExpansionUtilsKt.fullyExpandedType(it.getType(), session));
            }
            list2 = (List)destination$iv$iv4;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final void getInheritedThrows$getInheritedThrows(Set<FirNamedFunctionSymbol> visited2, CheckerContext $context, FirSimpleFunction $function, Map<FirNamedFunctionSymbol, ThrowsFilter> result2, FirAnnotationCall localThrowsAnnotation, FirNamedFunctionSymbol localFunctionSymbol) {
        FirRegularClassSymbol containingClassSymbol;
        if (!visited2.add(localFunctionSymbol)) {
            return;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(localFunctionSymbol);
        FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, $context.getSession()) : null;
        if (containingClassSymbol != null) {
            FirTypeScope unsubstitutedScope = FirHelpersKt.unsubstitutedScope(containingClassSymbol, $context);
            unsubstitutedScope.processFunctionsByName(localFunctionSymbol.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)getInheritedThrows.getInheritedThrows.1.INSTANCE));
            List overriddenFunctions2 = FirTypeScopeKt.getDirectOverriddenFunctions$default(unsubstitutedScope, localFunctionSymbol, false, 2, null);
            if (Intrinsics.areEqual((Object)localFunctionSymbol, (Object)$function.getSymbol()) || localThrowsAnnotation == null && !((Collection)overriddenFunctions2).isEmpty()) {
                for (FirNamedFunctionSymbol overriddenFunction : overriddenFunctions2) {
                    FirAnnotation firAnnotation;
                    FirAnnotationCall annotation2 = ClassMembersKt.isSubstitutionOrIntersectionOverride(overriddenFunction) ? null : ((firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(overriddenFunction, throwsClassId, $context.getSession())) instanceof FirAnnotationCall ? (FirAnnotationCall)firAnnotation : null);
                    FirNativeThrowsChecker.getInheritedThrows$getInheritedThrows(visited2, $context, $function, result2, annotation2, overriddenFunction);
                }
            } else {
                result2.put(localFunctionSymbol, INSTANCE.decodeThrowsFilter(localThrowsAnnotation, $context.getSession()));
            }
        }
    }

    static {
        ClassId classId = ClassId.topLevel(ThrowUtilKt.getKOTLIN_THROWS_ANNOTATION_FQ_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(KOTLIN_THROWS_ANNOTATION_FQ_NAME)");
        throwsClassId = classId;
        cancellationExceptionFqName = new FqName("kotlin.coroutines.cancellation.CancellationException");
        Object[] objectArray = new ClassId[]{ClassId.topLevel(StandardNames.FqNames.throwable), ClassId.topLevel(new FqName("kotlin.Exception")), ClassId.topLevel(new FqName("kotlin.RuntimeException")), ClassId.topLevel(new FqName("kotlin.IllegalStateException")), ClassId.topLevel(cancellationExceptionFqName)};
        cancellationExceptionAndSupersClassIds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\t\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "", "classes", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Ljava/util/Set;)V", "getClasses", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers.native"})
    private static final class ThrowsFilter {
        @Nullable
        private final Set<ConeKotlinType> classes;

        public ThrowsFilter(@Nullable Set<? extends ConeKotlinType> classes2) {
            this.classes = classes2;
        }

        @Nullable
        public final Set<ConeKotlinType> getClasses() {
            return this.classes;
        }

        @Nullable
        public final Set<ConeKotlinType> component1() {
            return this.classes;
        }

        @NotNull
        public final ThrowsFilter copy(@Nullable Set<? extends ConeKotlinType> classes2) {
            return new ThrowsFilter(classes2);
        }

        public static /* synthetic */ ThrowsFilter copy$default(ThrowsFilter throwsFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = throwsFilter.classes;
            }
            return throwsFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "ThrowsFilter(classes=" + this.classes + ')';
        }

        public int hashCode() {
            return this.classes == null ? 0 : ((Object)this.classes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowsFilter)) {
                return false;
            }
            ThrowsFilter throwsFilter = (ThrowsFilter)other;
            return Intrinsics.areEqual(this.classes, throwsFilter.classes);
        }
    }
}

