/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.OsXJavaHomeOutputParser;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsXInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsXInstallationSupplier.class);
    private final ExecHandleFactory execHandleFactory;
    private final OperatingSystem os;

    public OsXInstallationSupplier(ExecHandleFactory execHandleFactory, ProviderFactory providerFactory, OperatingSystem os) {
        super(providerFactory);
        this.execHandleFactory = execHandleFactory;
        this.os = os;
    }

    @Override
    public String getSourceName() {
        return "MacOS java_home";
    }

    @Override
    protected Set<InstallationLocation> findCandidates() {
        if (this.os.isMacOsX()) {
            try {
                Reader output = this.executeJavaHome();
                Set<File> javaHomes = new OsXJavaHomeOutputParser().parse(output);
                return javaHomes.stream().map(this::asInstallation).collect(Collectors.toSet());
            }
            catch (ExecException e) {
                String errorMessage = "Java Toolchain auto-detection failed to find local MacOS system JVMs";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(errorMessage, (Throwable)e);
                }
                LOGGER.info(errorMessage);
            }
        }
        return Collections.emptySet();
    }

    private InstallationLocation asInstallation(File javaHome) {
        return new InstallationLocation(javaHome, this.getSourceName());
    }

    private Reader executeJavaHome() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.executeCommand(outputStream);
        return new InputStreamReader(new ByteArrayInputStream(outputStream.toByteArray()));
    }

    void executeCommand(ByteArrayOutputStream outputStream) {
        ExecHandleBuilder execHandleBuilder = this.execHandleFactory.newExec();
        execHandleBuilder.workingDir((Object)new File(".").getAbsoluteFile());
        execHandleBuilder.commandLine(new Object[]{"/usr/libexec/java_home", "-V"});
        execHandleBuilder.getEnvironment().remove("JAVA_VERSION");
        execHandleBuilder.setErrorOutput((OutputStream)outputStream);
        execHandleBuilder.setStandardOutput((OutputStream)new ByteArrayOutputStream());
        execHandleBuilder.build().start().waitForFinish().assertNormalExitValue();
    }
}

