/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.midlet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import org.me4se.Initializer;
import org.me4se.JadFile;
import org.me4se.impl.Log;
import org.me4se.impl.MIDletChooser;
import org.me4se.scm.ScmContainer;
import org.me4se.scm.ScmWrapper;

public class ApplicationManager {
    public static final String ME4SE_VERSION_NUMBER = "3.1.9";
    static final int[] PNG_SIGNATURE = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    static final int DEFAULT_KEYCODE_UP = -1;
    static final int DEFAULT_KEYCODE_DOWN = -2;
    static final int DEFAULT_KEYCODE_LEFT = -3;
    static final int DEFAULT_KEYCODE_RIGHT = -4;
    static final int DEFAULT_KEYCODE_SELECT = -5;
    static final int DEFAULT_KEYCODE_LSK = -6;
    static final int DEFAULT_KEYCODE_RSK = -7;
    static final int DEFAULT_KEYCODE_CLEAR = -8;
    public static final int DEFAULT_KEYCODE_MENU = -12;
    static final int DEFAULT_KEYCODE_MODE = -101;
    static final String[] INITIALIZERS = new String[]{"media.MediaInitializer", "rms.RecordStoreInitializer"};
    static final String DEFAULT_PLATFORM = "ME4SE";
    static final String DEFAULT_CONFIGURATION = "CLDC-1.1";
    static final String DEFAULT_PROFILES = "MIDP-2.0";
    static final String DEFAULT_ENCODING = "ISO8859_1";
    private static ApplicationManager manager;
    public MIDlet active;
    public Applet applet;
    public int colorCount = 0x1000000;
    public boolean isColor = true;
    public Properties properties;
    public Color bgColor = Color.white;
    public ScmContainer skin;
    public JadFile jadFile = new JadFile();
    public ScmContainer displayContainer;
    public ScmWrapper wrapper;
    public Frame frame;
    public Container awtContainer;
    public int screenWidth;
    public int screenHeight;
    public Displayable currentlyShown;
    public String documentBase;
    public ClassLoader classLoader;
    public Hashtable virtualKeyMap = new Hashtable();
    public Hashtable gameActions = new Hashtable();
    public Hashtable keyCodeToButtonName = new Hashtable();
    private Hashtable imageCache = new Hashtable();
    Class activeClass;
    public int keyStates;
    public Vector activePlayers = new Vector();
    public long firstKeyPress;
    public Image timeoutImage;

    public static boolean isInitialized() {
        return manager != null;
    }

    public static ApplicationManager getInstance() {
        return manager != null ? manager : ApplicationManager.createInstance(null, null);
    }

    public BufferedImage createImage(byte[] data, int start, int len) {
        try {
            return this.createImage(new ByteArrayInputStream(data, start, len));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BufferedImage createImage(InputStream is) throws IOException {
        String version = org.me4se.System.getProperty("java.version");
        if (!version.startsWith("1.4")) {
            ImageIO.setUseCache(false);
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        bis.mark(PNG_SIGNATURE.length);
        for (int i = 0; i < PNG_SIGNATURE.length; ++i) {
            if (bis.read() == PNG_SIGNATURE[i]) continue;
            bis.reset();
            BufferedImage img = ImageIO.read(bis);
            if (img == null) {
                throw new IOException("Image broken!");
            }
            return img;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < PNG_SIGNATURE.length; ++i) {
            baos.write(PNG_SIGNATURE[i]);
        }
        DataOutputStream dos = new DataOutputStream(baos);
        DataInputStream dis = new DataInputStream(bis);
        int bitDepth = -1;
        StringBuffer sb = new StringBuffer();
        while (true) {
            int len = dis.readInt();
            sb.setLength(4);
            for (int i = 0; i < 4; ++i) {
                char c = (char)dis.read();
                sb.setCharAt(i, c);
            }
            String type = sb.toString();
            if (sb.toString().equals("IHDR")) {
                dos.writeInt(len);
                dos.write(type.getBytes());
                int w = dis.readInt();
                int h = dis.readInt();
                bitDepth = dis.read();
                int misc = dis.readInt();
                int crc = dis.readInt();
                dos.writeInt(w);
                dos.writeInt(h);
                dos.write(bitDepth);
                dos.writeInt(misc);
                dos.writeInt(crc);
                continue;
            }
            if (sb.toString().equals("PLTE")) {
                int i;
                int padding = (2 << bitDepth - 1) * 3 - len;
                dos.writeInt(len + padding);
                dos.write(type.getBytes());
                for (i = 0; i < len; ++i) {
                    dos.write(dis.read());
                }
                for (i = 0; i < padding; ++i) {
                    dos.write(0);
                }
                dos.writeInt(dis.readInt());
                continue;
            }
            dos.writeInt(len);
            dos.write(type.getBytes());
            for (int i = 0; i < len; ++i) {
                dos.write(dis.read());
            }
            dos.writeInt(dis.readInt());
            if (sb.toString().equals("IEND")) break;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return ImageIO.read(bais);
    }

    public BufferedImage getImage(String fileName) throws IOException {
        BufferedImage img = (BufferedImage)this.imageCache.get(fileName);
        if (img != null) {
            return img;
        }
        InputStream is = this.openInputStream(fileName);
        if (is == null) {
            throw new IOException("null stream opening: " + fileName);
        }
        img = this.createImage(is);
        this.imageCache.put(fileName, img);
        return img;
    }

    public static Object instantiate(String name) throws ClassNotFoundException {
        String implementation = ApplicationManager.getProperty("me4se.implementation");
        implementation = implementation != null ? implementation + ";" : "";
        implementation = implementation + "org.me4se.psi.java1;org.me4se.psi.j2se";
        int pos = 0;
        while (true) {
            int cut;
            if ((cut = implementation.indexOf(59, pos)) == -1) {
                cut = implementation.length();
            }
            String qName = implementation.substring(pos, cut) + "." + name;
            try {
                Class<?> clazz = Class.forName(qName);
                return clazz.newInstance();
            }
            catch (Exception exception) {
                if ((pos = cut + 1) < implementation.length()) continue;
                throw new ClassNotFoundException("No implementation class found for suffix " + name);
            }
            break;
        }
    }

    public static InputStream openInputStream(Class clazz, String name) {
        if (name.startsWith("/")) {
            try {
                return manager.openInputStream(name);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        try {
            Package p = clazz.getPackage();
            String s = "";
            if (p != null) {
                s = p.getName().replace('.', '/');
            }
            return manager.openInputStream(s + "/" + name);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public InputStream openInputStream(String fileName) throws IOException {
        int count;
        InputStream is = this._openInputStream(fileName);
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((count = is.read(buf)) > 0) {
            baos.write(buf, 0, count);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public InputStream _openInputStream(String fileName) throws IOException {
        Log.log(4, "open stream: " + fileName);
        fileName = ApplicationManager.concatPath(this.documentBase, fileName);
        if (ApplicationManager.isUrl(fileName)) {
            return new URL(fileName).openStream();
        }
        try {
            InputStream result = null;
            if (this.activeClass != null && (result = this.activeClass.getResourceAsStream(fileName)) != null) {
                return result;
            }
            if (this.classLoader != null && (result = this.classLoader.getResourceAsStream(fileName)) != null) {
                return result;
            }
            result = ApplicationManager.class.getResourceAsStream(fileName);
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.applet == null && new File(fileName).exists()) {
            return new FileInputStream(fileName);
        }
        org.me4se.System.out.println("WARNING: Resource not found: " + fileName);
        return null;
    }

    public static String getProperty(String name) {
        String result;
        ApplicationManager am = ApplicationManager.isInitialized() ? ApplicationManager.getInstance() : null;
        String string = result = am == null ? null : am.properties.getProperty(name.toLowerCase());
        if (result == null) {
            if (am != null && am.applet != null) {
                result = am.applet.getParameter(name);
            } else {
                try {
                    result = org.me4se.System.getProperty(name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static String getProperty(String name, String dflt) {
        String result = ApplicationManager.getProperty(name);
        return result != null ? result : dflt;
    }

    public static String[] split(String s) {
        int cut;
        if (s == null) {
            return new String[0];
        }
        if ((s = s.trim()).length() == 0) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        while ((cut = s.indexOf(32)) != -1) {
            v.addElement(s.substring(0, cut));
            s = s.substring(cut + 1).trim();
        }
        String[] res = new String[v.size() + 1];
        for (int i = 0; i < res.length - 1; ++i) {
            res[i] = (String)v.elementAt(i);
        }
        res[res.length - 1] = s;
        return res;
    }

    public static boolean isUrl(String path) {
        String test = path.toLowerCase();
        return test.startsWith("http://") || test.startsWith("file:");
    }

    public static String concatPath(String base, String file) {
        if (base == null || file.startsWith("/") || file.startsWith("\\") || file.length() >= 2 && file.charAt(1) == ':' || ApplicationManager.isUrl(file)) {
            return file;
        }
        int cut = Math.max(base.lastIndexOf(47), base.lastIndexOf(92));
        return base.substring(0, cut + 1) + file;
    }

    public static ApplicationManager createInstance(Container container, Properties properties) {
        return new ApplicationManager(container, properties);
    }

    private ApplicationManager(Container container, Properties properties) {
        Initializer init;
        String name;
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.properties = properties == null ? new Properties() : properties;
        org.me4se.System.out.println("---=== ME4SE Version 3.1.9 ===---");
        manager = this;
        if (container instanceof Applet) {
            this.applet = (Applet)container;
            this.documentBase = this.applet.getDocumentBase().toString();
        }
        String locale = ApplicationManager.getProperty("microedition.locale", Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry());
        this.setSystemProperty("microedition.platform", DEFAULT_PLATFORM);
        this.setSystemProperty("microedition.encoding", DEFAULT_ENCODING);
        this.setSystemProperty("microedition.locale", locale);
        this.setSystemProperty("microedition.configuration", DEFAULT_CONFIGURATION);
        if (!"AVETANA-BT".equals(this.getSystemProperty("microedition.profiles"))) {
            this.setSystemProperty("microedition.profiles", DEFAULT_PROFILES);
        }
        if (locale != null) {
            InputStream is = null;
            try {
                is = this.openInputStream("/locale-" + locale + ".properties");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (is == null) {
                    is = this.openInputStream("/locale-" + locale.substring(0, 2) + ".properties");
                }
                if (is != null) {
                    properties.load(is);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setSystemProperty("display.density", String.valueOf(ApplicationManager.getDisplayDensity()));
        this.wrapper = new ScmWrapper(this, new Float(ApplicationManager.getProperty("scale", String.valueOf(1.0 / ApplicationManager.getScale()))).floatValue());
        if (container != null) {
            this.awtContainer = container;
            container.setLayout(new BorderLayout());
            this.screenWidth = container.getSize().width;
            this.screenHeight = container.getSize().height;
        } else {
            this.frame = new Frame(ApplicationManager.getProperty("frame.title", "ME4SE MIDlet"));
            if (ApplicationManager.getProperty("frame.menu", null) != null) {
                this.frame.setMenuBar(this.createMenuBar());
            }
            this.screenWidth = ApplicationManager.getIntProperty("width", ApplicationManager.getIntProperty("screen.width", 150));
            this.screenHeight = ApplicationManager.getIntProperty("height", ApplicationManager.getIntProperty("screen.height", 200));
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent ev) {
                    ApplicationManager.this.destroy(true, true);
                }
            });
            this.awtContainer = this.frame;
        }
        if (ApplicationManager.getProperty("skin") != null) {
            try {
                this.skin = (ScmContainer)Class.forName("org.me4se.impl.skins.Skin").newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.displayContainer = this.skin;
            this.screenWidth = ApplicationManager.getIntProperty("screen.width", this.screenWidth);
            this.screenHeight = ApplicationManager.getIntProperty("screen.height", this.screenHeight);
        } else {
            this.displayContainer = new ScmContainer(){

                public Dimension getPreferredSize() {
                    return this.getMinimumSize();
                }

                public Dimension getMinimumSize() {
                    return new Dimension(ApplicationManager.this.screenWidth, ApplicationManager.this.screenHeight);
                }

                public void paint(Graphics g) {
                    if (this.getComponentCount() == 0) {
                        g.drawString("Loading; please wait...", 20, 20);
                    } else {
                        super.paint(g);
                    }
                }
            };
        }
        this.wrapper.setComponent(this.displayContainer);
        this.awtContainer.add((Component)this.wrapper, "Center");
        if (this.skin != null && this.frame != null) {
            this.frame.pack();
            this.frame.show();
        } else if (this.applet != null) {
            this.wrapper.invalidate();
            this.awtContainer.validate();
        }
        String initializers = ApplicationManager.getProperty("initializers");
        if (initializers != null) {
            StringTokenizer tokens = new StringTokenizer(initializers, ",");
            while (tokens.hasMoreTokens()) {
                name = tokens.nextToken();
                try {
                    init = (Initializer)ApplicationManager.instantiate(name);
                    org.me4se.System.out.println("initializer parameter found for " + name + ": " + init.getClass());
                    init.initialize(this);
                }
                catch (ClassNotFoundException e) {
                    org.me4se.System.out.println("cannot initialize module: " + name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        for (int i = 0; i < INITIALIZERS.length; ++i) {
            name = INITIALIZERS[i];
            try {
                init = (Initializer)ApplicationManager.instantiate(name);
                org.me4se.System.out.println("initializer found for " + name + ": " + init.getClass());
                init.initialize(this);
                continue;
            }
            catch (ClassNotFoundException e) {
                org.me4se.System.out.println("cannot initialize module: " + name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Log.mask = ApplicationManager.getIntProperty("me4se.eventlog", 0);
    }

    public void launch(JadFile jadFileParam, int midletNr) {
        JadFile manifest;
        block20: {
            if (jadFileParam != null) {
                this.jadFile = jadFileParam;
            } else {
                this.jadFile = new JadFile();
                String jadUrl = ApplicationManager.getProperty("jad");
                if (jadUrl != null) {
                    try {
                        this.jadFile.load(jadUrl);
                    }
                    catch (Exception e) {
                        org.me4se.System.err.println("JAD access error: " + e + "; trying midlet/jam property");
                    }
                }
            }
            manifest = new JadFile();
            try {
                InputStream is = this.getClass().getResourceAsStream("/me4se.properties");
                if (is != null) {
                    manifest.load(is);
                    break block20;
                }
                Enumeration<URL> e = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    manifest.load(url.openStream());
                    if (manifest.getMIDletCount() == 0) continue;
                    break;
                }
            }
            catch (Exception e) {
                org.me4se.System.out.println("Error while reading/searching MANIFEST.MF");
                e.printStackTrace();
            }
        }
        if (manifest.getMIDletCount() > 0) {
            Enumeration e = manifest.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key == null) continue;
                String value = manifest.getValue(key);
                if (this.jadFile.getValue(key) == null) {
                    this.jadFile.setValue(key, value);
                }
                this.properties.setProperty(key, value);
                if (!key.startsWith("microedition.")) continue;
                this.setSystemProperty(key, value);
            }
        }
        if (this.jadFile.getValue("MIDlet-1") == null) {
            String midlet = ApplicationManager.getProperty("MIDlet");
            if (midlet != null) {
                this.jadFile.setValue("MIDlet-1", midlet + ",," + midlet);
            } else {
                throw new RuntimeException("JAD File does not contain 'MIDLet' or 'MIDLet-1' property");
            }
        }
        try {
            if (this.jadFile.getMIDletCount() == 1 || midletNr > 0) {
                this.activeClass = Class.forName(this.jadFile.getMIDlet(Math.max(midletNr, 1)).getClassName());
                this.active = (MIDlet)this.activeClass.newInstance();
            } else {
                this.active = new MIDletChooser();
            }
            Displayable d = Display.getDisplay(this.active).getCurrent();
            if (d != null) {
                Display.getDisplay(this.active).setCurrent(d);
            }
            this.active.startApp();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static int getIntProperty(String name, int dflt) {
        try {
            return Integer.decode(ApplicationManager.getProperty(name));
        }
        catch (Exception e) {
            return dflt;
        }
    }

    int discretize(int value, int steps) {
        double v = (double)value / 255.0;
        v = (int)((double)(steps - 1) * v + 0.5);
        return (int)(v *= 255.0 / (double)(steps - 1));
    }

    public int getDeviceColor(int color) {
        if (this.isColor && this.colorCount > 65536 && Color.white.equals(ApplicationManager.manager.bgColor)) {
            return color;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (this.isColor) {
            int scnt = 2;
            for (int cnt = 8; cnt < this.colorCount; cnt *= 8) {
                scnt *= 2;
            }
            r = this.discretize(r, scnt);
            g = this.discretize(g, scnt);
            b = this.discretize(b, scnt);
        } else {
            double grayscale = (double)(r + g + b) / 765.0;
            grayscale = (int)((double)(this.colorCount - 1) * grayscale + 0.5);
            Color bg = ApplicationManager.manager.bgColor;
            r = (int)(grayscale /= (double)(this.colorCount - 1)) * bg.getRed();
            g = (int)grayscale * bg.getGreen();
            b = (int)grayscale * bg.getBlue();
        }
        return color & 0xFF000000 | r << 16 | g << 8 | b;
    }

    public void start() {
        if (this.active != null) {
            // empty if block
        }
    }

    public void pause() {
        if (this.active != null) {
            try {
                this.active.pauseApp();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy(boolean notifyMIDlet, boolean killAll) {
        String activeName;
        String string = activeName = this.active == null ? "" : this.active.getClass().getName();
        if (notifyMIDlet && this.active != null) {
            try {
                this.active.inDestruction = true;
                this.active.destroyApp(true);
                this.active = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = this.activePlayers.size() - 1; i >= 0; --i) {
            ((Player)this.activePlayers.elementAt(i)).close();
        }
        int midletCount = this.jadFile.getMIDletCount();
        try {
            if (!(midletCount <= 1 && this.applet == null || killAll || activeName.equals("org.me4se.impl.MIDletChooser"))) {
                this.launch(this.jadFile, 0);
            } else {
                this.active = null;
                org.me4se.System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.active = null;
            org.me4se.System.exit(0);
        }
    }

    public static Object getComponent(String name) {
        String custom = ApplicationManager.getProperty(name + ".component");
        if (custom == null) {
            return null;
        }
        try {
            return Class.forName("javax.microedition.lcdui." + custom).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean getFlag(String flag) {
        String f = ApplicationManager.getProperty("me4se.flags");
        return f == null ? false : f.toLowerCase().indexOf(flag.toLowerCase()) != -1;
    }

    public static boolean getBooleanProperty(String name, boolean dflt) {
        String v = ApplicationManager.getProperty(name);
        return v == null ? dflt : "true".equalsIgnoreCase(v.trim());
    }

    public String getButtonName(KeyEvent e) {
        int vk = e.getKeyCode();
        String name = (String)this.virtualKeyMap.get(new Integer(vk));
        if (name != null) {
            return name;
        }
        if (vk >= 112 && vk <= 119 && e.getModifiers() == 0) {
            return "SOFT" + (vk - 112 + 1);
        }
        boolean swapNumPad = ApplicationManager.getBooleanProperty("me4se.swapNumPad", true);
        switch (vk) {
            case 9: {
                return e.isShiftDown() ? "UP" : "DOWN";
            }
            case 97: {
                return swapNumPad ? "7" : "1";
            }
            case 98: {
                return swapNumPad ? "8" : "2";
            }
            case 99: {
                return swapNumPad ? "9" : "3";
            }
            case 100: {
                return "4";
            }
            case 101: {
                return "5";
            }
            case 102: {
                return "6";
            }
            case 103: {
                return swapNumPad ? "1" : "7";
            }
            case 104: {
                return swapNumPad ? "2" : "8";
            }
            case 105: {
                return swapNumPad ? "3" : "9";
            }
            case 27: {
                return "BACK";
            }
            case 127: {
                return "DELETE";
            }
            case 8: {
                return "CLEAR";
            }
            case 37: {
                return "LEFT";
            }
            case 39: {
                return "RIGHT";
            }
            case 38: {
                return "UP";
            }
            case 40: {
                return "DOWN";
            }
            case 32: {
                return "SPACE";
            }
            case 17: 
            case 157: {
                return "CONTROL";
            }
        }
        return "" + e.getKeyChar();
    }

    String getButtonName(int deviceKeyCode) {
        String name = (String)this.keyCodeToButtonName.get(new Integer(deviceKeyCode));
        if (name != null) {
            return name;
        }
        switch (deviceKeyCode) {
            case -8: {
                return "CLEAR";
            }
            case -2: {
                return "DOWN";
            }
            case -3: {
                return "LEFT";
            }
            case -4: {
                return "RIGHT";
            }
            case -5: {
                return "SELECT";
            }
            case -1: {
                return "UP";
            }
            case 32: {
                return "SPACE";
            }
        }
        return "" + (char)deviceKeyCode;
    }

    public int getGameAction(int deviceKeyCode) {
        String buttonName = this.getButtonName(deviceKeyCode);
        Integer ga = (Integer)this.gameActions.get(buttonName);
        if (ga != null) {
            return ga;
        }
        if (buttonName.equals("2") || buttonName.equals("UP")) {
            return 1;
        }
        if (buttonName.equals("8") || buttonName.equals("DOWN")) {
            return 6;
        }
        if (buttonName.equals("4") || buttonName.equals("LEFT")) {
            return 2;
        }
        if (buttonName.equals("6") || buttonName.equals("RIGHT")) {
            return 5;
        }
        if (buttonName.equals("5") || buttonName.equals("SELECT") || buttonName.equals("SPACE") || 10 == deviceKeyCode) {
            return 8;
        }
        return 0;
    }

    public int getDeviceKeyCode(String buttonName) {
        int i = ApplicationManager.getIntProperty("keycode." + buttonName, -12345);
        if (i != -12345) {
            return i;
        }
        if (buttonName.length() == 1) {
            return buttonName.charAt(0);
        }
        if ((buttonName = buttonName.toUpperCase()).equals("POUND")) {
            return 35;
        }
        if (buttonName.equals("ASTERISK")) {
            return 42;
        }
        if (buttonName.equals("UP")) {
            return -1;
        }
        if (buttonName.equals("DOWN")) {
            return -2;
        }
        if (buttonName.equals("LEFT")) {
            return -3;
        }
        if (buttonName.equals("RIGHT")) {
            return -4;
        }
        if (buttonName.equals("SELECT")) {
            return -5;
        }
        if (buttonName.equals("SOFT1")) {
            return -6;
        }
        if (buttonName.equals("SOFT2")) {
            return -7;
        }
        if (buttonName.equals("SOFT3")) {
            return -9;
        }
        if (buttonName.equals("SOFT4")) {
            return -10;
        }
        if (buttonName.equals("CLEAR")) {
            return -8;
        }
        if (buttonName.equals("MENU")) {
            return -12;
        }
        if (buttonName.equals("MODE")) {
            return -101;
        }
        if (buttonName.equals("SPACE")) {
            return 32;
        }
        if (buttonName.equals("DELETE")) {
            return 127;
        }
        if (buttonName.equals("CONTROL")) {
            return -50;
        }
        if (buttonName.equals("BACK")) {
            return -11;
        }
        return i;
    }

    public static String decodeJavaEscape(String encoded) {
        if (encoded.indexOf(92) == -1) {
            return encoded;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < encoded.length(); ++i) {
            if (encoded.charAt(i) == '\\') {
                char c = encoded.charAt(++i);
                switch (c) {
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'n': {
                        buf.append('\r');
                        break;
                    }
                    case 'r': {
                        buf.append('\n');
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case 'u': {
                        buf.append((char)Integer.parseInt(encoded.substring(i + 1, i + 5), 16));
                        i += 4;
                        break;
                    }
                    default: {
                        buf.append('\\');
                        buf.append(c);
                        break;
                    }
                }
                continue;
            }
            buf.append(encoded.charAt(i));
        }
        return buf.toString();
    }

    public void setSystemProperty(String key, String value) {
        if (this.applet != null) {
            org.me4se.System.properties.setProperty(key, value);
        } else {
            try {
                System.setProperty(key, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getSystemProperty(String key) {
        if (this.applet != null) {
            return org.me4se.System.properties.getProperty(key);
        }
        try {
            return System.getProperty(key);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu("MIDlet");
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.active.notifyDestroyed();
            }
        });
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
        return menuBar;
    }

    public static double getDisplayDensity() {
        String osNameLowerCase = System.getProperty("os.name").toLowerCase();
        if (!osNameLowerCase.startsWith("mac")) {
            int dpi = 96;
            try {
                dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Math.min(3.0, Math.max(1.0, (double)Math.round(((double)dpi / 96.0 - 0.01) * 2.0) / 2.0));
        }
        return ApplicationManager.getScale();
    }

    public static double getScale() {
        try {
            Object contentScaleFactor = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor");
            return Double.parseDouble(String.valueOf(contentScaleFactor));
        }
        catch (Throwable contentScaleFactor) {
            try {
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                Field field = device.getClass().getDeclaredField("scale");
                field.setAccessible(true);
                return ((Integer)field.get(device)).intValue();
            }
            catch (Throwable throwable) {
                return 1.0;
            }
        }
    }
}

