/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.platform.CustomIntegrator;
import org.dita.dost.platform.FileGenerator;
import org.dita.dost.platform.Plugin;
import org.dita.dost.platform.PluginParser;
import org.dita.dost.platform.PluginRequirement;
import org.dita.dost.platform.Value;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class Integrator {
    private static final String CONF_PLUGIN_ORDER = "plugin.order";
    private static final String CONF_PLUGIN_IGNORES = "plugin.ignores";
    private static final String CONF_PLUGIN_DIRS = "plugindirs";
    private static final String FEAT_IMAGE_EXTENSIONS = "dita.image.extensions";
    private static final String FEAT_HTML_EXTENSIONS = "dita.html.extensions";
    private static final String FEAT_RESOURCE_EXTENSIONS = "dita.resource.extensions";
    private static final String FEAT_PRINT_TRANSTYPES = "dita.transtype.print";
    private static final String FEAT_TRANSTYPES = "dita.conductor.transtype.check";
    private static final String FEAT_LIB_EXTENSIONS = "dita.conductor.lib.import";
    private static final String ELEM_PLUGINS = "plugins";
    private static final String LIB_DIR = "lib";
    private static final String CONFIG_DIR = "config";
    public static final String FEAT_VALUE_SEPARATOR = ",";
    private static final String PARAM_VALUE_SEPARATOR = ";";
    private static final Set<PosixFilePermission> PERMISSIONS = Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE);
    public static final String CONF_PARSER_FORMAT = "parser.";
    private final Map<String, Plugin> pluginTable;
    private final Map<String, Value> templateSet;
    private final File ditaDir;
    private final Set<File> descSet;
    private final XMLReader reader;
    private final Document pluginsDoc;
    private final PluginParser parser;
    private DITAOTLogger logger;
    private final Set<String> loadedPlugin;
    private final Map<String, List<Value>> featureTable;
    @Deprecated
    private File propertiesFile;
    private final Set<String> extensionPoints;
    private final Map<String, Integer> pluginOrder = new HashMap<String, Integer>();
    private Properties properties;
    private Set<String> pluginList;

    public Integrator(File ditaDir) {
        this.ditaDir = ditaDir;
        this.pluginTable = new HashMap<String, Plugin>(16);
        this.templateSet = new HashMap<String, Value>(16);
        this.descSet = new HashSet<File>(16);
        this.loadedPlugin = new HashSet<String>(16);
        this.featureTable = new HashMap<String, List<Value>>(16);
        this.extensionPoints = new HashSet<String>();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            this.reader = parserFactory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
        this.reader.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        this.parser = new PluginParser(ditaDir);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.pluginsDoc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
        this.pluginList = this.getPluginIds(this.readPlugins());
    }

    public void execute() throws Exception {
        String pluginOrderProperty;
        block18: {
            this.properties = new Properties();
            if (this.propertiesFile != null) {
                try (InputStream propertiesStream = Files.newInputStream(this.propertiesFile.toPath(), new OpenOption[0]);){
                    this.properties.load(propertiesStream);
                    break block18;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.properties.putAll(Configuration.configuration);
        }
        if (!this.properties.containsKey(CONF_PLUGIN_DIRS)) {
            this.properties.setProperty(CONF_PLUGIN_DIRS, Configuration.configuration.getOrDefault(CONF_PLUGIN_DIRS, "plugins;demo"));
        }
        if (!this.properties.containsKey(CONF_PLUGIN_IGNORES)) {
            this.properties.setProperty(CONF_PLUGIN_IGNORES, Configuration.configuration.getOrDefault(CONF_PLUGIN_IGNORES, ""));
        }
        String[] pluginDirs = this.properties.getProperty(CONF_PLUGIN_DIRS).split(PARAM_VALUE_SEPARATOR);
        HashSet<String> pluginIgnores = new HashSet<String>();
        if (this.properties.getProperty(CONF_PLUGIN_IGNORES) != null) {
            pluginIgnores.addAll(Arrays.asList(this.properties.getProperty(CONF_PLUGIN_IGNORES).split(PARAM_VALUE_SEPARATOR)));
        }
        if ((pluginOrderProperty = this.properties.getProperty(CONF_PLUGIN_ORDER)) != null) {
            List<String> plugins = Arrays.asList(pluginOrderProperty.trim().split("\\s+"));
            Collections.reverse(plugins);
            int priority = 1;
            for (String plugin : plugins) {
                this.pluginOrder.put(plugin, priority++);
            }
        }
        for (String tmpl : this.properties.getProperty("templates", "").split(PARAM_VALUE_SEPARATOR)) {
            String t = tmpl.trim();
            if (t.length() == 0) continue;
            this.logger.warn(MessageUtils.getMessage("DOTJ080W", "templates", "template").toString());
            this.templateSet.put(t, null);
        }
        for (String pluginDir2 : pluginDirs) {
            File pluginDir = new File(pluginDir2);
            if (!pluginDir.isAbsolute()) {
                pluginDir = new File(this.ditaDir, pluginDir.getPath());
            }
            File[] pluginFiles = pluginDir.listFiles();
            for (int i = 0; pluginFiles != null && i < pluginFiles.length; ++i) {
                File f = pluginFiles[i];
                File descFile = new File(pluginFiles[i], "plugin.xml");
                if (!pluginFiles[i].isDirectory() || pluginIgnores.contains(f.getName()) || !descFile.exists()) continue;
                this.descSet.add(descFile);
            }
        }
        this.mergePlugins();
        this.integrate();
        this.logChanges(this.pluginList, this.getPluginIds(this.pluginsDoc));
    }

    private void logChanges(Set<String> orig, Set<String> mod) {
        ArrayList<String> removed = new ArrayList<String>(orig);
        removed.removeAll(mod);
        removed.sort(Comparator.naturalOrder());
        for (String p : removed) {
            this.logger.info("Removed {}", p);
        }
        ArrayList<String> added = new ArrayList<String>(mod);
        added.removeAll(orig);
        added.sort(Comparator.naturalOrder());
        for (String p : added) {
            this.logger.info("Added {}", p);
        }
    }

    private void integrate() throws Exception {
        String printTranstypeValue;
        this.writePlugins();
        FileGenerator fileGen = new FileGenerator(this.featureTable, this.pluginTable);
        fileGen.setLogger(this.logger);
        for (String string : this.orderPlugins(this.pluginTable.keySet())) {
            this.loadPlugin(string);
        }
        for (Map.Entry entry : this.templateSet.entrySet()) {
            String[] templateFile = new File(this.ditaDir, (String)entry.getKey());
            this.logger.trace("Process template " + templateFile.getPath());
            fileGen.generate((File)templateFile);
        }
        Properties configuration = new Properties();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.properties.getProperty("supported_image_extensions", "").split(PARAM_VALUE_SEPARATOR)) {
            String string2 = string.trim();
            if (string2.length() == 0) continue;
            hashSet.add(string2);
        }
        if (this.featureTable.containsKey(FEAT_IMAGE_EXTENSIONS)) {
            for (Value ext : this.featureTable.get(FEAT_IMAGE_EXTENSIONS)) {
                String e3 = ext.value().trim();
                if (e3.length() == 0) continue;
                hashSet.add(e3);
            }
        }
        configuration.put("supported_image_extensions", StringUtils.join(hashSet, PARAM_VALUE_SEPARATOR));
        configuration.put("supported_html_extensions", this.readExtensions(FEAT_HTML_EXTENSIONS));
        configuration.put("supported_resource_extensions", this.readExtensions(FEAT_RESOURCE_EXTENSIONS));
        String transtypes = this.featureTable.entrySet().stream().filter(e -> ((String)e.getKey()).equals(FEAT_TRANSTYPES)).flatMap(e -> ((List)e.getValue()).stream().map(Value::value)).distinct().collect(Collectors.joining(PARAM_VALUE_SEPARATOR));
        configuration.put("transtypes", transtypes);
        HashSet<String> printTranstypes = new HashSet<String>();
        if (this.featureTable.containsKey(FEAT_PRINT_TRANSTYPES)) {
            for (Value value : this.featureTable.get(FEAT_PRINT_TRANSTYPES)) {
                String string = value.value().trim();
                if (string.length() == 0) continue;
                printTranstypes.add(string);
            }
        }
        if ((printTranstypeValue = this.properties.getProperty("print_transtypes")) != null) {
            printTranstypes.addAll(Arrays.asList(printTranstypeValue.split(PARAM_VALUE_SEPARATOR)));
        }
        configuration.put("print_transtypes", StringUtils.join(printTranstypes, PARAM_VALUE_SEPARATOR));
        for (Map.Entry<String, Plugin> entry : this.pluginTable.entrySet()) {
            Plugin f = entry.getValue();
            String name = "plugin." + entry.getKey() + ".dir";
            List<Value> baseDirValues = f.getFeature("dita.basedir-resource-directory");
            if (Boolean.parseBoolean(baseDirValues == null || baseDirValues.isEmpty() ? null : baseDirValues.get(0).value())) {
                configuration.put(name, ".");
                continue;
            }
            configuration.put(name, FileUtils.getRelativeUnixPath(new File(this.ditaDir, "dummy").getAbsolutePath(), f.pluginDir().getAbsolutePath()));
        }
        configuration.putAll(this.getParserConfiguration());
        this.writePluginProperties(configuration);
        this.processMessages();
        this.writeMessageBundle();
        Set<File> set = this.featureTable.containsKey(FEAT_LIB_EXTENSIONS) ? this.relativize((Collection<Value>)this.featureTable.get(FEAT_LIB_EXTENSIONS)) : Collections.emptySet();
        this.writeEnvShell(set);
        this.writeEnvBatch(set);
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.addAll(this.getLibJars());
        arrayList.addAll(set);
        this.writeStartcmdShell(arrayList);
        this.writeStartcmdBatch(arrayList);
        this.writeConfigurationJar();
        this.customIntegration();
    }

    private void processMessages() throws IOException {
        Path messagesXmlFile = this.ditaDir.toPath().resolve(CONFIG_DIR).resolve("messages.xml");
        if (Files.exists(messagesXmlFile, new LinkOption[0])) {
            List<Message> messages = this.readMessages(messagesXmlFile);
            this.writeMessages(messages, messagesXmlFile);
        }
    }

    private void writeMessages(List<Message> messages, Path messagesXmlFile) throws IOException {
        try (OutputStream messagesOut = Files.newOutputStream(messagesXmlFile, new OpenOption[0]);){
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(messagesOut);
            out.writeStartDocument();
            out.writeStartElement("messages");
            for (Message message : messages) {
                out.writeStartElement("message");
                out.writeAttribute("id", message.id());
                out.writeAttribute("type", message.severity());
                out.writeStartElement("reason");
                if (message.reason() != null) {
                    out.writeCharacters(message.reason());
                }
                out.writeEndElement();
                out.writeStartElement("response");
                if (message.response() != null) {
                    out.writeCharacters(message.response());
                }
                out.writeEndElement();
                out.writeEndElement();
            }
            out.writeEndElement();
            out.writeEndDocument();
            out.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private List<Message> readMessages(Path messagesXmlFile) throws IOException {
        HashMap<String, Message> messages = new HashMap<String, Message>();
        try (InputStream in = Files.newInputStream(messagesXmlFile, new OpenOption[0]);){
            XMLStreamReader src = XMLInputFactory.newInstance().createXMLStreamReader(new StreamSource(in));
            String id = null;
            String severity = null;
            String reason = null;
            String response = null;
            while (src.hasNext()) {
                int type = src.next();
                block3 : switch (type) {
                    case 1: {
                        switch (src.getLocalName()) {
                            case "message": {
                                id = src.getAttributeValue("", "id");
                                severity = src.getAttributeValue("", "type");
                                break block3;
                            }
                            case "reason": {
                                reason = src.getElementText();
                                break block3;
                            }
                            case "response": {
                                response = src.getElementText();
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (!src.getLocalName().equals("message")) break;
                        Message prev = (Message)messages.get(id);
                        if (prev == null) {
                            messages.put(id, new Message(id, severity, reason, response));
                        } else {
                            this.logger.trace("Override message {}", id);
                            messages.put(id, new Message(id, Objects.requireNonNullElse(severity, prev.severity()), Objects.requireNonNullElse(reason, prev.reason()), Objects.requireNonNullElse(response, prev.response())));
                        }
                        id = null;
                        severity = null;
                        reason = null;
                        response = null;
                        break;
                    }
                }
            }
            src.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return messages.values().stream().sorted(Comparator.comparing(Message::id)).toList();
    }

    private void writeMessageBundle() throws IOException, XMLStreamException {
        Properties messages = this.readMessageBundle();
        Path messagesFile = this.ditaDir.toPath().resolve(CONFIG_DIR).resolve("messages_en_US.properties");
        try (OutputStream messagesOut = Files.newOutputStream(messagesFile, new OpenOption[0]);){
            messages.store(messagesOut, null);
        }
    }

    private void writePluginProperties(Properties configuration) {
        Path outFile = this.ditaDir.toPath().resolve(CONFIG_DIR).resolve(this.getClass().getPackage().getName()).resolve("plugin.properties");
        try {
            Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to make directory " + String.valueOf(outFile.getParent()));
        }
        this.logger.trace("Generate configuration properties {}", outFile);
        try (OutputStream out = Files.newOutputStream(outFile, new OpenOption[0]);){
            configuration.store(out, "DITA-OT runtime configuration, do not edit manually");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write configuration properties: " + e.getMessage(), e);
        }
    }

    private void writeConfigurationJar() throws IOException {
        Path outFile = this.ditaDir.toPath().resolve(LIB_DIR).resolve("dost-configuration.jar");
        this.logger.trace("Generate configuration JAR {}", outFile);
        try (OutputStream out = Files.newOutputStream(outFile, new OpenOption[0]);
             ZipOutputStream zip = new ZipOutputStream(out);){
            Path config = this.ditaDir.toPath().resolve(CONFIG_DIR);
            Consumer<Path> copy = path -> {
                Path file = config.resolve((Path)path);
                if (!Files.exists(file, new LinkOption[0])) {
                    return;
                }
                try {
                    ZipEntry entry = new ZipEntry(path.toString().replace('\\', '/'));
                    zip.putNextEntry(entry);
                    Files.copy(file, zip);
                    zip.flush();
                    zip.closeEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
            copy.accept(Paths.get("messages.xml", new String[0]));
            Files.list(config).map(Path::getFileName).filter(path -> path.toString().startsWith("messages_") && path.toString().endsWith(".properties")).forEach(copy);
            copy.accept(Paths.get("plugins.xml", new String[0]));
            copy.accept(Paths.get("configuration.properties", new String[0]));
            copy.accept(Paths.get("CatalogManager.properties", new String[0]));
            copy.accept(Paths.get("org.dita.dost.platform", "plugin.properties"));
        }
        catch (IOException e) {
            throw new IOException("Failed to write configuration JAR", e);
        }
    }

    private Properties readMessageBundle() throws IOException, XMLStreamException {
        Properties messages = new Properties();
        Path messagesXmlFile = this.ditaDir.toPath().resolve(CONFIG_DIR).resolve("messages.xml");
        if (Files.exists(messagesXmlFile, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(messagesXmlFile, new OpenOption[0]);){
                XMLStreamReader src = XMLInputFactory.newInstance().createXMLStreamReader(new StreamSource(in));
                String id = null;
                StringBuilder buf = new StringBuilder();
                while (src.hasNext()) {
                    int type = src.next();
                    switch (type) {
                        case 1: {
                            if (src.getLocalName().equals("message")) {
                                id = src.getAttributeValue("", "id");
                                break;
                            }
                            if (id == null) break;
                            buf.append(src.getElementText()).append(' ');
                            break;
                        }
                        case 2: {
                            if (!src.getLocalName().equals("message")) break;
                            messages.put(id, Integrator.convertMessage(buf.toString()));
                            id = null;
                            buf.delete(0, buf.length());
                        }
                    }
                }
                src.close();
            }
        }
        return messages;
    }

    @VisibleForTesting
    static String convertMessage(String src) {
        String res = src.replaceAll("[\\s\\n]+", " ").replace("'", "''").replace("{", "'{").trim();
        StringBuilder buf = new StringBuilder();
        Matcher m = Pattern.compile("%(\\d)").matcher(res);
        int offset = 0;
        while (m.find()) {
            int index = Integer.parseInt(m.group(1));
            buf.append(res, offset, m.start());
            buf.append("{").append(index - 1).append("}");
            offset = m.end();
        }
        buf.append(res.substring(offset));
        return buf.toString();
    }

    private Collection<File> getLibJars() {
        String[] libJars = new File(this.ditaDir, LIB_DIR).list((dir, name) -> name.endsWith(".jar"));
        ArrayList<File> res = new ArrayList<File>(libJars.length);
        for (String l : libJars) {
            res.add(new File(LIB_DIR + File.separator + l));
        }
        res.sort(Comparator.comparing(File::getAbsolutePath));
        return res;
    }

    private void customIntegration() {
        ServiceLoader<CustomIntegrator> customIntegrators = ServiceLoader.load(CustomIntegrator.class);
        for (CustomIntegrator customIntegrator : customIntegrators) {
            customIntegrator.setLogger(this.logger);
            customIntegrator.setDitaDir(this.ditaDir);
            try {
                customIntegrator.process();
            }
            catch (Exception e) {
                this.logger.error("Custom integrator {} failed: {}", new Object[]{customIntegrator.getClass().getName(), e.getMessage(), e});
            }
        }
    }

    private Iterable<String> orderPlugins(Set<String> ids) {
        ArrayList<String> res = new ArrayList<String>(ids);
        res.sort((s1, s2) -> {
            int score2;
            int score1 = this.pluginOrder.getOrDefault(s1, 0);
            if (score1 < (score2 = this.pluginOrder.getOrDefault(s2, 0).intValue())) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            return s1.compareTo((String)s2);
        });
        return res;
    }

    private Map<String, String> getParserConfiguration() {
        HashMap<String, String> res = new HashMap<String, String>();
        List<Element> features = XMLUtils.toList(this.pluginsDoc.getElementsByTagName("feature"));
        for (Element feature : features) {
            if (!feature.getAttribute("extension").equals("dita.parser")) continue;
            List<Element> parsers = XMLUtils.toList(feature.getElementsByTagName("parser"));
            for (Element parser : parsers) {
                String format = parser.getAttribute("format");
                res.put(CONF_PARSER_FORMAT + format, parser.getAttribute("class"));
                List fs = XMLUtils.toList(parser.getElementsByTagName("feature"));
                List<String> fsv = fs.stream().map(f -> f.getAttribute("name") + "=" + f.getAttribute("value")).toList();
                if (fsv.isEmpty()) continue;
                res.put(CONF_PARSER_FORMAT + format + ".features", String.join((CharSequence)PARAM_VALUE_SEPARATOR, fsv));
            }
        }
        return res;
    }

    private Collection<File> relativize(Collection<Value> src) {
        File base = new File(this.ditaDir, "dummy");
        return src.stream().flatMap(lib -> {
            if (lib instanceof Value.PathValue) {
                Value.PathValue path = (Value.PathValue)lib;
                return Stream.of(URLUtils.toFile(path.getPath()));
            }
            this.logger.error("Library import must be a file feature: " + lib.value());
            return Stream.empty();
        }).map(libFile -> {
            if (!libFile.exists()) {
                throw new IllegalArgumentException("Library file not found: " + libFile.getAbsolutePath());
            }
            return FileUtils.getRelativePath(base, libFile);
        }).toList();
    }

    private void writeEnvShell(Collection<File> jars) {
        Path outFile = this.ditaDir.toPath().resolve(CONFIG_DIR).resolve("env.sh");
        try {
            Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to make directory " + String.valueOf(outFile.getParent()));
        }
        this.logger.trace("Generate environment shell {}", outFile);
        try (BufferedWriter out = Files.newBufferedWriter(outFile, new OpenOption[0]);){
            out.write("#!/bin/sh\n");
            for (File relativeLib : jars) {
                out.write("CLASSPATH=\"$CLASSPATH:");
                if (!relativeLib.isAbsolute()) {
                    out.write("$DITA_HOME/");
                }
                out.write(relativeLib.toString().replace(File.separator, "/"));
                out.write("\"\n");
            }
            try {
                Files.setPosixFilePermissions(outFile, PERMISSIONS);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write environment shell: " + e.getMessage(), e);
        }
    }

    private void writeEnvBatch(Collection<File> jars) {
        Path outFile = this.ditaDir.toPath().resolve(CONFIG_DIR).resolve("env.bat");
        try {
            Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to make directory " + String.valueOf(outFile.getParent()));
        }
        this.logger.trace("Generate environment batch {}", outFile);
        try (BufferedWriter out = Files.newBufferedWriter(outFile, new OpenOption[0]);){
            for (File relativeLib : jars) {
                out.write("set \"CLASSPATH=%CLASSPATH%;");
                if (!relativeLib.isAbsolute()) {
                    out.write("%DITA_HOME%\\");
                }
                out.write(relativeLib.toString().replace(File.separator, "\\"));
                out.write("\"\r\n");
            }
            outFile.toFile().setExecutable(true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write environment batch: " + e.getMessage(), e);
        }
    }

    private void writeStartcmdShell(Collection<File> jars) {
        BufferedWriter out = null;
        try {
            File outFile = new File(this.ditaDir, "startcmd.sh");
            if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                throw new RuntimeException("Failed to make directory " + outFile.getParentFile().getAbsolutePath());
            }
            this.logger.trace("Generate start command shell {}", outFile.getPath());
            out = new BufferedWriter(new FileWriter(outFile));
            out.write("#!/bin/sh\n# Generated file, do not edit manually\"\necho \"NOTE: The startcmd.sh has been deprecated, use the 'dita' command instead.\"\n\nrealpath() {\n  case $1 in\n    /*) echo \"$1\" ;;\n    *) echo \"$PWD/${1#./}\" ;;\n  esac\n}\n\nif [ \"${DITA_HOME:+1}\" = \"1\" ] && [ -e \"$DITA_HOME\" ]; then\n  export DITA_DIR=\"$(realpath \"$DITA_HOME\")\"\nelse #elif [ \"${DITA_HOME:+1}\" != \"1\" ]; then\n  export DITA_DIR=\"$(dirname \"$(realpath \"$0\")\")\"\nfi\n\nif [ -f \"$DITA_DIR\"/bin/ant ] && [ ! -x \"$DITA_DIR\"/bin/ant ]; then\n  chmod +x \"$DITA_DIR\"/bin/ant\nfi\n\nexport ANT_OPTS=\"-Xmx512m $ANT_OPTS\"\nexport ANT_OPTS=\"$ANT_OPTS -Djavax.xml.transform.TransformerFactory=net.sf.saxon.TransformerFactoryImpl\"\nexport ANT_HOME=\"$DITA_DIR\"\nexport PATH=\"$DITA_DIR\"/bin:\"$PATH\"\n\nNEW_CLASSPATH=\"$DITA_DIR/lib:$NEW_CLASSPATH\"\n");
            for (File relativeLib : jars) {
                out.write("NEW_CLASSPATH=\"");
                if (!relativeLib.isAbsolute()) {
                    out.write("$DITA_DIR/");
                }
                out.write(relativeLib.toString().replace(File.separator, "/"));
                out.write(":$NEW_CLASSPATH\"\n");
            }
            out.write("if test -n \"$CLASSPATH\"; then\n  export CLASSPATH=\"$NEW_CLASSPATH\":\"$CLASSPATH\"\nelse\n  export CLASSPATH=\"$NEW_CLASSPATH\"\nfi\n\ncd \"$DITA_DIR\"\n\"$SHELL\"\n");
            try {
                Files.setPosixFilePermissions(outFile.toPath(), PERMISSIONS);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to write start command shell: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
    }

    private void writeStartcmdBatch(Collection<File> jars) {
        BufferedWriter out = null;
        try {
            File outFile = new File(this.ditaDir, "startcmd.bat");
            if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                throw new RuntimeException("Failed to make directory " + outFile.getParentFile().getAbsolutePath());
            }
            this.logger.trace("Generate start command batch {}", outFile.getPath());
            out = new BufferedWriter(new FileWriter(outFile));
            out.write("@echo off\r\nREM Generated file, do not edit manually\r\necho \"NOTE: The startcmd.bat has been deprecated, use the dita.bat command instead.\"\r\npause\r\n\r\nREM Get the absolute path of DITAOT's home directory\r\nset DITA_DIR=%~dp0\r\n\r\nREM Set environment variables\r\nset ANT_OPTS=-Xmx512m %ANT_OPTS%\r\nset ANT_OPTS=%ANT_OPTS% -Djavax.xml.transform.TransformerFactory=net.sf.saxon.TransformerFactoryImpl\r\nset ANT_HOME=%DITA_DIR%\r\nset PATH=%DITA_DIR%\\bin;%PATH%\r\nset CLASSPATH=%DITA_DIR%lib;%CLASSPATH%\r\n");
            for (File relativeLib : jars) {
                out.write("set CLASSPATH=");
                if (!relativeLib.isAbsolute()) {
                    out.write("%DITA_DIR%");
                }
                out.write(relativeLib.toString().replace(File.separator, "\\"));
                out.write(";%CLASSPATH%\r\n");
            }
            out.write("start \"DITA-OT\" cmd.exe\r\n");
            outFile.setExecutable(true);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to write start command batch: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
    }

    private String readExtensions(String featureName) {
        HashSet<String> exts = new HashSet<String>();
        if (this.featureTable.containsKey(featureName)) {
            for (Value ext : this.featureTable.get(featureName)) {
                String e = ext.value().trim();
                if (e.length() == 0) continue;
                exts.add(e);
            }
        }
        return StringUtils.join(exts, PARAM_VALUE_SEPARATOR);
    }

    private boolean loadPlugin(String plugin) {
        if (this.checkPlugin(plugin)) {
            Plugin pluginFeatures = this.pluginTable.get(plugin);
            Map<String, List<Value>> featureSet = pluginFeatures.features();
            for (Map.Entry<String, List<Value>> currentFeature : featureSet.entrySet()) {
                String key = currentFeature.getKey();
                List<Value> values = currentFeature.getValue();
                if (!this.extensionPoints.contains(key)) {
                    throw new RuntimeException("Plug-in %s uses an undefined extension point %s".formatted(plugin, key));
                }
                if (this.featureTable.containsKey(key)) {
                    List<Value> value = this.featureTable.get(key);
                    value.addAll(values);
                    this.featureTable.put(key, value);
                    continue;
                }
                List<Value> currentFeatureValue = values;
                this.featureTable.put(key, (List<Value>)(currentFeatureValue != null ? new ArrayList<Value>(currentFeatureValue) : null));
            }
            for (String templateName : pluginFeatures.templates()) {
                String template = new File(pluginFeatures.pluginDir().toURI().resolve(templateName)).getAbsolutePath();
                String templatePath = FileUtils.getRelativeUnixPath(String.valueOf(this.ditaDir) + File.separator + "dummy", template);
                this.templateSet.put(templatePath, new Value.StringValue(pluginFeatures.pluginId(), templateName));
            }
            this.loadedPlugin.add(plugin);
            return true;
        }
        return false;
    }

    private boolean checkPlugin(String currentPlugin) {
        Plugin pluginFeatures = this.pluginTable.get(currentPlugin);
        for (PluginRequirement requirement : pluginFeatures.requiredPlugins()) {
            boolean anyPluginFound = false;
            for (String requiredPlugin : requirement.plugins()) {
                if (!this.pluginTable.containsKey(requiredPlugin)) continue;
                if (!this.loadedPlugin.contains(requiredPlugin)) {
                    this.loadPlugin(requiredPlugin);
                }
                anyPluginFound = true;
            }
            if (anyPluginFound || !requirement.required()) continue;
            String msg = MessageUtils.getMessage("DOTJ020W", requirement.toString(), currentPlugin).toString();
            throw new RuntimeException(msg);
        }
        return true;
    }

    private Document readPlugins() {
        File plugins = new File(this.ditaDir, CONFIG_DIR + File.separator + "plugins.xml");
        if (!plugins.exists()) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(plugins);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> getPluginIds(Document doc) {
        if (doc == null) {
            return Collections.emptySet();
        }
        List ps = XMLUtils.toList(doc.getElementsByTagName("plugin"));
        return ps.stream().filter(p -> p.getAttributeNode("id") != null).map(p -> p.getAttribute("id")).collect(Collectors.toSet());
    }

    private void mergePlugins() {
        Element root = this.pluginsDoc.createElement(ELEM_PLUGINS);
        this.pluginsDoc.appendChild(root);
        if (!this.descSet.isEmpty()) {
            URI b = new File(this.ditaDir, CONFIG_DIR + File.separator + "plugins.xml").toURI();
            for (File descFile : this.descSet) {
                this.logger.trace("Read plug-in configuration {}", descFile.getPath());
                Element plugin = this.parseDesc(descFile);
                if (plugin == null) continue;
                URI base = URLUtils.getRelativePath(b, descFile.toURI());
                plugin.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", base.toString());
                root.appendChild(this.pluginsDoc.importNode(plugin, true));
            }
        }
    }

    private void writePlugins() throws TransformerException {
        File plugins = new File(this.ditaDir, CONFIG_DIR + File.separator + "plugins.xml");
        this.logger.trace("Writing {}", plugins);
        try {
            new XMLUtils().writeDocument(this.pluginsDoc, plugins);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Element parseDesc(File descFile) {
        try {
            this.parser.setPluginDir(descFile.getParentFile());
            Element root = this.parser.parse(descFile.getAbsoluteFile());
            Plugin f = this.parser.getPlugin();
            this.extensionPoints.addAll(f.extensionPoints().keySet());
            this.pluginTable.put(f.pluginId(), f);
            return root;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SAXParseException e) {
            RuntimeException ex = new RuntimeException("Failed to parse " + descFile.getAbsolutePath() + ": " + e.getMessage(), e);
            throw ex;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setProperties(File propertiesfile) {
        this.propertiesFile = propertiesfile;
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
        this.parser.setLogger(logger);
    }

    static String getValue(Map<String, Plugin> featureTable, String extension) {
        ArrayList<Value> buf = new ArrayList<Value>();
        for (Plugin f : featureTable.values()) {
            List<Value> v = f.getFeature(extension);
            if (v == null) continue;
            buf.addAll(v);
        }
        if (buf.isEmpty()) {
            return null;
        }
        return buf.stream().map(Value::value).collect(Collectors.joining(FEAT_VALUE_SEPARATOR));
    }

    public void addRemoved(String name) {
        this.pluginList.remove(name);
    }

    private record Message(String id, String severity, String reason, String response) {
    }
}

