/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SaxCache {

    public record ProcessingInstructionEvent(String target, String data) implements SaxEvent
    {
        @Override
        public void write(ContentHandler handler) throws SAXException {
            handler.processingInstruction(this.target, this.data);
        }
    }

    public record IgnorableWhitespaceEvent(char[] ch, int start, int length) implements SaxEvent
    {
        public IgnorableWhitespaceEvent(char[] ch, int start, int length) {
            char[] copy = new char[length];
            System.arraycopy(ch, start, copy, 0, length);
            this.ch = copy;
            this.start = 0;
            this.length = length;
        }

        @Override
        public void write(ContentHandler handler) throws SAXException {
            handler.ignorableWhitespace(this.ch, this.start, this.length);
        }
    }

    public record CharactersEvent(char[] ch, int start, int length) implements SaxEvent
    {
        public CharactersEvent(char[] ch, int start, int length) {
            char[] copy = new char[length];
            System.arraycopy(ch, start, copy, 0, length);
            this.ch = copy;
            this.start = 0;
            this.length = length;
        }

        @Override
        public void write(ContentHandler handler) throws SAXException {
            handler.characters(this.ch, this.start, this.length);
        }
    }

    public record EndElementEvent(String uri, String localName, String qName) implements SaxEvent
    {
        @Override
        public void write(ContentHandler handler) throws SAXException {
            handler.endElement(this.uri, this.localName, this.qName);
        }
    }

    public record StartElementEvent(String uri, String localName, String qName, Attributes atts) implements SaxEvent
    {
        public StartElementEvent(String uri, String localName, String qName, Attributes atts) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.atts = new AttributesImpl(atts);
        }

        @Override
        public void write(ContentHandler handler) throws SAXException {
            handler.startElement(this.uri, this.localName, this.qName, this.atts);
        }
    }

    public record EndPrefixMappingEvent(String prefix) implements SaxEvent
    {
        @Override
        public void write(ContentHandler handler) throws SAXException {
            handler.endPrefixMapping(this.prefix);
        }
    }

    public record StartPrefixMappingEvent(String prefix, String uri) implements SaxEvent
    {
        @Override
        public void write(ContentHandler handler) throws SAXException {
            handler.startPrefixMapping(this.prefix, this.uri);
        }
    }

    public static interface SaxEvent {
        public void write(ContentHandler var1) throws SAXException;
    }
}

