/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class NormalizeSimpleTableFilter
extends AbstractXMLFilter {
    private static final String ATTRIBUTE_NAME_COLSPAN = "colspan";
    private static final String ATTRIBUTE_NAME_ROWSPAN = "rowspan";
    private static final String ATTR_X = "x";
    private static final String ATTR_Y = "y";
    private final Deque<String> classStack = new LinkedList<String>();
    private int depth = 0;
    private final Map<String, String> ns = new HashMap<String, String>();
    private final Deque<TableState> tableStack = new LinkedList<TableState>();
    private TableState tableState;

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.ns.put(prefix, uri);
        this.getContentHandler().startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.getContentHandler().endPrefixMapping(prefix);
        this.ns.remove(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.depth;
        if (this.depth == 1 && !this.ns.containsKey("dita-ot")) {
            this.startPrefixMapping("dita-ot", "http://dita-ot.sourceforge.net/ns/201007/dita-ot");
        }
        AttributesImpl res = new AttributesImpl(atts);
        String cls = atts.getValue("class");
        this.classStack.addFirst(cls);
        if (Constants.TOPIC_SIMPLETABLE.matches(cls)) {
            this.tableState = new TableState();
            this.tableStack.addFirst(this.tableState);
        } else if (Constants.TOPIC_STROW.matches(cls) || Constants.TOPIC_STHEAD.matches(cls)) {
            ++this.tableState.rowNumber;
            if (this.tableState.previousRow != null) {
                List<Span> fromPrew = this.tableState.previousRow.stream().map(s -> {
                    if (s == null) {
                        return null;
                    }
                    return s.y > 1 ? new Span(s.x, s.y - 1) : null;
                }).toList();
                this.tableState.currentRow = new ArrayList<Span>(fromPrew);
            } else {
                this.tableState.currentRow = new ArrayList();
            }
            this.tableState.currentColumn = 0;
        } else if (Constants.TOPIC_STENTRY.matches(cls)) {
            this.processEntry(res);
        }
        this.getContentHandler().startElement(uri, localName, qName, res);
    }

    private void processEntry(AttributesImpl res) {
        int colspan = this.getColSpan(res);
        int rowspan = this.getRowSpan(res);
        if (this.tableState.previousRow != null) {
            Span prev;
            Span span = prev = this.tableState.currentColumn < this.tableState.previousRow.size() ? this.tableState.previousRow.get(this.tableState.currentColumn) : null;
            while (prev != null && prev.y > 1) {
                for (int i = 0; i < prev.x; ++i) {
                    ++this.tableState.currentColumn;
                    this.grow(this.tableState.currentRow, this.tableState.currentColumn + 1);
                }
                prev = this.tableState.currentColumn < this.tableState.previousRow.size() ? this.tableState.previousRow.get(this.tableState.currentColumn) : null;
            }
        } else {
            Span prev = new Span(1, 1);
        }
        this.grow(this.tableState.currentRow, this.tableState.currentColumn + colspan);
        Span span = new Span(colspan, rowspan);
        this.tableState.currentRow.set(this.tableState.currentColumn, span);
        XMLUtils.addOrSetAttribute(res, "http://dita-ot.sourceforge.net/ns/201007/dita-ot", ATTR_X, "dita-ot:x", "CDATA", Integer.toString(this.tableState.currentColumn + 1));
        XMLUtils.addOrSetAttribute(res, "http://dita-ot.sourceforge.net/ns/201007/dita-ot", ATTR_Y, "dita-ot:y", "CDATA", Integer.toString(this.tableState.rowNumber));
        this.tableState.currentColumn += colspan;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.getContentHandler().endElement(uri, localName, qName);
        String cls = this.classStack.removeFirst();
        if (Constants.TOPIC_SIMPLETABLE.matches(cls)) {
            this.tableStack.removeFirst();
            this.tableState = this.tableStack.peekFirst();
        } else if (Constants.TOPIC_STROW.matches(cls) || Constants.TOPIC_STHEAD.matches(cls)) {
            this.tableState.previousRow = this.tableState.currentRow;
            this.tableState.currentRow = null;
            this.tableState.currentColumn = -1;
        }
        if (this.depth == 1) {
            this.endPrefixMapping("dita-ot");
        }
        --this.depth;
    }

    private void grow(List<?> array, int size) {
        while (array.size() < size) {
            array.add(null);
        }
    }

    private int getColSpan(Attributes atts) {
        String span = atts.getValue(ATTRIBUTE_NAME_COLSPAN);
        if (span != null) {
            return Integer.parseInt(span);
        }
        return 1;
    }

    private int getRowSpan(Attributes atts) {
        String span = atts.getValue(ATTRIBUTE_NAME_ROWSPAN);
        if (span != null) {
            return Integer.parseInt(span);
        }
        return 1;
    }

    private static class TableState {
        public int rowNumber = 0;
        public ArrayList<Span> previousRow;
        public ArrayList<Span> currentRow;
        public int currentColumn;

        private TableState() {
        }
    }

    private record Span(int x, int y) {
    }
}

