package require tcl3d

set num 50

for { set j 0 } { $j < $num } { incr j } { 
    append row1 [binary format c $j]
}

set vec [tcl3dVectorFromByteArray GLubyte $row1]

set readback [tcl3dVectorToByteArray $vec $num 0 0]

puts "row1: length=[string length $row1] bytelength=[string bytelength $row1]"
puts "read: length=[string length $readback] bytelength=[string bytelength $readback]"
if { [info tclversion] eq "8.6" } {
    puts "row1    =[binary encode base64 $row1]"
    puts "readback=[binary encode base64 $readback]"

    if { ! [string equal [binary encode base64 $row1] [binary encode base64 $readback]] } {
        puts "Error: Base64 differ"
    }
}

if { [string compare $row1 $readback] != 0 } {
    puts "Error: Binary differ"
}
exit
