/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.Command;
import tim.prune.cmd.MediaInsertion;
import tim.prune.data.AudioClip;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;

public class InsertMediaCmd
extends Command {
    private final List<MediaInsertion> _media;

    public InsertMediaCmd(Command command, List<MediaInsertion> list) {
        super(command);
        this._media = new ArrayList<MediaInsertion>(list);
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        for (MediaInsertion mediaInsertion : this._media) {
            if (mediaInsertion.getMedia() instanceof Photo) {
                trackInfo.getPhotoList().add((Photo)mediaInsertion.getMedia(), mediaInsertion.getInsertIndex());
                continue;
            }
            if (mediaInsertion.getMedia() instanceof AudioClip) {
                trackInfo.getAudioList().add((AudioClip)mediaInsertion.getMedia(), mediaInsertion.getInsertIndex());
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        throw new IllegalArgumentException("InsertMediaCmd can only be an inverse");
    }
}

