/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.catalog.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.plugins.catalog.internal.TomlWriter;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class TomlFileGenerator
extends DefaultTask {
    @Input
    public abstract Property<DefaultVersionCatalog> getDependenciesModel();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    void generateToml() throws IOException {
        DefaultVersionCatalog model = (DefaultVersionCatalog)this.getDependenciesModel().get();
        File outputFile = (File)this.getOutputFile().getAsFile().get();
        File outputDir = outputFile.getParentFile();
        if (!outputDir.exists() && !outputFile.mkdirs()) {
            throw new GradleException("Unable to generate TOML dependencies file into " + outputDir);
        }
        this.doGenerate(model, outputFile);
    }

    private void doGenerate(DefaultVersionCatalog model, File outputFile) throws FileNotFoundException, UnsupportedEncodingException {
        try (PrintWriter writer = new PrintWriter(outputFile, "UTF-8");){
            TomlWriter ctx = new TomlWriter(writer);
            ctx.generate(model);
        }
    }
}

