/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExternalAnnotationsManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.name.FqName;

class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static boolean isAbstract(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(0);
        }
        return owner.getPsi().hasModifierProperty("abstract");
    }

    public static boolean isStatic(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(1);
        }
        return owner.getPsi().hasModifierProperty("static");
    }

    public static boolean isFinal(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(2);
        }
        return owner.getPsi().hasModifierProperty("final");
    }

    public static boolean isSealed(@NotNull JavaModifierListOwnerImpl owner) {
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(3);
        }
        return owner.getPsi().hasModifierProperty("sealed");
    }

    @NotNull
    public static Visibility getVisibility(@NotNull JavaModifierListOwnerImpl owner) {
        PsiModifierListOwner psiOwner;
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(4);
        }
        if ((psiOwner = owner.getPsi()).hasModifierProperty("public")) {
            Visibilities.Public public_ = Visibilities.Public.INSTANCE;
            if (public_ == null) {
                JavaElementUtil.$$$reportNull$$$0(5);
            }
            return public_;
        }
        if (psiOwner.hasModifierProperty("private")) {
            Visibilities.Private private_ = Visibilities.Private.INSTANCE;
            if (private_ == null) {
                JavaElementUtil.$$$reportNull$$$0(6);
            }
            return private_;
        }
        if (psiOwner.hasModifierProperty("protected")) {
            Visibility visibility2 = owner.isStatic() ? JavaVisibilities.ProtectedStaticVisibility.INSTANCE : JavaVisibilities.ProtectedAndPackage.INSTANCE;
            if (visibility2 == null) {
                JavaElementUtil.$$$reportNull$$$0(7);
            }
            return visibility2;
        }
        JavaVisibilities.PackageVisibility packageVisibility = JavaVisibilities.PackageVisibility.INSTANCE;
        if (packageVisibility == null) {
            JavaElementUtil.$$$reportNull$$$0(8);
        }
        return packageVisibility;
    }

    @NotNull
    public static Collection<JavaAnnotation> getAnnotations(@NotNull JavaAnnotationOwnerImpl owner, JavaElementSourceFactory sourceFactory) {
        PsiAnnotationOwner annotationOwnerPsi;
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(9);
        }
        if ((annotationOwnerPsi = owner.getAnnotationOwnerPsi()) != null) {
            Collection<JavaAnnotation> collection = JavaElementCollectionFromPsiArrayUtil.annotations(annotationOwnerPsi.getAnnotations(), sourceFactory);
            if (collection == null) {
                JavaElementUtil.$$$reportNull$$$0(10);
            }
            return collection;
        }
        List<JavaAnnotation> list2 = Collections.emptyList();
        if (list2 == null) {
            JavaElementUtil.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    private static PsiAnnotation[] getExternalAnnotations(@NotNull JavaModifierListOwnerImpl modifierListOwner) {
        if (modifierListOwner == null) {
            JavaElementUtil.$$$reportNull$$$0(12);
        }
        PsiModifierListOwner psiModifierListOwner = modifierListOwner.getPsi();
        ExternalAnnotationsManager externalAnnotationManager = ExternalAnnotationsManager.getInstance(psiModifierListOwner.getProject());
        return externalAnnotationManager.findExternalAnnotations(psiModifierListOwner);
    }

    @NotNull
    static <T extends JavaAnnotationOwnerImpl & JavaModifierListOwnerImpl> Collection<JavaAnnotation> getRegularAndExternalAnnotations(@NotNull T owner, JavaElementSourceFactory sourceFactory) {
        PsiAnnotation[] externalAnnotations;
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(13);
        }
        if ((externalAnnotations = JavaElementUtil.getExternalAnnotations(owner)) == null) {
            return JavaElementUtil.getAnnotations(owner, sourceFactory);
        }
        ArrayList<JavaAnnotation> annotations2 = new ArrayList<JavaAnnotation>(JavaElementUtil.getAnnotations(owner, sourceFactory));
        annotations2.addAll(JavaElementCollectionFromPsiArrayUtil.nullabilityAnnotations(externalAnnotations, sourceFactory));
        ArrayList<JavaAnnotation> arrayList = annotations2;
        if (arrayList == null) {
            JavaElementUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    public static JavaAnnotation findAnnotation(@NotNull JavaAnnotationOwnerImpl owner, @NotNull FqName fqName2, JavaElementSourceFactory sourceFactory) {
        PsiAnnotationOwner annotationOwnerPsi;
        if (owner == null) {
            JavaElementUtil.$$$reportNull$$$0(15);
        }
        if (fqName2 == null) {
            JavaElementUtil.$$$reportNull$$$0(16);
        }
        if ((annotationOwnerPsi = owner.getAnnotationOwnerPsi()) != null) {
            PsiAnnotation psiAnnotation = annotationOwnerPsi.findAnnotation(fqName2.asString());
            return psiAnnotation == null ? null : new JavaAnnotationImpl(sourceFactory.createPsiSource(psiAnnotation));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/structure/impl/JavaElementUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/structure/impl/JavaElementUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularAndExternalAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSealed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVisibility";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExternalAnnotations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRegularAndExternalAnnotations";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

