/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.GlobalDependencySubstitutionRegistry;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scopes.BuildTree.class})
public class BuildInclusionCoordinator {
    private final Set<IncludedBuildState> loadedBuilds = new CopyOnWriteArraySet<IncludedBuildState>();
    private final List<IncludedBuildState> libraryBuilds = new CopyOnWriteArrayList<IncludedBuildState>();
    private final GlobalDependencySubstitutionRegistry substitutionRegistry;
    private boolean registerRootSubstitutions;
    private final Set<BuildState> registering = new HashSet<BuildState>();

    public BuildInclusionCoordinator(GlobalDependencySubstitutionRegistry substitutionRegistry) {
        this.substitutionRegistry = substitutionRegistry;
    }

    public void prepareForInclusion(IncludedBuildState build, boolean asPlugin) {
        if (this.loadedBuilds.add(build)) {
            build.ensureProjectsLoaded();
        }
        if (!asPlugin && !this.libraryBuilds.contains(build)) {
            this.libraryBuilds.add(build);
        }
    }

    public void prepareRootBuildForInclusion() {
        this.registerRootSubstitutions = true;
    }

    private void registerGlobalLibrarySubstitutions() {
        for (IncludedBuildState includedBuild : this.libraryBuilds) {
            this.doRegisterSubstitutions(includedBuild);
        }
    }

    public void registerSubstitutionsAvailableFor(BuildState build) {
        if (build instanceof RootBuildState) {
            this.registerGlobalLibrarySubstitutions();
        } else {
            this.makeSubstitutionsAvailableFor(build, new HashSet<BuildState>());
        }
    }

    public void registerSubstitutionsProvidedBy(BuildState build) {
        if (build instanceof RootBuildState && this.registerRootSubstitutions) {
            this.doRegisterSubstitutions((RootBuildState)build);
        }
    }

    public void prepareForPluginResolution(IncludedBuildState build) {
        if (!this.registering.add(build)) {
            return;
        }
        try {
            build.ensureProjectsConfigured();
            this.makeSubstitutionsAvailableFor(build, new HashSet<BuildState>());
        }
        finally {
            this.registering.remove(build);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSubstitutionsAvailableFor(BuildState build, Set<BuildState> seen) {
        if (!seen.add(build)) {
            return;
        }
        boolean added = this.registering.add(build);
        try {
            for (IncludedBuildInternal includedBuildInternal : build.getMutableModel().includedBuilds()) {
                BuildState target = includedBuildInternal.getTarget();
                if (this.registering.contains(target) || !(target instanceof IncludedBuildState)) continue;
                this.doRegisterSubstitutions((IncludedBuildState)target);
                this.makeSubstitutionsAvailableFor(target, seen);
            }
        }
        finally {
            if (added) {
                this.registering.remove(build);
            }
        }
    }

    private void doRegisterSubstitutions(CompositeBuildParticipantBuildState build) {
        this.registering.add(build);
        try {
            this.substitutionRegistry.registerSubstitutionsFor(build);
        }
        finally {
            this.registering.remove(build);
        }
    }
}

