/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassInfo;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jface.text.Region;

public class NLSHintHelper {
    private NLSHintHelper() {
    }

    public static AccessorClassInfo getAccessorClassInfo(CompilationUnit astRoot, NLSElement nlsElement) {
        if (!nlsElement.hasTag()) {
            throw new IllegalArgumentException("NLSElement must be \"nlsed\" before.");
        }
        Region region = nlsElement.getPosition();
        ASTNode nlsStringLiteral = NodeFinder.perform((ASTNode)astRoot, region.getOffset(), region.getLength());
        if (nlsStringLiteral == null) {
            return null;
        }
        ASTNode parent = nlsStringLiteral.getParent();
        if (!(parent instanceof MethodInvocation)) {
            return null;
        }
        MethodInvocation methodInvocation = (MethodInvocation)parent;
        List args = methodInvocation.arguments();
        if (args.indexOf(nlsStringLiteral) != 0) {
            return null;
        }
        IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
        if (methodBinding == null || !Modifier.isStatic((int)methodBinding.getModifiers())) {
            return null;
        }
        ITypeBinding accessorBinding = methodBinding.getDeclaringClass();
        if (NLSHintHelper.isAccessorCandidate(accessorBinding)) {
            return new AccessorClassInfo(accessorBinding, new Region(parent.getStartPosition(), parent.getLength()));
        }
        return null;
    }

    private static boolean isAccessorCandidate(ITypeBinding binding) {
        IVariableBinding[] fields = binding.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (!name.equals("BUNDLE_NAME") && !name.equals("RESOURCE_BUNDLE")) continue;
            return true;
        }
        return false;
    }

    public static IPackageFragment getPackageOfAccessorClass(IJavaProject javaProject, ITypeBinding accessorBinding) throws JavaModelException {
        ICompilationUnit unit;
        if (accessorBinding != null && (unit = Bindings.findCompilationUnit(accessorBinding, javaProject)) != null) {
            return (IPackageFragment)unit.getParent();
        }
        return null;
    }

    public static String getResourceBundleName(IJavaProject javaProject, ITypeBinding accessorClassBinding) throws JavaModelException {
        ICompilationUnit unit = Bindings.findCompilationUnit(accessorClassBinding, javaProject);
        if (unit == null) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(unit);
        parser.setResolveBindings(true);
        parser.setFocalPosition(0);
        CompilationUnit astRoot = (CompilationUnit)parser.createAST(null);
        IVariableBinding[] fields = accessorClassBinding.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            SimpleType simple;
            ITypeBinding typeBinding;
            MethodInvocation methInvocation;
            Expression exp;
            VariableDeclarationFragment node;
            String name = fields[i].getName();
            if (!name.equals("BUNDLE_NAME") && !name.equals("RESOURCE_BUNDLE") || (node = (VariableDeclarationFragment)astRoot.findDeclaringNode(fields[i].getKey())) == null) continue;
            Expression initializer = node.getInitializer();
            if (initializer instanceof StringLiteral) {
                return ((StringLiteral)initializer).getLiteralValue();
            }
            if (!(initializer instanceof MethodInvocation) || (exp = (methInvocation = (MethodInvocation)initializer).getExpression()) == null || !(exp instanceof TypeLiteral) || (typeBinding = (simple = (SimpleType)((TypeLiteral)exp).getType()).resolveBinding()) == null) continue;
            return typeBinding.getQualifiedName();
        }
        return null;
    }

    public static IPackageFragment getResourceBundlePackage(IJavaProject javaProject, String packageName, String resourceName) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getAllPackageFragmentRoots();
        for (int i = 0; i < allRoots.length; ++i) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() != 1 || !(packageFragment = root.getPackageFragment(packageName)).exists()) continue;
            Object[] resources = packageFragment.isDefaultPackage() ? root.getNonJavaResources() : packageFragment.getNonJavaResources();
            for (int j = 0; j < resources.length; ++j) {
                IFile file;
                Object object = resources[j];
                if (!(object instanceof IFile) || !(file = (IFile)object).getName().equals(resourceName)) continue;
                return packageFragment;
            }
        }
        return null;
    }

    private static IFile getResourceBundleFile(IJavaProject javaProject, ITypeBinding accessorClass) throws JavaModelException {
        String resourceBundle = NLSHintHelper.getResourceBundleName(javaProject, accessorClass);
        if (resourceBundle == null) {
            return null;
        }
        String resourceName = Signature.getSimpleName((String)resourceBundle) + ".properties";
        String packName = Signature.getQualifier((String)resourceBundle);
        IPackageFragment bundlePack = NLSHintHelper.getResourceBundlePackage(javaProject, packName, resourceName);
        if (bundlePack == null) {
            return null;
        }
        IPath path = bundlePack.getPath().append(resourceName);
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public static Properties getProperties(IJavaProject project, ITypeBinding accessorBinding) {
        Properties props = new Properties();
        try {
            IFile file = NLSHintHelper.getResourceBundleFile(project, accessorBinding);
            if (file != null) {
                InputStream is = file.getContents();
                props.load(is);
                is.close();
            }
        }
        catch (IOException e) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return props;
    }
}

