/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.swt.widgets.Shell;

public class ReorgMoveStarter {
    private final JavaMoveProcessor fMoveProcessor;

    private ReorgMoveStarter(JavaMoveProcessor moveProcessor) {
        Assert.isNotNull(moveProcessor);
        this.fMoveProcessor = moveProcessor;
    }

    public static ReorgMoveStarter create(IJavaElement[] javaElements, IResource[] resources, IJavaElement destination) throws JavaModelException {
        Assert.isNotNull(javaElements);
        Assert.isNotNull(resources);
        Assert.isNotNull(destination);
        JavaMoveProcessor processor = JavaMoveProcessor.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        if (processor == null) {
            return null;
        }
        if (!processor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(processor);
    }

    public static ReorgMoveStarter create(IJavaElement[] javaElements, IResource[] resources, IResource destination) throws JavaModelException {
        Assert.isNotNull(javaElements);
        Assert.isNotNull(resources);
        Assert.isNotNull(destination);
        JavaMoveProcessor processor = JavaMoveProcessor.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
        if (processor == null) {
            return null;
        }
        if (!processor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(processor);
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        try {
            MoveRefactoring ref = new MoveRefactoring((MoveProcessor)this.fMoveProcessor);
            if (this.fMoveProcessor.hasAllInputSet()) {
                ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
                this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries(parent));
                this.fMoveProcessor.setReorgQueries(new ReorgQueries(parent));
                new RefactoringExecutionHelper((Refactoring)ref, RefactoringCore.getConditionCheckingFailedSeverity(), true, parent, (IRunnableContext)context).perform();
            } else {
                ReorgMoveWizard wizard = new ReorgMoveWizard(ref);
                this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries((Wizard)wizard));
                this.fMoveProcessor.setReorgQueries(new ReorgQueries((Wizard)wizard));
                new RefactoringStarter().activate((Refactoring)ref, wizard, parent, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }
}

