/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.swt.graphics.Image;

public class AssignToVariableAssistProposal
extends LinkedCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    private final String KEY_NAME = "name";
    private final String KEY_TYPE = "type";
    private final int fVariableKind;
    private final ASTNode fNodeToAssign;
    private final ITypeBinding fTypeBinding;

    public AssignToVariableAssistProposal(ICompilationUnit cu, int variableKind, ExpressionStatement node, ITypeBinding typeBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fVariableKind = variableKind;
        this.fNodeToAssign = node;
        this.fTypeBinding = typeBinding;
        if (variableKind == 1) {
            this.setDisplayName(CorrectionMessages.getString("AssignToVariableAssistProposal.assigntolocal.description"));
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif"));
        } else {
            this.setDisplayName(CorrectionMessages.getString("AssignToVariableAssistProposal.assigntofield.description"));
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
        }
    }

    public AssignToVariableAssistProposal(ICompilationUnit cu, SingleVariableDeclaration parameter, ITypeBinding typeBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fVariableKind = 2;
        this.fNodeToAssign = parameter;
        this.fTypeBinding = typeBinding;
        this.setDisplayName(CorrectionMessages.getString("AssignToVariableAssistProposal.assignparamtofield.description"));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fVariableKind == 2) {
            return this.doAddField();
        }
        return this.doAddLocal();
    }

    private ASTRewrite doAddLocal() throws CoreException {
        Expression expression = ((ExpressionStatement)this.fNodeToAssign).getExpression();
        AST ast = this.fNodeToAssign.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String[] varNames = this.suggestLocalVariableNames(this.fTypeBinding, expression);
        for (int i = 0; i < varNames.length; ++i) {
            this.addLinkedPositionProposal("name", varNames[i], null);
        }
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varNames[0]));
        newDeclFrag.setInitializer((Expression)rewrite.createCopyTarget((ASTNode)expression));
        VariableDeclarationExpression newDecl = ast.newVariableDeclarationExpression(newDeclFrag);
        Type type = this.evaluateType(ast);
        newDecl.setType(type);
        rewrite.replace((ASTNode)expression, (ASTNode)newDecl, null);
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), true, "name");
        this.addLinkedPosition(rewrite.track((ASTNode)newDecl.getType()), false, "type");
        this.setEndPosition(rewrite.track(this.fNodeToAssign));
        return rewrite;
    }

    /*
     * WARNING - void declaration
     */
    private ASTRewrite doAddField() throws CoreException {
        ASTNode selectionNode;
        Block body;
        boolean isParamToField = this.fNodeToAssign.getNodeType() == 44;
        ASTNode newTypeDecl = ASTResolving.findParentType(this.fNodeToAssign);
        if (newTypeDecl == null) {
            return null;
        }
        SimpleName expression = isParamToField ? ((SingleVariableDeclaration)this.fNodeToAssign).getName() : ((ExpressionStatement)this.fNodeToAssign).getExpression();
        boolean isAnonymous = newTypeDecl.getNodeType() == 1;
        ChildListPropertyDescriptor property = isAnonymous ? AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY : TypeDeclaration.BODY_DECLARATIONS_PROPERTY;
        List decls = (List)newTypeDecl.getStructuralProperty((StructuralPropertyDescriptor)property);
        AST ast = newTypeDecl.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        BodyDeclaration bodyDecl = ASTResolving.findParentBodyDeclaration(this.fNodeToAssign);
        if (bodyDecl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)bodyDecl).getBody();
        } else if (bodyDecl instanceof Initializer) {
            body = ((Initializer)bodyDecl).getBody();
        } else {
            return null;
        }
        boolean isStatic = Modifier.isStatic((int)bodyDecl.getModifiers()) && !isAnonymous;
        boolean isConstructorParam = isParamToField && this.fNodeToAssign.getParent() instanceof MethodDeclaration && ((MethodDeclaration)this.fNodeToAssign.getParent()).isConstructor();
        int modifiers = 2;
        if (isStatic) {
            modifiers |= 8;
        } else if (isConstructorParam) {
            modifiers |= 0x10;
        }
        String[] varNames = this.suggestFieldNames(this.fTypeBinding, (Expression)expression, modifiers);
        for (int i = 0; i < varNames.length; ++i) {
            this.addLinkedPositionProposal("name", varNames[i], null);
        }
        String varName = varNames[0];
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        FieldDeclaration newDecl = ast.newFieldDeclaration(newDeclFrag);
        Type type = this.evaluateType(ast);
        newDecl.setType(type);
        newDecl.setModifiers(modifiers);
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide((Expression)rewrite.createCopyTarget((ASTNode)expression));
        boolean needsThis = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.keywordthis");
        if (isParamToField) {
            needsThis |= varName.equals(expression.getIdentifier());
        }
        SimpleName accessName = ast.newSimpleName(varName);
        if (needsThis) {
            FieldAccess fieldAccess = ast.newFieldAccess();
            fieldAccess.setName(accessName);
            if (isStatic) {
                String typeName = ((TypeDeclaration)newTypeDecl).getName().getIdentifier();
                fieldAccess.setExpression((Expression)ast.newSimpleName(typeName));
            } else {
                fieldAccess.setExpression((Expression)ast.newThisExpression());
            }
            assignment.setLeftHandSide((Expression)fieldAccess);
        } else {
            assignment.setLeftHandSide((Expression)accessName);
        }
        int insertIndex = this.findFieldInsertIndex(decls, this.fNodeToAssign.getStartPosition());
        rewrite.getListRewrite(newTypeDecl, property).insertAt((ASTNode)newDecl, insertIndex, null);
        if (isParamToField) {
            void var10_10;
            ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
            int insertIdx = this.findAssignmentInsertIndex(var10_10.statements());
            rewrite.getListRewrite((ASTNode)var10_10, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)statement, insertIdx, null);
            selectionNode = statement;
        } else {
            rewrite.replace((ASTNode)expression, (ASTNode)assignment, null);
            selectionNode = this.fNodeToAssign;
        }
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), false, "name");
        this.addLinkedPosition(rewrite.track((ASTNode)newDecl.getType()), false, "type");
        this.addLinkedPosition(rewrite.track((ASTNode)accessName), true, "name");
        this.setEndPosition(rewrite.track(selectionNode));
        return rewrite;
    }

    private Type evaluateType(AST ast) throws CoreException {
        ITypeBinding[] proposals = ASTResolving.getRelaxingTypes(ast, this.fTypeBinding);
        for (int i = 0; i < proposals.length; ++i) {
            this.addLinkedPositionProposal("type", proposals[i]);
        }
        String typeName = this.getImportRewrite().addImport(this.fTypeBinding);
        return ASTNodeFactory.newType(ast, typeName);
    }

    private String[] suggestLocalVariableNames(ITypeBinding binding, Expression expression) {
        ArrayList<String> res = new ArrayList<String>();
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        ITypeBinding base = binding.isArray() ? binding.getElementType() : binding;
        IPackageBinding packBinding = base.getPackage();
        String packName = packBinding != null ? packBinding.getName() : "";
        String[] excludedNames = this.getUsedVariableNames();
        String name = ASTResolving.getBaseNameFromExpression(project, expression);
        if (name != null) {
            String[] argname = StubUtility.getLocalNameSuggestions(project, name, 0, excludedNames);
            for (int i = 0; i < argname.length; ++i) {
                String curr = argname[i];
                if (res.contains(curr)) continue;
                res.add(curr);
            }
        }
        String typeName = base.getName();
        String[] names = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)packName, (String)typeName, (int)binding.getDimensions(), (String[])excludedNames);
        for (int i = 0; i < names.length; ++i) {
            String curr = names[i];
            if (res.contains(curr)) continue;
            res.add(curr);
        }
        return res.toArray(new String[res.size()]);
    }

    private String[] suggestFieldNames(ITypeBinding binding, Expression expression, int modifiers) {
        ArrayList<String> res = new ArrayList<String>();
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        ITypeBinding base = binding.isArray() ? binding.getElementType() : binding;
        IPackageBinding packBinding = base.getPackage();
        String packName = packBinding != null ? packBinding.getName() : "";
        String[] excludedNames = this.getUsedVariableNames();
        String name = ASTResolving.getBaseNameFromExpression(project, expression);
        if (name != null) {
            String[] argname = StubUtility.getFieldNameSuggestions(project, name, 0, modifiers, excludedNames);
            for (int i = 0; i < argname.length; ++i) {
                String curr = argname[i];
                if (res.contains(curr)) continue;
                res.add(curr);
            }
        }
        String typeName = base.getName();
        String[] names = NamingConventions.suggestFieldNames((IJavaProject)project, (String)packName, (String)typeName, (int)binding.getDimensions(), (int)modifiers, (String[])excludedNames);
        for (int i = 0; i < names.length; ++i) {
            String curr = names[i];
            if (res.contains(curr)) continue;
            res.add(curr);
        }
        return res.toArray(new String[res.size()]);
    }

    private String[] getUsedVariableNames() {
        int i;
        CompilationUnit root = (CompilationUnit)this.fNodeToAssign.getRoot();
        IBinding[] varsBefore = new ScopeAnalyzer(root).getDeclarationsInScope(this.fNodeToAssign.getStartPosition(), 2);
        IBinding[] varsAfter = new ScopeAnalyzer(root).getDeclarationsAfter(this.fNodeToAssign.getStartPosition() + this.fNodeToAssign.getLength(), 2);
        String[] names = new String[varsBefore.length + varsAfter.length];
        for (i = 0; i < varsBefore.length; ++i) {
            names[i] = varsBefore[i].getName();
        }
        for (i = 0; i < varsAfter.length; ++i) {
            names[i + varsBefore.length] = varsAfter[i].getName();
        }
        return names;
    }

    private int findAssignmentInsertIndex(List statements) {
        int i;
        HashSet<String> paramsBefore = new HashSet<String>();
        List params = ((MethodDeclaration)this.fNodeToAssign.getParent()).parameters();
        for (i = 0; i < params.size() && params.get(i) != this.fNodeToAssign; ++i) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)params.get(i);
            paramsBefore.add(decl.getName().getIdentifier());
        }
        i = 0;
        block5: for (i = 0; i < statements.size(); ++i) {
            Statement curr = (Statement)statements.get(i);
            switch (curr.getNodeType()) {
                case 17: 
                case 46: {
                    continue block5;
                }
                case 21: {
                    IVariableBinding binding;
                    Assignment assignment;
                    Expression rightHand;
                    Expression expr = ((ExpressionStatement)curr).getExpression();
                    if (expr instanceof Assignment && (rightHand = (assignment = (Assignment)expr).getRightHandSide()) instanceof SimpleName && paramsBefore.contains(((SimpleName)rightHand).getIdentifier()) && ((binding = Bindings.getAssignedVariable(assignment)) == null || binding.isField())) continue block5;
                    return i;
                }
                default: {
                    return i;
                }
            }
        }
        return i;
    }

    private int findFieldInsertIndex(List decls, int currPos) {
        for (int i = decls.size() - 1; i >= 0; --i) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (!(curr instanceof FieldDeclaration) || currPos <= curr.getStartPosition() + curr.getLength()) continue;
            return i + 1;
        }
        return 0;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

