/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.presentations;

import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.html.HTMLElement;
import org.eclipse.ui.internal.intro.impl.html.IntroHTMLGenerator;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartLocationListener;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;

public class BrowserIntroPartImplementation
extends AbstractIntroPartImplementation
implements IPropertyListener,
IIntroContentProviderSite {
    private Browser browser = null;
    private IntroHTMLGenerator htmlGenerator = null;
    private BrowserIntroPartLocationListener urlListener = new BrowserIntroPartLocationListener(this);

    protected void updateNavigationActionsState() {
        if (this.getModel().isDynamic()) {
            this.forwardAction.setEnabled(this.canNavigateForward());
            this.backAction.setEnabled(this.canNavigateBackward());
            return;
        }
        this.forwardAction.setEnabled(this.browser.isForwardEnabled());
        this.backAction.setEnabled(this.browser.isBackEnabled());
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addLocationListener((LocationListener)this.urlListener);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                BrowserIntroPartImplementation.this.browser.setData("frameNavigation", null);
                if (!BrowserIntroPartImplementation.this.getModel().isDynamic()) {
                    BrowserIntroPartImplementation.this.updateNavigationActionsState();
                }
            }
        });
        this.browser.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = IntroPlugin.getDefault().isDebugging();
            }
        });
        this.addToolBarActions();
        if (!this.getModel().hasValidConfig()) {
            this.browser.setText(IntroPlugin.getString("Browser.invalidConfig"));
            return;
        }
        if (this.getModel().isDynamic()) {
            this.handleDynamicIntro();
        } else {
            this.handleStaticIntro();
        }
    }

    private void handleDynamicIntro() {
        IntroHomePage homePage = this.getModel().getHomePage();
        String cachedPage = this.getCachedCurrentPage();
        if (cachedPage != null) {
            if (this.isURL(cachedPage)) {
                boolean success = this.browser.setUrl(cachedPage);
                if (!success) {
                    Log.error("Unable to set the following ULR in browser: " + cachedPage, null);
                    return;
                }
            } else {
                this.getModel().setCurrentPageId(cachedPage, false);
            }
            this.updateHistory(cachedPage);
        } else {
            this.updateHistory(homePage.getId());
        }
        this.getModel().addPropertyListener(this);
    }

    private boolean generateDynamicContentForPage(AbstractIntroPage page) {
        String printHtml;
        HTMLElement html = this.getHTMLGenerator().generateHTMLforPage(page, this);
        if (html == null) {
            Log.error("Error generating HTML", null);
            return false;
        }
        boolean success = false;
        if (this.browser != null && !(success = this.browser.setText(html.toString()))) {
            Log.error("Unable to set HTML on the browser", null);
        }
        if (IntroPlugin.getDefault().isDebugging() && (printHtml = Platform.getDebugOption((String)"org.eclipse.ui.intro/trace/printHTML")) != null && printHtml.equalsIgnoreCase("true")) {
            System.out.println(html);
        }
        return success;
    }

    private IntroHTMLGenerator getHTMLGenerator() {
        if (this.htmlGenerator == null) {
            this.htmlGenerator = new IntroHTMLGenerator();
        }
        return this.htmlGenerator;
    }

    protected void addToolBarActions() {
        IActionBars actionBars = this.getIntroPart().getIntroSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        toolBarManager.add((IAction)this.homeAction);
        toolBarManager.add((IAction)this.backAction);
        toolBarManager.add((IAction)this.forwardAction);
        toolBarManager.update(true);
        actionBars.updateActionBars();
        this.updateNavigationActionsState();
    }

    public void dynamicStandbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (isStandbyPartNeeded) {
            return;
        }
        IntroHomePage homePage = this.getModel().getHomePage();
        IntroHomePage standbyPage = this.getModel().getStandbyPage();
        if (standbyPage == null) {
            standbyPage = homePage;
        }
        if (standby) {
            this.generateDynamicContentForPage(standbyPage);
        } else {
            if (this.getModel().getCurrentPage().equals(standbyPage.getId())) {
                this.getModel().setCurrentPageId(this.getModel().getHomePage().getId());
            }
            this.generateDynamicContentForPage(this.getModel().getCurrentPage());
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            String pageId = this.getModel().getCurrentPageId();
            if (pageId == null || pageId.equals("")) {
                return;
            }
            this.updateContent();
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        this.browser.dispose();
    }

    protected void updateContent() {
        this.generateDynamicContentForPage(this.getModel().getCurrentPage());
    }

    public void reflow(IIntroContentProvider provider, boolean incremental) {
        this.updateContent();
    }

    protected void saveCurrentPage(IMemento memento) {
        if (memento == null) {
            return;
        }
        if (this.browser != null && this.browser.getUrl() != null && this.browser.getUrl().length() > 0 && !this.browser.getUrl().equals("about:blank")) {
            String currentURL = this.browser.getUrl();
            if (currentURL != null) {
                memento.putString("currentPage", currentURL);
            }
        } else {
            super.saveCurrentPage(memento);
        }
    }

    public boolean navigateBackward() {
        boolean success = false;
        if (this.getModel().isDynamic()) {
            if (this.canNavigateBackward()) {
                this.navigateHistoryBackward();
                if (this.isURL(this.getCurrentLocation())) {
                    success = this.browser.setUrl(this.getCurrentLocation());
                } else {
                    AbstractIntroPage page = (AbstractIntroPage)this.getModel().findChild(this.getCurrentLocation(), 12);
                    success = this.generateDynamicContentForPage(page);
                    this.getModel().setCurrentPageId(this.getCurrentLocation(), false);
                }
            } else {
                success = false;
            }
            this.updateNavigationActionsState();
        } else {
            success = this.browser.back();
        }
        return success;
    }

    public boolean navigateForward() {
        boolean success = false;
        if (this.getModel().isDynamic()) {
            if (this.canNavigateForward()) {
                this.navigateHistoryForward();
                if (this.isURL(this.getCurrentLocation())) {
                    success = this.browser.setUrl(this.getCurrentLocation());
                } else {
                    AbstractIntroPage page = (AbstractIntroPage)this.getModel().findChild(this.getCurrentLocation(), 12);
                    success = this.generateDynamicContentForPage(page);
                    this.getModel().setCurrentPageId(this.getCurrentLocation(), false);
                }
            } else {
                success = false;
            }
            this.updateNavigationActionsState();
        } else {
            success = this.browser.forward();
        }
        return success;
    }

    public boolean navigateHome() {
        IntroHomePage rootPage = this.getModel().getHomePage();
        String location = null;
        boolean success = false;
        if (this.getModel().isDynamic()) {
            location = rootPage.getId();
            success = this.getModel().setCurrentPageId(location);
        } else {
            location = rootPage.getUrl();
            success = this.browser.setUrl(location);
        }
        this.updateHistory(location);
        return success;
    }

    protected void handleRegistryChanged(IRegistryChangeEvent event) {
        if (this.getModel().isDynamic()) {
            this.htmlGenerator = null;
            this.getModel().addPropertyListener(this);
            this.getModel().firePropertyChange(1);
        }
    }

    public void standbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (isStandbyPartNeeded | standby) {
            this.homeAction.setEnabled(false);
            this.forwardAction.setEnabled(false);
            this.backAction.setEnabled(false);
        } else {
            this.homeAction.setEnabled(true);
            this.updateNavigationActionsState();
        }
        if (this.getModel().isDynamic()) {
            this.dynamicStandbyStateChanged(standby, isStandbyPartNeeded);
        } else {
            this.staticStandbyStateChanged(standby);
        }
    }

    private void handleStaticIntro() {
        String url = this.getCachedCurrentPage();
        if (!this.isURL(url)) {
            url = this.getModel().getHomePage().getUrl();
        }
        if (url == null) {
            Log.error("Url is null; no content to display in browser", null);
            return;
        }
        boolean success = this.browser.setUrl(url);
        if (!success) {
            Log.error("Unable to set the following ULR in browser: " + url, null);
            return;
        }
    }

    public void staticStandbyStateChanged(boolean standby) {
        IntroHomePage homePage = this.getModel().getHomePage();
        IntroHomePage standbyPage = this.getModel().getStandbyPage();
        if (standbyPage == null) {
            standbyPage = homePage;
        }
        if (standby) {
            this.browser.setUrl(standbyPage.getUrl());
        } else {
            this.browser.setUrl(homePage.getUrl());
        }
    }
}

