/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;

class ComputeProjectOrder {
    private ComputeProjectOrder() {
    }

    static IWorkspace.ProjectOrder computeProjectOrder(SortedSet projects, List references) {
        IProject[][] knots;
        Digraph g1 = new Digraph();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            IProject project = (IProject)it.next();
            g1.addVertex(project);
        }
        it = references.iterator();
        while (it.hasNext()) {
            IProject[] ref = (IProject[])it.next();
            IProject p = ref[0];
            IProject q = ref[1];
            g1.addEdge(q, p);
        }
        g1.freeze();
        Digraph g2 = new Digraph();
        List resortedVertexes = g1.idsByDFSFinishTime(false);
        Iterator it2 = resortedVertexes.iterator();
        while (it2.hasNext()) {
            IProject project = (IProject)it2.next();
            g2.addVertex(project);
        }
        it2 = references.iterator();
        while (it2.hasNext()) {
            IProject[] ref = (IProject[])it2.next();
            IProject p = ref[0];
            IProject q = ref[1];
            g2.addEdge(p, q);
        }
        g2.freeze();
        List sortedProjectList = g2.idsByDFSFinishTime(true);
        IProject[] orderedProjects = new IProject[sortedProjectList.size()];
        sortedProjectList.toArray(orderedProjects);
        boolean hasCycles = g2.containsCycles();
        if (hasCycles) {
            List knotList = g2.nonTrivialComponents();
            knots = new IProject[knotList.size()][];
            int k = 0;
            Iterator it3 = knotList.iterator();
            while (it3.hasNext()) {
                Object[] knot = (Object[])it3.next();
                IProject[] knotCopy = new IProject[knot.length];
                for (int i = 0; i < knot.length; ++i) {
                    knotCopy[i] = (IProject)knot[i];
                }
                knots[k] = knotCopy;
                ++k;
            }
        } else {
            knots = new IProject[][]{};
        }
        return new IWorkspace.ProjectOrder(orderedProjects, hasCycles, knots);
    }

    private static class Digraph {
        private List vertexList = new ArrayList(100);
        private Map vertexMap = new HashMap(100);
        private int time;
        private boolean initialized = false;
        private boolean cycles = false;

        public void freeze() {
            if (!this.initialized) {
                this.initialized = true;
                this.DFS();
            }
        }

        public void addVertex(Object id) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex vertex = new Vertex(id);
            Vertex existing = this.vertexMap.put(id, vertex);
            if (existing != null) {
                throw new IllegalArgumentException();
            }
            this.vertexList.add(vertex);
        }

        public void addEdge(Object fromId, Object toId) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex fromVertex = (Vertex)this.vertexMap.get(fromId);
            Vertex toVertex = (Vertex)this.vertexMap.get(toId);
            if (fromVertex == null) {
                throw new IllegalArgumentException();
            }
            if (toVertex == null) {
                throw new IllegalArgumentException();
            }
            fromVertex.adjacent.add(toVertex);
        }

        public List idsByDFSFinishTime(boolean increasing) {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            int len = this.vertexList.size();
            Object[] r = new Object[len];
            Iterator allV = this.vertexList.iterator();
            while (allV.hasNext()) {
                Vertex vertex = (Vertex)allV.next();
                int f = vertex.finishTime;
                if (increasing) {
                    r[f - 1] = vertex.id;
                    continue;
                }
                r[len - f] = vertex.id;
            }
            return Arrays.asList(r);
        }

        public boolean containsCycles() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            return this.cycles;
        }

        public List nonTrivialComponents() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            HashMap<Vertex, ArrayList<Object>> components = new HashMap<Vertex, ArrayList<Object>>();
            Iterator it = this.vertexList.iterator();
            while (it.hasNext()) {
                Vertex vertex = (Vertex)it.next();
                if (vertex.predecessor == null) continue;
                Vertex root = vertex;
                while (root.predecessor != null) {
                    root = root.predecessor;
                }
                ArrayList<Object> component = (ArrayList<Object>)components.get(root);
                if (component == null) {
                    component = new ArrayList<Object>(2);
                    component.add(root.id);
                    components.put(root, component);
                }
                component.add(vertex.id);
            }
            ArrayList<Object[]> result = new ArrayList<Object[]>(components.size());
            Iterator it2 = components.values().iterator();
            while (it2.hasNext()) {
                List component = (List)it2.next();
                if (component.size() <= 1) continue;
                result.add(component.toArray());
            }
            return result;
        }

        private void DFS() {
            boolean NEXT_VERTEX = true;
            int START_DFS_VISIT = 2;
            int NEXT_ADJACENT = 3;
            int AFTER_NEXTED_DFS_VISIT = 4;
            Integer NEXT_VERTEX_OBJECT = new Integer(1);
            Integer AFTER_NEXTED_DFS_VISIT_OBJECT = new Integer(4);
            this.time = 0;
            ArrayList<Object> stack = new ArrayList<Object>(Math.max(1, this.vertexList.size()));
            Iterator allAdjacent = null;
            Vertex vertex = null;
            Iterator allV = this.vertexList.iterator();
            int state = 1;
            block6: while (true) {
                switch (state) {
                    case 1: {
                        if (!allV.hasNext()) break block6;
                        Vertex nextVertex = (Vertex)allV.next();
                        if (nextVertex.color == "white") {
                            stack.add(NEXT_VERTEX_OBJECT);
                            vertex = nextVertex;
                            state = 2;
                            continue block6;
                        }
                        state = 1;
                        continue block6;
                    }
                    case 2: {
                        vertex.color = "grey";
                        allAdjacent = vertex.adjacent.iterator();
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        if (allAdjacent.hasNext()) {
                            Vertex adjVertex = (Vertex)allAdjacent.next();
                            if (adjVertex.color == "white") {
                                adjVertex.predecessor = vertex;
                                stack.add(allAdjacent);
                                stack.add(vertex);
                                stack.add(AFTER_NEXTED_DFS_VISIT_OBJECT);
                                vertex = adjVertex;
                                state = 2;
                                continue block6;
                            }
                            if (adjVertex.color == "grey") {
                                this.cycles = true;
                            }
                            state = 3;
                            continue block6;
                        }
                        vertex.color = "black";
                        vertex.finishTime = ++this.time;
                        state = (Integer)stack.remove(stack.size() - 1);
                        continue block6;
                    }
                    case 4: {
                        vertex = (Vertex)stack.remove(stack.size() - 1);
                        allAdjacent = (Iterator)stack.remove(stack.size() - 1);
                        state = 3;
                        continue block6;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
        }

        public static class Vertex {
            public static final String WHITE = "white";
            public static final String GREY = "grey";
            public static final String BLACK = "black";
            public String color = "white";
            public Vertex predecessor = null;
            public int finishTime;
            public Object id;
            public List adjacent = new ArrayList(3);

            public Vertex(Object id) {
                this.id = id;
            }
        }
    }
}

