/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.search.FindDeclarationsAction;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ExtensionDetails
extends PDEDetails {
    private IPluginExtension input;
    private FormEntry id;
    private FormEntry name;
    private FormEntry point;
    private FormText rtext;
    private static final String RTEXT_DATA = PDEPlugin.getResourceString("ExtensionDetails.extensionPointLinks");

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        boolean paintedBorder = toolkit.getBorderStyle() != 2048;
        layout.topMargin = 0;
        layout.leftMargin = 5;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        parent.setLayout((Layout)layout);
        Section section = toolkit.createSection(parent, 384);
        section.clientVerticalSpacing = 4;
        section.marginHeight = 5;
        section.marginWidth = 5;
        section.setText(PDEPlugin.getResourceString("ExtensionDetails.title"));
        section.setDescription(PDEPlugin.getResourceString("ExtensionDetails.desc"));
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 2;
        glayout.marginWidth = 2;
        glayout.numColumns = 2;
        if (paintedBorder) {
            glayout.verticalSpacing = 7;
        }
        client.setLayout((Layout)glayout);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.id = new FormEntry(client, toolkit, PDEPlugin.getResourceString("ExtensionDetails.id"), null, false);
        this.id.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (ExtensionDetails.this.input != null) {
                    try {
                        ExtensionDetails.this.input.setId(ExtensionDetails.this.id.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.name = new FormEntry(client, toolkit, PDEPlugin.getResourceString("ExtensionDetails.name"), null, false);
        this.name.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (ExtensionDetails.this.input != null) {
                    try {
                        ExtensionDetails.this.input.setName(ExtensionDetails.this.name.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.point = new FormEntry(client, toolkit, PDEPlugin.getResourceString("ExtensionDetails.point"), null, false);
        this.point.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (ExtensionDetails.this.input != null) {
                    try {
                        ExtensionDetails.this.input.setPoint(ExtensionDetails.this.point.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.createSpacer(toolkit, client, 2);
        this.rtext = toolkit.createFormText(parent, true);
        td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        td.indent = 10;
        this.rtext.setLayoutData((Object)td);
        this.rtext.setImage("desc", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DOC_SECTION_OBJ));
        this.rtext.setImage("search", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PSEARCH_OBJ));
        this.rtext.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref().equals("search")) {
                    FindDeclarationsAction findDeclarationsAction = new FindDeclarationsAction(ExtensionDetails.this.input);
                    findDeclarationsAction.run();
                } else {
                    if (ExtensionDetails.this.input == null || ExtensionDetails.this.input.getPoint() == null) {
                        return;
                    }
                    IPluginExtensionPoint point = PDECore.getDefault().findExtensionPoint(ExtensionDetails.this.input.getPoint());
                    if (point != null) {
                        ShowDescriptionAction showDescAction = new ShowDescriptionAction(point);
                        showDescAction.run();
                    } else {
                        ExtensionDetails.this.showNoExtensionPointMessage();
                    }
                }
            }
        });
        this.rtext.setText(RTEXT_DATA, true, false);
        this.id.setEditable(this.isEditable());
        this.name.setEditable(this.isEditable());
        this.point.setEditable(this.isEditable());
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        this.markDetailsPart((Control)section);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (IPluginExtension)ssel.getFirstElement() : null;
        this.update();
    }

    private void update() {
        this.id.setValue(this.input != null ? this.input.getId() : null, true);
        this.name.setValue(this.input != null ? this.input.getName() : null, true);
        this.point.setValue(this.input != null ? this.input.getPoint() : null, true);
    }

    public void cancelEdit() {
        this.id.cancelEdit();
        this.name.cancelEdit();
        this.point.cancelEdit();
        super.cancelEdit();
    }

    public void commit(boolean onSave) {
        this.id.commit();
        this.name.commit();
        this.point.commit();
        super.commit(onSave);
    }

    public void setFocus() {
        this.id.getText().setFocus();
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object obj;
        if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]).equals(this.input)) {
            this.refresh();
        }
    }

    public void refresh() {
        this.update();
        super.refresh();
    }

    public void fireSaveNeeded() {
        this.markDirty();
        PDEFormPage page = (PDEFormPage)((Object)this.getManagedForm().getContainer());
        page.getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public String getContextId() {
        return "plugin-context";
    }

    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }

    private void showNoExtensionPointMessage() {
        String title = PDEPlugin.getResourceString("ExtensionDetails.noPoint.title");
        String message = PDEPlugin.getFormattedMessage("ShowDescriptionAction.noPoint.desc", this.input.getPoint());
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }
}

