/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.FileSystemExportOperation;

class WizardFileSystemResourceExportPage1
extends WizardExportResourcesPage
implements Listener {
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    protected Button overwriteExistingFilesCheckbox;
    protected Button createDirectoryStructureButton;
    protected Button createSelectionOnlyButton;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardFileSystemResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "WizardFileSystemResourceExportPage1.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardFileSystemResourceExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String SELECT_DESTINATION_MESSAGE = DataTransferMessages.getString("FileExport.selectDestinationMessage");
    private static final String SELECT_DESTINATION_TITLE = DataTransferMessages.getString("FileExport.selectDestinationTitle");

    protected WizardFileSystemResourceExportPage1(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardFileSystemResourceExportPage1(IStructuredSelection selection) {
        this("fileSystemExportPage1", selection);
        this.setTitle(DataTransferMessages.getString("DataTransfer.fileSystemTitle"));
        this.setDescription(DataTransferMessages.getString("FileExport.exportLocalFileSystem"));
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.giveFocusToDestination();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.file_system_export_wizard_page");
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(this.getDestinationLabel());
        destinationLabel.setFont(font);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(font);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(DataTransferMessages.getString("DataTransfer.browse"));
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(parent, 0);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        this.createOverwriteExisting(optionsGroup, font);
        this.createDirectoryStructureOptions(optionsGroup, font);
    }

    protected void createDirectoryStructureOptions(Group optionsGroup, Font font) {
        this.createDirectoryStructureButton = new Button((Composite)optionsGroup, 16400);
        this.createDirectoryStructureButton.setText(DataTransferMessages.getString("FileExport.createDirectoryStructure"));
        this.createDirectoryStructureButton.setSelection(false);
        this.createDirectoryStructureButton.setFont(font);
        this.createSelectionOnlyButton = new Button((Composite)optionsGroup, 16400);
        this.createSelectionOnlyButton.setText(DataTransferMessages.getString("FileExport.createSelectedDirectories"));
        this.createSelectionOnlyButton.setSelection(true);
        this.createSelectionOnlyButton.setFont(font);
    }

    protected void createOverwriteExisting(Group optionsGroup, Font font) {
        this.overwriteExistingFilesCheckbox = new Button((Composite)optionsGroup, 16416);
        this.overwriteExistingFilesCheckbox.setText(DataTransferMessages.getString("ExportFile.overwriteExisting"));
        this.overwriteExistingFilesCheckbox.setFont(font);
    }

    protected boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            if (!this.queryYesNoQuestion(DataTransferMessages.getString("DataTransfer.createTargetDirectory"))) {
                return false;
            }
            if (!directory.mkdirs()) {
                this.displayErrorDialog(DataTransferMessages.getString("DataTransfer.directoryCreationError"));
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File targetDirectory) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.getString("FileExport.directoryExists"));
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(targetDirectory);
    }

    protected boolean executeExportOperation(FileSystemExportOperation op) {
        op.setCreateLeadupStructure(this.createDirectoryStructureButton.getSelection());
        op.setOverwriteFiles(this.overwriteExistingFilesCheckbox.getSelection());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.exportProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureTargetIsValid(new File(this.getDestinationValue()))) {
            return false;
        }
        List resourcesToExport = this.getWhiteCheckedResources();
        this.saveDirtyEditors();
        this.saveWidgetValues();
        if (resourcesToExport.size() > 0) {
            return this.executeExportOperation(new FileSystemExportOperation(null, resourcesToExport, this.getDestinationValue(), this));
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.information"), (String)DataTransferMessages.getString("FileExport.noneSelected"));
        return false;
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.getString("FileExport.toDirectory");
    }

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 8192);
        dialog.setMessage(SELECT_DESTINATION_MESSAGE);
        dialog.setText(SELECT_DESTINATION_TITLE);
        dialog.setFilterPath(this.getDestinationValue());
        String selectedDirectoryName = dialog.open();
        if (selectedDirectoryName != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(selectedDirectoryName);
        }
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            for (int i = 0; i < directoryNames.length; ++i) {
                this.addDestinationItem(directoryNames[i]);
            }
            this.overwriteExistingFilesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
            boolean createDirectories = settings.getBoolean(STORE_CREATE_STRUCTURE_ID);
            this.createDirectoryStructureButton.setSelection(createDirectories);
            this.createSelectionOnlyButton.setSelection(!createDirectories);
        }
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.length() == 0) {
            this.setMessage(this.destinationEmptyMessage());
            return false;
        }
        String conflictingContainer = this.getConflictingContainerNameFor(destinationValue);
        if (conflictingContainer != null) {
            this.setErrorMessage(DataTransferMessages.format("FileExport.conflictingContainer", new Object[]{conflictingContainer}));
            this.giveFocusToDestination();
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected String destinationEmptyMessage() {
        return DataTransferMessages.getString("FileExport.destinationEmpty");
    }

    protected String getConflictingContainerNameFor(String targetDirectory) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path testPath = new Path(targetDirectory);
        if (root.getLocation().isPrefixOf((IPath)testPath)) {
            return DataTransferMessages.getString("FileExport.rootName");
        }
        IProject[] projects = root.getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].getLocation().isPrefixOf((IPath)testPath)) continue;
            return projects[i].getName();
        }
        return null;
    }
}

