/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IViewDescriptor;

class LayoutHelper {
    private LayoutHelper() {
    }

    public static final void addViewActivator(PageLayout pageLayout, final String viewId) {
        if (viewId == null) {
            return;
        }
        ViewFactory viewFactory = pageLayout.getViewFactory();
        final WorkbenchPage partPage = viewFactory.getWorkbenchPage();
        if (partPage == null) {
            return;
        }
        final IPerspectiveDescriptor partPerspective = pageLayout.getDescriptor();
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        IViewDescriptor descriptor = viewFactory.getViewRegistry().find(viewId);
        if (!(descriptor instanceof IPluginContribution)) {
            return;
        }
        IIdentifier identifier = support.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)((Object)descriptor)));
        identifier.addIdentifierListener(new IIdentifierListener(){

            public void identifierChanged(IdentifierEvent identifierEvent) {
                IIdentifier thisIdentifier;
                if (identifierEvent.hasEnabledChanged() && (thisIdentifier = identifierEvent.getIdentifier()).isEnabled()) {
                    thisIdentifier.removeIdentifierListener(this);
                    IWorkbenchPage activePage = partPage.getWorkbenchWindow().getActivePage();
                    if (partPage == activePage && partPerspective == activePage.getPerspective()) {
                        try {
                            partPage.showView(viewId);
                        }
                        catch (PartInitException e) {
                            WorkbenchPlugin.log(e.getMessage());
                        }
                    } else {
                        partPage.getWorkbenchWindow().addPerspectiveListener(new IPerspectiveListener(this){
                            private final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = this$0;
                            }

                            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor newPerspective) {
                                if (1.access$000(this.this$0) == newPerspective) {
                                    1.access$100(this.this$0).getWorkbenchWindow().removePerspectiveListener(this);
                                    try {
                                        page.showView(1.access$200(this.this$0));
                                    }
                                    catch (PartInitException e) {
                                        WorkbenchPlugin.log(e.getMessage());
                                    }
                                }
                            }

                            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                            }
                        });
                    }
                }
            }

            static /* synthetic */ IPerspectiveDescriptor access$000(1 x0) {
                return x0.partPerspective;
            }

            static /* synthetic */ IWorkbenchPage access$100(1 x0) {
                return x0.partPage;
            }

            static /* synthetic */ String access$200(1 x0) {
                return x0.viewId;
            }
        });
    }

    public static final ViewPane createView(ViewFactory factory, String viewId) throws PartInitException {
        WorkbenchPartReference ref = (WorkbenchPartReference)((Object)factory.createView(viewId));
        ViewPane newPart = (ViewPane)ref.getPane();
        if (newPart == null) {
            WorkbenchPage page = (WorkbenchPage)ref.getPage();
            newPart = new ViewPane((IViewReference)((Object)ref), page);
            ref.setPane(newPart);
        }
        return newPart;
    }

    public static final ViewPane createView(ViewFactory factory, String viewId, String theme) throws PartInitException {
        WorkbenchPartReference ref = (WorkbenchPartReference)((Object)factory.createView(viewId));
        ViewPane newPart = (ViewPane)ref.getPane();
        if (newPart == null) {
            WorkbenchPage page = (WorkbenchPage)ref.getPage();
            newPart = new ViewPane((IViewReference)((Object)ref), page);
            ref.setPane(newPart);
        }
        return newPart;
    }
}

