/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class SaveableHelper {
    private static int AutomatedResponse = -1;

    public static void testSetAutomatedResponse(int response) {
        AutomatedResponse = response;
    }

    static boolean savePart(final ISaveablePart saveable, IWorkbenchPart part, IWorkbenchWindow window, boolean confirm) {
        if (!saveable.isDirty()) {
            return true;
        }
        if (confirm) {
            int choice = AutomatedResponse;
            if (choice == -1) {
                String message = WorkbenchMessages.format("EditorManager.saveChangesQuestion", new Object[]{part.getTitle()});
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog d = new MessageDialog(window.getShell(), WorkbenchMessages.getString("Save_Resource"), null, message, 3, buttons, 0);
                choice = d.open();
            }
            switch (choice) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                saveable.doSave((IProgressMonitor)monitorWrap);
            }
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.getString("Save"), progressOp, window);
    }

    static boolean runProgressMonitorOperation(String opName, final IRunnableWithProgress progressOp, IWorkbenchWindow window) {
        Object ctx = window instanceof ApplicationWindow ? window : new ProgressMonitorJobsDialog(window.getShell());
        final boolean[] wasCanceled = new boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                progressOp.run(monitor);
                wasCanceled[0] = monitor.isCanceled();
            }
        };
        try {
            ctx.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            String title = WorkbenchMessages.format("EditorManager.operationFailed", new Object[]{opName});
            Throwable targetExc = e.getTargetException();
            WorkbenchPlugin.log(title, (IStatus)new Status(2, "org.eclipse.ui", 0, title, targetExc));
            MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchMessages.getString("Error"), (String)(title + ':' + targetExc.getMessage()));
        }
        catch (InterruptedException e) {
            wasCanceled[0] = true;
        }
        return !wasCanceled[0];
    }
}

