/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;
import org.eclipse.pde.internal.build.site.PluginPathFinder;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;

public class BuildTimeSiteFactory
extends BaseSiteFactory
implements ISiteFactory,
IPDEBuildConstants {
    private Site site = null;
    private boolean urlsChanged = false;
    private String[] sitePaths;
    private static String installedBaseLocation = null;

    public ISite createSite() throws CoreException {
        if (this.site != null && !this.urlsChanged) {
            return this.site;
        }
        this.urlsChanged = false;
        this.site = (Site)this.createSiteMapModel();
        Collection featureXMLs = this.findFeatureXMLs();
        String installedBaseURL = null;
        if (installedBaseLocation != null && !installedBaseLocation.equals("")) {
            if (!new File(installedBaseLocation).exists()) {
                String message = Policy.bind("error.incorrectDirectoryEntry", installedBaseLocation);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 6, message, null));
            }
            installedBaseURL = installedBaseLocation;
            Collection installedFeatures = Utils.findFiles(installedBaseLocation, "features", "feature.xml");
            if (installedFeatures != null) {
                featureXMLs.addAll(installedFeatures);
            }
            String[] linkPaths = PluginPathFinder.getPluginPaths(installedBaseURL);
            for (int i = 0; i < linkPaths.length; ++i) {
                Collection foundFeatures = Utils.findFiles(linkPaths[i], "features", "feature.xml");
                if (foundFeatures == null) continue;
                featureXMLs.addAll(foundFeatures);
            }
        }
        Iterator iter = featureXMLs.iterator();
        while (iter.hasNext()) {
            File featureXML = (File)iter.next();
            if (!featureXML.exists()) continue;
            try {
                URL featureURL = new URL("file:" + featureXML.getAbsolutePath());
                SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                featureRef.setSiteModel((SiteModel)this.site);
                featureRef.setURLString(featureURL.toExternalForm());
                featureRef.setType("org.eclipse.pde.build.BuildTimeFeatureFactory");
                this.site.addFeatureReferenceModel(featureRef);
            }
            catch (MalformedURLException e) {
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 20, Policy.bind("warning.cannotLocateSource", featureXML.getAbsolutePath()), (Throwable)e));
            }
        }
        BuildTimeSiteContentProvider contentProvider = new BuildTimeSiteContentProvider(this.sitePaths, installedBaseURL);
        this.site.setSiteContentProvider((ISiteContentProvider)contentProvider);
        contentProvider.setSite((ISite)this.site);
        return this.site;
    }

    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        String message = Policy.bind("error.incorrectDirectoryEntry");
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 6, message, null));
    }

    public SiteModel createSiteMapModel() {
        return new BuildTimeSite();
    }

    public static void setInstalledBaseSite(String installedBaseSite) {
        installedBaseLocation = installedBaseSite;
    }

    public void setSitePaths(String[] urls) {
        if (this.sitePaths == null) {
            this.sitePaths = urls;
            this.urlsChanged = true;
            return;
        }
        boolean found = true;
        block0: for (int i = 0; found && i < this.sitePaths.length; ++i) {
            found = false;
            for (int j = 0; j < urls.length; ++j) {
                if (!this.sitePaths[i].equals(urls[j])) continue;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            this.sitePaths = urls;
            this.urlsChanged = true;
        }
    }

    private Collection findFeatureXMLs() {
        ArrayList features = new ArrayList();
        for (int i = 0; i < this.sitePaths.length; ++i) {
            Collection foundFeatures = Utils.findFiles(this.sitePaths[i], "features", "feature.xml");
            if (foundFeatures == null) continue;
            features.addAll(foundFeatures);
        }
        return features;
    }
}

