/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RestoreAction
extends QuickDiffRestoreAction {
    private static final String PREFIX = "RestoreAction.";
    private static final String SINGLE_KEY = "RestoreAction.label";
    private static final String MULTIPLE_KEY = "RestoreAction.multiple.label";
    private int fLine;

    public RestoreAction(ITextEditor editor) {
        super(QuickDiffMessages.getResourceBundle(), PREFIX, editor);
    }

    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
        IVerticalRulerInfo ruler = this.getRuler();
        if (ruler == null) {
            return;
        }
        this.fLine = ruler.getLineOfLastMouseButtonActivity();
        ILineDiffer differ = this.getDiffer();
        if (differ == null) {
            return;
        }
        ILineDiffInfo info = differ.getLineInfo(this.fLine);
        if (info != null && (info.getRemovedLinesAbove() > 0 || info.getRemovedLinesBelow() > 0)) {
            if (info.getRemovedLinesBelow() == 0) {
                --this.fLine;
            } else if (info.getRemovedLinesAbove() != 0) {
                // empty if block
            }
            info = differ.getLineInfo(this.fLine);
            if (info.getRemovedLinesBelow() == 1) {
                this.setText(QuickDiffMessages.getString(SINGLE_KEY));
            } else {
                this.setText(QuickDiffMessages.getFormattedString(MULTIPLE_KEY, String.valueOf(info.getRemovedLinesBelow())));
            }
            this.setEnabled(true);
        }
    }

    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ != null) {
            try {
                differ.restoreAfterLine(this.fLine);
            }
            catch (BadLocationException e) {
                this.setStatus(e.getMessage());
            }
        }
    }
}

