/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RevertBlockAction
extends QuickDiffRestoreAction {
    private static final String PREFIX = "RevertBlockAction.";
    private int fLine;

    public RevertBlockAction(ITextEditor editor) {
        super(QuickDiffMessages.getResourceBundle(), PREFIX, editor);
    }

    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
        IVerticalRulerInfo ruler = this.getRuler();
        if (ruler == null) {
            return;
        }
        this.fLine = ruler.getLineOfLastMouseButtonActivity();
        ILineDiffer differ = this.getDiffer();
        if (differ == null) {
            return;
        }
        ILineDiffInfo info = differ.getLineInfo(this.fLine);
        if (info != null && info.getChangeType() != 0) {
            boolean hasBlock = false;
            if (this.fLine > 0) {
                info = differ.getLineInfo(this.fLine - 1);
                boolean bl = hasBlock = info != null && info.hasChanges();
            }
            if (!hasBlock) {
                info = differ.getLineInfo(this.fLine + 1);
                boolean bl = hasBlock = info != null && info.hasChanges();
            }
            if (hasBlock) {
                this.setEnabled(true);
            }
        }
    }

    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ != null) {
            try {
                differ.revertBlock(this.fLine);
            }
            catch (BadLocationException e) {
                this.setStatus(e.getMessage());
            }
        }
    }
}

