/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;

public class ProjectionAnnotationModel
extends AnnotationModel {
    public void collapse(Annotation annotation) {
        ProjectionAnnotation projection;
        if (annotation instanceof ProjectionAnnotation && !(projection = (ProjectionAnnotation)annotation).isCollapsed()) {
            projection.markCollapsed();
            this.modifyAnnotation(projection, true);
        }
    }

    public void expand(Annotation annotation) {
        ProjectionAnnotation projection;
        if (annotation instanceof ProjectionAnnotation && (projection = (ProjectionAnnotation)annotation).isCollapsed()) {
            projection.markExpanded();
            this.modifyAnnotation(projection, true);
        }
    }

    public void toggleExpansionState(Annotation annotation) {
        if (annotation instanceof ProjectionAnnotation) {
            ProjectionAnnotation projection = (ProjectionAnnotation)annotation;
            if (projection.isCollapsed()) {
                projection.markExpanded();
            } else {
                projection.markCollapsed();
            }
            this.modifyAnnotation(projection, true);
        }
    }

    public boolean expandAll(int offset, int length) {
        return this.expandAll(offset, length, true);
    }

    protected boolean expandAll(int offset, int length, boolean fireModelChanged) {
        boolean expanding = false;
        Iterator iterator = this.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            ProjectionAnnotation annotation = (ProjectionAnnotation)iterator.next();
            if (!annotation.isCollapsed() || (position = this.getPosition(annotation)) == null || !position.overlapsWith(offset, length)) continue;
            annotation.markExpanded();
            this.modifyAnnotation(annotation, false);
            expanding = true;
        }
        if (expanding && fireModelChanged) {
            this.fireModelChanged();
        }
        return expanding;
    }

    public void modifyAnnotations(Annotation[] deletions, Map additions, Annotation[] modifications) {
        try {
            this.replaceAnnotations(deletions, additions, false);
            if (modifications != null) {
                for (int i = 0; i < modifications.length; ++i) {
                    this.modifyAnnotation(modifications[i], false);
                }
            }
        }
        catch (BadLocationException x) {
            // empty catch block
        }
        this.fireModelChanged();
    }
}

