/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    int formHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int trimX = x - border;
        int trimY = y - border;
        int trimWidth = width + border * 2;
        int trimHeight = height + border * 2;
        if (this.horizontalBar != null) {
            trimY -= this.display.scrolledInsetY;
            trimHeight += this.display.scrolledInsetY + this.display.scrolledMarginY;
            if (this.verticalBar == null) {
                trimX -= this.display.scrolledInsetX;
                trimWidth += this.display.scrolledInsetX * 2;
                trimHeight -= this.display.scrolledInsetY * 2;
            }
        }
        if (this.verticalBar != null) {
            trimX -= this.display.scrolledInsetX;
            trimWidth += this.display.scrolledInsetX + this.display.scrolledMarginX;
            if (this.horizontalBar == null) {
                trimY -= this.display.scrolledInsetY;
                trimHeight += this.display.scrolledInsetY * 2;
                trimWidth -= this.display.scrolledInsetX * 2;
            }
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    ScrollBar createScrollBar(int type) {
        return new ScrollBar(this, type);
    }

    ScrollBar createStandardBar(int style) {
        if (this.scrolledHandle == 0) {
            return null;
        }
        ScrollBar bar = new ScrollBar();
        bar.parent = this;
        bar.style = style;
        bar.display = this.display;
        bar.state |= 8;
        int[] argList = new int[]{OS.XmNhorizontalScrollBar, 0, OS.XmNverticalScrollBar, 0};
        OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
        if (style == 256) {
            bar.handle = argList[1];
        }
        if (style == 512) {
            bar.handle = argList[3];
        }
        bar.hookEvents();
        bar.register();
        return bar;
    }

    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.formHandle != 0) {
            this.display.removeWidget(this.formHandle);
        }
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        if (this.formHandle != 0) {
            this.enableHandle(enabled, this.formHandle);
        }
        if (this.scrolledHandle != 0) {
            this.enableHandle(enabled, this.scrolledHandle);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return new Rectangle(0, 0, argList[1], argList[3]);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void manageChildren() {
        int[] argList;
        if (this.scrolledHandle != 0) {
            OS.XtSetMappedWhenManaged(this.scrolledHandle, false);
            OS.XtManageChild(this.scrolledHandle);
        }
        if (this.formHandle != 0) {
            OS.XtSetMappedWhenManaged(this.formHandle, false);
            OS.XtManageChild(this.formHandle);
        }
        super.manageChildren();
        if (this.formHandle != 0) {
            argList = new int[]{OS.XmNborderWidth, 0};
            OS.XtGetValues(this.formHandle, argList, argList.length / 2);
            OS.XtResizeWidget(this.formHandle, 1, 1, argList[1]);
            OS.XtSetMappedWhenManaged(this.formHandle, true);
        }
        if (this.scrolledHandle != 0) {
            argList = new int[]{OS.XmNborderWidth, 0};
            OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
            OS.XtResizeWidget(this.scrolledHandle, 1, 1, argList[1]);
            OS.XtSetMappedWhenManaged(this.scrolledHandle, true);
        }
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        if (this.formHandle != 0) {
            this.propagateHandle(enabled, this.formHandle, 0);
        }
        if (this.scrolledHandle != 0) {
            this.propagateHandle(enabled, this.scrolledHandle, 0);
            if (this.horizontalBar != null) {
                this.horizontalBar.propagateWidget(enabled);
            }
            if (this.verticalBar != null) {
                this.verticalBar.propagateWidget(enabled);
            }
        }
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        super.redrawWidget(x, y, width, height, all);
    }

    void register() {
        super.register();
        if (this.formHandle != 0) {
            this.display.addWidget(this.formHandle, this);
        }
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.formHandle = 0;
        this.scrolledHandle = 0;
    }

    void releaseWidget() {
        if (this.horizontalBar != null) {
            this.horizontalBar.releaseResources();
        }
        if (this.verticalBar != null) {
            this.verticalBar.releaseResources();
        }
        this.verticalBar = null;
        this.horizontalBar = null;
        super.releaseWidget();
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        if (this.scrolledHandle != 0) {
            int[] argList1 = new int[]{OS.XmNhorizontalScrollBar, 0, OS.XmNverticalScrollBar, 0};
            OS.XtGetValues(this.scrolledHandle, argList1, argList1.length / 2);
            if (argList1[1] != 0) {
                OS.XmChangeColor(argList1[1], pixel);
            }
            if (argList1[3] != 0) {
                OS.XmChangeColor(argList1[3], pixel);
            }
        }
    }

    void setScrollbarVisible(ScrollBar bar, boolean visible) {
        if (this.scrolledHandle == 0) {
            return;
        }
        int barHandle = bar.handle;
        boolean managed = OS.XtIsManaged(barHandle);
        if (managed == visible) {
            return;
        }
        int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
        OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
        if (visible) {
            OS.XtManageChild(barHandle);
        } else {
            OS.XtUnmanageChild(barHandle);
        }
        OS.XtSetValues(this.scrolledHandle, argList, argList.length / 2);
        this.sendEvent(11);
        bar.sendEvent(visible ? 22 : 23);
    }

    int topHandle() {
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        if (this.formHandle != 0) {
            return this.formHandle;
        }
        return this.handle;
    }
}

