/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.SiteManager;

public class ConfigurationLogUpdateSection
implements ISystemSummarySection {
    public void write(PrintWriter writer) {
        ILocalSite site;
        try {
            site = SiteManager.getLocalSite();
        }
        catch (CoreException e) {
            e.printStackTrace(writer);
            return;
        }
        IInstallConfiguration[] configurations = site.getConfigurationHistory();
        for (int i = 0; i < configurations.length; ++i) {
            writer.println();
            if (i > 0) {
                writer.println("----------------------------------------------------");
            }
            writer.println(IDEWorkbenchMessages.format("SystemSummary.configuration", new Object[]{configurations[i].getLabel()}));
            writer.println(IDEWorkbenchMessages.format("SystemSummary.isCurrentConfiguration", new Object[]{new Boolean(configurations[i].isCurrent())}));
            IActivity[] activities = configurations[i].getActivities();
            for (int j = 0; j < activities.length; ++j) {
                writer.println();
                writer.println(IDEWorkbenchMessages.format("SystemSummary.date", new Object[]{activities[j].getDate()}));
                writer.println(IDEWorkbenchMessages.format("SystemSummary.target", new Object[]{activities[j].getLabel()}));
                writer.println(IDEWorkbenchMessages.format("SystemSummary.action", new Object[]{this.getActionLabel(activities[j])}));
                writer.println(IDEWorkbenchMessages.format("SystemSummary.status", new Object[]{this.getStatusLabel(activities[j])}));
            }
        }
    }

    private String getActionLabel(IActivity activity) {
        int action = activity.getAction();
        switch (action) {
            case 6: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.enabled");
            }
            case 1: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.featureInstalled");
            }
            case 2: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.featureRemoved");
            }
            case 3: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.siteInstalled");
            }
            case 4: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.siteRemoved");
            }
            case 5: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.disabled");
            }
            case 7: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.revert");
            }
            case 8: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.reconcile");
            }
            case 9: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.preserved");
            }
        }
        return IDEWorkbenchMessages.getString("SystemSummary.activity.unknown");
    }

    private String getStatusLabel(IActivity activity) {
        switch (activity.getStatus()) {
            case 0: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.status.success");
            }
            case 1: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.status.failure");
            }
        }
        return IDEWorkbenchMessages.getString("SystemSummary.activity.status.unknown");
    }
}

