/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.plugin.PluginLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractPluginModelBase
extends AbstractModel
implements IPluginModelBase,
IPluginModelFactory {
    protected PluginBase pluginBase;
    private boolean enabled;
    private boolean reconcilingModel = false;
    private BundleDescription fBundleDescription;

    public abstract IPluginBase createPluginBase();

    public IExtensions createExtensions() {
        return this.createPluginBase();
    }

    public IExtensionsModelFactory getFactory() {
        return this;
    }

    public IPluginModelFactory getPluginFactory() {
        return this;
    }

    public IPluginBase getPluginBase() {
        return this.getPluginBase(true);
    }

    public IPluginBase getPluginBase(boolean createIfMissing) {
        if (this.pluginBase == null && createIfMissing) {
            this.pluginBase = (PluginBase)this.createPluginBase();
            this.loaded = true;
        }
        return this.pluginBase;
    }

    public IExtensions getExtensions() {
        return this.getPluginBase();
    }

    public IExtensions getExtensions(boolean createIfMissing) {
        return this.getPluginBase(createIfMissing);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isFragmentModel() {
        return false;
    }

    public abstract URL getNLLookupLocation();

    protected URL[] getNLLookupLocations() {
        URL thisLocation = this.getNLLookupLocation();
        if (this.isFragmentModel()) {
            if (thisLocation != null) {
                return new URL[]{thisLocation};
            }
            return new URL[0];
        }
        URL[] fragmentLocations = this.getFragmentLocations();
        URL[] locations = new URL[(thisLocation != null ? 1 : 0) + fragmentLocations.length];
        if (thisLocation != null) {
            locations[0] = thisLocation;
        }
        for (int i = 1; i < locations.length; ++i) {
            locations[i] = fragmentLocations[i - 1];
        }
        return locations;
    }

    protected URL[] getFragmentLocations() {
        Vector result = new Vector();
        if (this.pluginBase != null) {
            String id = this.pluginBase.getId();
            String version = this.pluginBase.getVersion();
            this.addMatchingFragments(PDECore.getDefault().findFragmentsFor(id, version), result);
        }
        Object[] locations = new URL[result.size()];
        result.copyInto(locations);
        return locations;
    }

    private void addMatchingFragments(IFragment[] fragments, Vector result) {
        for (int i = 0; i < fragments.length; ++i) {
            IFragment fragment = fragments[i];
            URL location = ((IFragmentModel)fragment.getModel()).getNLLookupLocation();
            if (location == null) continue;
            IPluginLibrary[] libraries = fragment.getLibraries();
            for (int j = 0; j < libraries.length; ++j) {
                try {
                    result.add(new URL(location, libraries[j].getName()));
                    continue;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
    }

    public void load(InputStream stream, boolean outOfSync) throws CoreException {
        if (this.pluginBase == null) {
            this.pluginBase = (PluginBase)this.createPluginBase();
            this.pluginBase.setModel(this);
        }
        this.pluginBase.reset();
        this.loaded = false;
        try {
            SAXParser parser = this.getSaxParser();
            XMLDefaultHandler handler = new XMLDefaultHandler();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(stream, (DefaultHandler)handler);
            this.processDocument(handler.getDocument(), handler.getLineTable());
            this.loaded = true;
            if (!outOfSync) {
                this.updateTimeStamp();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processDocument(Document doc, Hashtable lineTable) {
        String schemaVersion = this.processSchemaVersion(doc);
        Element pluginNode = doc.getDocumentElement();
        this.pluginBase.load(pluginNode, schemaVersion, lineTable);
    }

    private String processSchemaVersion(Document doc) {
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            int end;
            String key;
            int loc;
            String data;
            ProcessingInstruction pi;
            String target;
            Node node = children.item(i);
            if (node.getNodeType() != 7 || !(target = (pi = (ProcessingInstruction)node).getTarget()).equals("eclipse") || (data = pi.getData()) == null || (loc = (data = data.trim().toLowerCase()).indexOf(61)) == -1 || !(key = data.substring(0, loc)).equals("version")) continue;
            int start = loc + 1;
            if (data.charAt(start) == '\"') {
                ++start;
            }
            if (data.charAt(end = data.length() - 1) == '\"') {
                --end;
            }
            return data.substring(start, end + 1);
        }
        return null;
    }

    public void reload(InputStream stream, boolean outOfSync) throws CoreException {
        this.load(stream, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(this, 99, new Object[]{this.pluginBase}, null));
    }

    public void setEnabled(boolean newEnabled) {
        this.enabled = newEnabled;
    }

    public String toString() {
        IPluginBase pluginBase = this.getPluginBase();
        if (pluginBase != null) {
            return pluginBase.getTranslatedName();
        }
        return super.toString();
    }

    protected abstract void updateTimeStamp();

    public IPluginAttribute createAttribute(IPluginElement element) {
        PluginAttribute attribute = new PluginAttribute();
        attribute.setModel(this);
        attribute.setParent(element);
        return attribute;
    }

    public IPluginElement createElement(IPluginObject parent) {
        PluginElement element = new PluginElement();
        element.setModel(this);
        element.setParent(parent);
        return element;
    }

    public IPluginExtension createExtension() {
        PluginExtension extension = new PluginExtension();
        extension.setParent(this.getPluginBase());
        extension.setModel(this);
        return extension;
    }

    public IPluginExtensionPoint createExtensionPoint() {
        PluginExtensionPoint extensionPoint = new PluginExtensionPoint();
        extensionPoint.setModel(this);
        extensionPoint.setParent(this.getPluginBase());
        return extensionPoint;
    }

    public IPluginImport createImport() {
        PluginImport iimport = new PluginImport();
        iimport.setModel(this);
        iimport.setParent(this.getPluginBase());
        return iimport;
    }

    public IPluginLibrary createLibrary() {
        PluginLibrary library = new PluginLibrary();
        library.setModel(this);
        library.setParent(this.getPluginBase());
        return library;
    }

    public boolean isValid() {
        if (!this.isLoaded()) {
            return false;
        }
        if (this.pluginBase == null) {
            return false;
        }
        return this.pluginBase.isValid();
    }

    public boolean isReconcilingModel() {
        return this.reconcilingModel;
    }

    public void setReconcilingModel(boolean reconcilingModel) {
        this.reconcilingModel = reconcilingModel;
    }

    public boolean isBundleModel() {
        return false;
    }

    public void dispose() {
        this.fBundleDescription = null;
        super.dispose();
    }

    public BundleDescription getBundleDescription() {
        return this.fBundleDescription;
    }

    public void setBundleDescription(BundleDescription description) {
        this.fBundleDescription = description;
    }
}

