/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginParent;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class PluginElement
extends PluginParent
implements IPluginElement {
    private transient ISchemaElement elementInfo;
    private String text;
    static final String ATTRIBUTE_SHIFT = "      ";
    static final String ELEMENT_SHIFT = "   ";
    private Hashtable attributes = new Hashtable();

    public PluginElement() {
    }

    PluginElement(PluginElement element) {
        this.setModel(element.getModel());
        this.setParent(element.getParent());
        this.name = element.getName();
        IPluginAttribute[] atts = element.getAttributes();
        for (int i = 0; i < atts.length; ++i) {
            PluginAttribute att = (PluginAttribute)atts[i];
            this.attributes.put(att.getName(), att.clone());
        }
        this.text = element.getText();
        this.elementInfo = (ISchemaElement)element.getElementInfo();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IPluginElement) {
            IPluginElement target = (IPluginElement)obj;
            if (target.getModel().equals(this.getModel())) {
                return false;
            }
            if (target.getAttributeCount() != this.getAttributeCount()) {
                return false;
            }
            IPluginAttribute[] tatts = target.getAttributes();
            for (int i = 0; i < tatts.length; ++i) {
                IPluginAttribute tatt = tatts[i];
                if (tatt.equals(this.attributes.get(tatt.getName()))) continue;
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    public IPluginElement createCopy() {
        return new PluginElement(this);
    }

    public IPluginAttribute getAttribute(String name) {
        return (IPluginAttribute)this.attributes.get(name);
    }

    public IPluginAttribute[] getAttributes() {
        Collection values = this.attributes.values();
        IPluginAttribute[] result = new IPluginAttribute[values.size()];
        return values.toArray(result);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public Object getElementInfo() {
        ISchema schema;
        if (this.elementInfo != null && (schema = this.elementInfo.getSchema()).isDisposed()) {
            this.elementInfo = null;
        }
        if (this.elementInfo == null) {
            PluginExtension extension;
            ISchema schema2;
            IPluginObject parent;
            for (parent = this.getParent(); parent != null && !(parent instanceof IPluginExtension); parent = parent.getParent()) {
            }
            if (parent != null && (schema2 = (ISchema)(extension = (PluginExtension)parent).getSchema()) != null) {
                this.elementInfo = schema2.findElement(this.getName());
            }
        }
        return this.elementInfo;
    }

    public String getText() {
        return this.text;
    }

    void load(String tagName, Attributes attributes) {
        this.name = tagName;
        for (int i = 0; i < attributes.getLength(); ++i) {
            IPluginAttribute att = this.getModel().getFactory().createAttribute(this);
            ((PluginAttribute)att).load(attributes.getQName(i), attributes.getValue(i));
            this.attributes.put(attributes.getQName(i), att);
        }
    }

    public void reconnect() {
        super.reconnect();
        this.reconnectAttributes();
    }

    private void reconnectAttributes() {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            PluginAttribute att = (PluginAttribute)enumeration.nextElement();
            att.setModel(this.getModel());
            att.setParent(this);
            att.setInTheModel(true);
        }
    }

    void load(Node node, Hashtable lineTable) {
        this.name = node.getNodeName();
        NamedNodeMap attributes = node.getAttributes();
        this.bindSourceLocation(node, lineTable);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            IPluginAttribute att = this.getModel().getFactory().createAttribute(this);
            ((PluginAttribute)att).load(attribute, lineTable);
            ((PluginAttribute)att).setInTheModel(true);
            this.attributes.put(attribute.getNodeName(), att);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                PluginElement childElement = new PluginElement();
                childElement.setModel(this.getModel());
                childElement.setInTheModel(true);
                this.children.add(childElement);
                childElement.setParent(this);
                childElement.load(child, lineTable);
                continue;
            }
            if (child.getNodeType() != 3 || child.getNodeValue() == null) continue;
            String text = child.getNodeValue();
            if (!PluginElement.isNotEmpty(text = text.trim())) continue;
            this.text = text;
        }
    }

    public void removeAttribute(String name) throws CoreException {
        this.ensureModelEditable();
        PluginAttribute att = (PluginAttribute)this.attributes.remove(name);
        String oldValue = att.getValue();
        if (att != null) {
            att.setInTheModel(false);
        }
        this.firePropertyChanged("attribute", oldValue, null);
    }

    public void replaceAttributes(Hashtable newAttributes) throws CoreException {
        this.ensureModelEditable();
        Hashtable oldValue = this.attributes;
        this.setAttributesInTheModel(this.attributes, false);
        this.attributes = newAttributes;
        this.setAttributesInTheModel(newAttributes, true);
        this.firePropertyChanged("attributes", oldValue, this.attributes);
    }

    private void setAttributesInTheModel(Hashtable table, boolean value) {
        if (table != null) {
            Enumeration enumeration = table.elements();
            while (enumeration.hasMoreElements()) {
                PluginAttribute att = (PluginAttribute)enumeration.nextElement();
                att.setInTheModel(value);
            }
        }
    }

    public void setAttribute(String name, String value) throws CoreException {
        this.ensureModelEditable();
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        IPluginAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            attribute = this.getModel().getFactory().createAttribute(this);
            attribute.setName(name);
            this.attributes.put(name, attribute);
            ((PluginAttribute)attribute).setInTheModel(true);
        }
        attribute.setValue(value);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        super.restoreProperty(name, oldValue, newValue);
    }

    public void setElementInfo(ISchemaElement newElementInfo) {
        this.elementInfo = newElementInfo;
        if (this.elementInfo == null) {
            Enumeration atts = this.attributes.elements();
            while (atts.hasMoreElements()) {
                PluginAttribute att = (PluginAttribute)atts.nextElement();
                att.setAttributeInfo(null);
            }
        }
    }

    public void setText(String newText) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.text;
        this.text = newText;
        this.firePropertyChanged("text", oldValue, this.text);
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.print("<" + this.getName());
        String newIndent = indent + ATTRIBUTE_SHIFT;
        if (!this.attributes.isEmpty()) {
            writer.println();
            Iterator iter = this.attributes.values().iterator();
            while (iter.hasNext()) {
                IPluginAttribute attribute = (IPluginAttribute)iter.next();
                attribute.write(newIndent, writer);
                if (!iter.hasNext()) continue;
                writer.println();
            }
        }
        writer.println(">");
        newIndent = indent + ELEMENT_SHIFT;
        IPluginObject[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IPluginElement element = (IPluginElement)children[i];
            element.write(newIndent, writer);
        }
        if (this.getText() != null) {
            writer.println(newIndent + this.getWritableString(this.getText()));
        }
        writer.println(indent + "</" + this.getName() + ">");
    }
}

