/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.site.AbstractSiteBuildModel;
import org.eclipse.pde.internal.core.site.SiteBuild;

public class WorkspaceSiteBuildModel
extends AbstractSiteBuildModel
implements IEditableModel {
    private boolean dirty;
    private IFile file;
    private boolean editable = true;

    public WorkspaceSiteBuildModel() {
    }

    public WorkspaceSiteBuildModel(IFile file) {
        this.setFile(file);
    }

    public void fireModelChanged(IModelChangedEvent event) {
        this.dirty = true;
        super.fireModelChanged(event);
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.loaded = true;
        this.save(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return swriter.toString();
    }

    public IFile getFile() {
        return this.file;
    }

    public String getInstallLocation() {
        return this.file.getParent().getLocation().toOSString();
    }

    public IResource getUnderlyingResource() {
        return this.file;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isInSync() {
        return this.isInSync(this.file.getLocation().toFile());
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.file.getLocation().toFile());
    }

    public void load() {
        if (this.file == null) {
            return;
        }
        if (this.file.exists()) {
            boolean outOfSync = false;
            InputStream stream = null;
            try {
                stream = this.file.getContents(false);
            }
            catch (CoreException e) {
                outOfSync = true;
                try {
                    stream = this.file.getContents(true);
                }
                catch (CoreException ex) {
                    return;
                }
            }
            try {
                this.load(stream, outOfSync);
                stream.close();
            }
            catch (CoreException e) {
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        } else {
            this.siteBuild = new SiteBuild();
            this.siteBuild.model = this;
            this.loaded = true;
        }
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            String contents = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (this.file.exists()) {
                this.file.setContents((InputStream)stream, false, false, null);
            } else {
                this.createFolder(this.file, null);
                this.file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.siteBuild.write("", writer);
        }
        this.dirty = false;
    }

    private void createFolder(IFile file, IProgressMonitor monitor) throws CoreException {
        if (file.exists()) {
            return;
        }
        IProject project = file.getProject();
        IPath path = file.getProjectRelativePath();
        for (int i = path.segmentCount() - 1; i > 0; --i) {
            IFolder folder = project.getFolder(path.removeLastSegments(i));
            if (folder.exists()) continue;
            folder.create(true, true, monitor);
        }
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void setFile(IFile newFile) {
        this.file = newFile;
    }
}

