/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.events.AutoBuildJob;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.events.EventStats;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.InternalBuilder;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.osgi.framework.Bundle;

public class BuildManager
implements ICoreConstants,
IManager,
ILifecycleListener {
    protected final AutoBuildJob autoBuildJob;
    protected boolean building = false;
    protected final ArrayList builtProjects = new ArrayList();
    protected InternalBuilder currentBuilder;
    protected DeltaDataTree currentDelta;
    protected ElementTree currentTree;
    protected final DeltaCache deltaCache = new DeltaCache();
    protected final DeltaCache deltaTreeCache = new DeltaCache();
    protected ElementTree lastBuiltTree;
    protected boolean rebuildRequested = false;
    private final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    private long timeStamp = -1L;
    protected Workspace workspace;
    private ILock lock;

    public BuildManager(Workspace workspace, ILock workspaceLock) {
        this.workspace = workspace;
        this.autoBuildJob = new AutoBuildJob(workspace);
        this.lock = workspaceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicBuild(int trigger, IncrementalProjectBuilder builder, Map args, MultiStatus status, IProgressMonitor monitor) {
        try {
            int depth;
            boolean clean;
            block15: {
                this.currentBuilder = builder;
                this.currentBuilder.clearForgetLastBuiltState();
                clean = trigger == 15;
                this.lastBuiltTree = this.currentBuilder.getLastBuiltTree();
                if (!clean && this.lastBuiltTree == null) {
                    trigger = 6;
                }
                boolean fullBuild = trigger == 6;
                this.currentTree = fullBuild ? null : this.workspace.getElementTree();
                depth = -1;
                try {
                    if (clean || fullBuild || this.needsBuild(this.currentBuilder)) break block15;
                    Object var12_9 = null;
                    if (depth >= 0) {
                        this.getWorkManager().endUnprotected(depth);
                    }
                    if (clean || this.currentBuilder.wasForgetStateRequested()) {
                        this.currentBuilder.setLastBuiltTree(null);
                    } else {
                        ElementTree lastTree = this.workspace.getElementTree();
                        lastTree.immutable();
                        this.currentBuilder.setLastBuiltTree(lastTree);
                    }
                    this.hookEndBuild(builder);
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    if (depth >= 0) {
                        this.getWorkManager().endUnprotected(depth);
                    }
                    if (clean || this.currentBuilder.wasForgetStateRequested()) {
                        this.currentBuilder.setLastBuiltTree(null);
                    } else {
                        ElementTree lastTree = this.workspace.getElementTree();
                        lastTree.immutable();
                        this.currentBuilder.setLastBuiltTree(lastTree);
                    }
                    this.hookEndBuild(builder);
                    throw throwable;
                }
                Object var15_15 = null;
                this.currentBuilder = null;
                this.currentTree = null;
                this.lastBuiltTree = null;
                this.currentDelta = null;
                return;
            }
            String name = this.currentBuilder.getLabel();
            String message = name != null ? Policy.bind("events.invoking.2", name, builder.getProject().getFullPath().toString()) : Policy.bind("events.invoking.1", builder.getProject().getFullPath().toString());
            monitor.subTask(message);
            this.hookStartBuild(builder, trigger);
            depth = this.getWorkManager().beginUnprotected();
            Platform.run((ISafeRunnable)this.getSafeRunnable(trigger, args, status, monitor));
            Object var12_10 = null;
            if (depth >= 0) {
                this.getWorkManager().endUnprotected(depth);
            }
            if (clean || this.currentBuilder.wasForgetStateRequested()) {
                this.currentBuilder.setLastBuiltTree(null);
            } else {
                ElementTree lastTree = this.workspace.getElementTree();
                lastTree.immutable();
                this.currentBuilder.setLastBuiltTree(lastTree);
            }
            this.hookEndBuild(builder);
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.currentBuilder = null;
            this.currentTree = null;
            this.lastBuiltTree = null;
            this.currentDelta = null;
            throw throwable;
        }
        Object var15_16 = null;
        this.currentBuilder = null;
        this.currentTree = null;
        this.lastBuiltTree = null;
        this.currentDelta = null;
    }

    private WorkManager getWorkManager() {
        try {
            return this.workspace.getWorkManager();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicBuild(IProject project, int trigger, ICommand[] commands, MultiStatus status, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("events.building.1", project.getFullPath().toString());
            monitor.beginTask(message, Math.max(1, commands.length));
            for (int i = 0; i < commands.length; ++i) {
                this.checkCanceled(trigger, monitor);
                IProgressMonitor sub = Policy.subMonitorFor(monitor, 1);
                BuildCommand command = (BuildCommand)commands[i];
                this.basicBuild(project, trigger, command.getBuilderName(), command.getArguments(false), status, sub);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void basicBuild(final IProject project, final int trigger, final MultiStatus status, final IProgressMonitor monitor) {
        if (!project.isAccessible()) {
            return;
        }
        final ICommand[] commands = ((Project)project).internalGetDescription().getBuildSpec(false);
        if (commands.length == 0) {
            return;
        }
        ISafeRunnable code = new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof OperationCanceledException) {
                    throw (OperationCanceledException)e;
                }
                String message = e.getMessage();
                if (message == null) {
                    message = Policy.bind("events.unknown", e.getClass().getName(), BuildManager.this.currentBuilder.getClass().getName());
                }
                status.add((IStatus)new Status(2, "org.eclipse.core.resources", 566, message, e));
            }

            public void run() throws Exception {
                BuildManager.this.basicBuild(project, trigger, commands, status, monitor);
            }
        };
        Platform.run((ISafeRunnable)code);
    }

    protected void basicBuild(IProject project, int trigger, String builderName, Map args, MultiStatus status, IProgressMonitor monitor) {
        IncrementalProjectBuilder builder = null;
        try {
            builder = this.getBuilder(builderName, project, status);
            if (!this.validateNature(builder, builderName)) {
                builder.setLastBuiltTree(null);
                return;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
            return;
        }
        this.basicBuild(trigger, builder, args, status, monitor);
    }

    protected void basicBuildLoop(IProject[] ordered, IProject[] unordered, int trigger, MultiStatus status, IProgressMonitor monitor) {
        int maxIterations;
        int projectWork = ordered.length + unordered.length;
        if (projectWork > 0) {
            projectWork = Policy.totalWork / projectWork;
        }
        if ((maxIterations = this.workspace.getDescription().getMaxBuildIterations()) <= 0) {
            maxIterations = 1;
        }
        this.rebuildRequested = true;
        for (int iter = 0; this.rebuildRequested && iter < maxIterations; ++iter) {
            int i;
            this.rebuildRequested = false;
            this.builtProjects.clear();
            for (i = 0; i < ordered.length; ++i) {
                if (!ordered[i].isAccessible()) continue;
                this.basicBuild(ordered[i], trigger, status, Policy.subMonitorFor(monitor, projectWork));
                this.builtProjects.add(ordered[i]);
            }
            for (i = 0; i < unordered.length; ++i) {
                if (!unordered[i].isAccessible()) continue;
                this.basicBuild(unordered[i], trigger, status, Policy.subMonitorFor(monitor, projectWork));
                this.builtProjects.add(unordered[i]);
            }
            trigger = 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(int trigger, IProgressMonitor monitor) throws CoreException {
        block11: {
            block10: {
                monitor = Policy.monitorFor(monitor);
                try {
                    monitor.beginTask(ICoreConstants.MSG_EVENTS_BUILDING_0, Policy.totalWork);
                    if (!this.canRun(trigger)) {
                        Object var9_3 = null;
                        break block10;
                    }
                    try {
                        this.building = true;
                        IProject[] ordered = this.workspace.getBuildOrder();
                        HashSet<IProject> leftover = new HashSet<IProject>(Arrays.asList(this.workspace.getRoot().getProjects()));
                        leftover.removeAll(Arrays.asList(ordered));
                        IProject[] unordered = leftover.toArray(new IProject[leftover.size()]);
                        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 75, ICoreConstants.MSG_EVENTS_ERRORS, null);
                        this.basicBuildLoop(ordered, unordered, trigger, status, monitor);
                        if (!status.isOK()) {
                            throw new ResourceException((IStatus)status);
                        }
                        break block11;
                    }
                    finally {
                        this.cleanup(trigger);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_5 = null;
                    monitor.done();
                    if (trigger != 10) {
                        if (trigger != 6) throw throwable;
                    }
                    this.autoBuildJob.avoidBuild();
                    throw throwable;
                }
            }
            monitor.done();
            if (trigger != 10) {
                if (trigger != 6) return;
            }
            this.autoBuildJob.avoidBuild();
            return;
        }
        Object var9_4 = null;
        monitor.done();
        if (trigger != 10) {
            if (trigger != 6) return;
        }
        this.autoBuildJob.avoidBuild();
    }

    private void cleanup(int trigger) {
        this.building = false;
        this.builtProjects.clear();
        this.deltaCache.flush();
        this.deltaTreeCache.flush();
        if (trigger == 15) {
            this.autoBuildJob.forceBuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(IProject project, int trigger, IProgressMonitor monitor) throws CoreException {
        if (!this.canRun(trigger)) {
            return;
        }
        try {
            this.building = true;
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, ICoreConstants.MSG_EVENTS_ERRORS, null);
            this.basicBuild(project, trigger, status, monitor);
            if (!status.isOK()) {
                throw new ResourceException((IStatus)status);
            }
        }
        finally {
            this.cleanup(trigger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(IProject project, int trigger, String builderName, Map args, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("events.building.1", project.getFullPath().toString());
            monitor.beginTask(message, 1);
            if (!this.canRun(trigger)) {
                return;
            }
            try {
                this.building = true;
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, ICoreConstants.MSG_EVENTS_ERRORS, null);
                this.basicBuild(project, trigger, builderName, args, status, Policy.subMonitorFor(monitor, 1));
                if (!status.isOK()) {
                    throw new ResourceException((IStatus)status);
                }
            }
            finally {
                this.cleanup(trigger);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean canRun(int trigger) {
        return !this.building;
    }

    public void interrupt() {
        this.autoBuildJob.interrupt();
    }

    private void checkCanceled(int trigger, IProgressMonitor monitor) {
        if (this.systemBundle.getState() == 16) {
            throw new OperationCanceledException();
        }
        Policy.checkCanceled(monitor);
        if (trigger != 9) {
            return;
        }
        if (this.autoBuildJob.isInterrupted()) {
            throw new OperationCanceledException();
        }
    }

    protected IProject[] computeUnorderedProjects(IProject[] ordered) {
        HashSet<IProject> leftover = new HashSet<IProject>(Arrays.asList(this.workspace.getRoot().getProjects()));
        leftover.removeAll(Arrays.asList(ordered));
        IProject[] unordered = leftover.toArray(new IProject[leftover.size()]);
        return unordered;
    }

    public Map createBuildersPersistentInfo(IProject project) throws CoreException {
        Map oldInfos = this.getBuildersPersistentInfo(project);
        ICommand[] buildCommands = ((Project)project).internalGetDescription().getBuildSpec(false);
        if (buildCommands.length == 0) {
            return null;
        }
        HashMap<String, BuilderPersistentInfo> newInfos = new HashMap<String, BuilderPersistentInfo>(buildCommands.length * 2);
        Hashtable instantiatedBuilders = this.getBuilders(project);
        for (int i = 0; i < buildCommands.length; ++i) {
            ElementTree oldTree;
            String builderName = buildCommands[i].getBuilderName();
            BuilderPersistentInfo info = null;
            IncrementalProjectBuilder builder = (IncrementalProjectBuilder)instantiatedBuilders.get(builderName);
            if (builder == null) {
                if (oldInfos != null) {
                    info = (BuilderPersistentInfo)oldInfos.get(builderName);
                }
            } else if (!(builder instanceof MissingBuilder) && (oldTree = builder.getLastBuiltTree()) != null) {
                info = new BuilderPersistentInfo();
                info.setProjectName(project.getName());
                info.setBuilderName(builderName);
                info.setLastBuildTree(oldTree);
                info.setInterestingProjects(builder.getInterestingProjects());
            }
            if (info == null) continue;
            newInfos.put(builderName, info);
        }
        return newInfos;
    }

    protected String debugBuilder() {
        return this.currentBuilder == null ? "<no builder>" : this.currentBuilder.getClass().getName();
    }

    protected String debugProject() {
        if (this.currentBuilder == null) {
            return "<no project>";
        }
        return this.currentBuilder.getProject().getFullPath().toString();
    }

    public void endTopLevel(boolean needsBuild) {
        this.autoBuildJob.build(needsBuild);
    }

    protected IncrementalProjectBuilder getBuilder(String builderName, IProject project, MultiStatus status) throws CoreException {
        Hashtable builders = this.getBuilders(project);
        IncrementalProjectBuilder result = (IncrementalProjectBuilder)builders.get(builderName);
        if (result != null) {
            return result;
        }
        result = this.initializeBuilder(builderName, project, status);
        builders.put(builderName, result);
        result.setProject(project);
        ((InternalBuilder)result).startupOnInitialize();
        return result;
    }

    protected Hashtable getBuilders(IProject project) {
        ProjectInfo info = (ProjectInfo)this.workspace.getResourceInfo(project.getFullPath(), false, false);
        if (info == null) {
            Assert.isNotNull(info, Policy.bind("events.noProject", project.getName()));
        }
        return info.getBuilders();
    }

    public Map getBuildersPersistentInfo(IProject project) throws CoreException {
        return (Map)project.getSessionProperty(ICoreConstants.K_BUILD_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IResourceDelta getDelta(IProject project) {
        try {
            this.lock.acquire();
            if (this.currentTree == null) {
                if (Policy.DEBUG_BUILD_FAILURE) {
                    Policy.debug("Build: no tree for delta " + this.debugBuilder() + " [" + this.debugProject() + "]");
                }
                IResourceDelta iResourceDelta = null;
                return iResourceDelta;
            }
            if (!this.isInterestingProject(project)) {
                if (Policy.DEBUG_BUILD_FAILURE) {
                    Policy.debug("Build: project not interesting for this builder " + this.debugBuilder() + " [" + this.debugProject() + "] " + project.getFullPath());
                }
                IResourceDelta iResourceDelta = null;
                return iResourceDelta;
            }
            if (this.currentDelta != null && this.currentDelta.findNodeAt(project.getFullPath()) == null) {
                if (!project.exists()) {
                    IResourceDelta iResourceDelta = null;
                    return iResourceDelta;
                }
                IResourceDelta iResourceDelta = ResourceDeltaFactory.newEmptyDelta(project);
                return iResourceDelta;
            }
            IResourceDelta result = (IResourceDelta)this.deltaCache.getDelta(project.getFullPath(), this.lastBuiltTree, this.currentTree);
            if (result != null) {
                IResourceDelta iResourceDelta = result;
                return iResourceDelta;
            }
            long startTime = 0L;
            if (Policy.DEBUG_BUILD_DELTA) {
                startTime = System.currentTimeMillis();
                Policy.debug("Computing delta for project: " + project.getName());
            }
            result = ResourceDeltaFactory.computeDelta(this.workspace, this.lastBuiltTree, this.currentTree, project.getFullPath(), -1L);
            this.deltaCache.cache(project.getFullPath(), this.lastBuiltTree, this.currentTree, result);
            if (Policy.DEBUG_BUILD_FAILURE && result == null) {
                Policy.debug("Build: no delta " + this.debugBuilder() + " [" + this.debugProject() + "] " + project.getFullPath());
            }
            if (Policy.DEBUG_BUILD_DELTA) {
                Policy.debug("Finished computing delta, time: " + (System.currentTimeMillis() - startTime) + "ms");
            }
            IResourceDelta iResourceDelta = result;
            return iResourceDelta;
        }
        finally {
            this.lock.release();
        }
    }

    protected ISafeRunnable getSafeRunnable(final int trigger, final Map args, final MultiStatus status, final IProgressMonitor monitor) {
        return new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof OperationCanceledException) {
                    throw (OperationCanceledException)e;
                }
                String builderName = BuildManager.this.currentBuilder.getLabel();
                if (builderName == null || builderName.length() == 0) {
                    builderName = BuildManager.this.currentBuilder.getClass().getName();
                }
                String pluginId = BuildManager.this.currentBuilder.getPluginDescriptor().getUniqueIdentifier();
                String message = Policy.bind("events.builderError", builderName, BuildManager.this.currentBuilder.getProject().getName());
                status.add((IStatus)new Status(2, pluginId, 75, message, null));
                if (e instanceof CoreException) {
                    status.add(((CoreException)e).getStatus());
                } else {
                    message = e.getMessage();
                    if (message == null) {
                        message = Policy.bind("events.unknown", e.getClass().getName(), builderName);
                    }
                    status.add((IStatus)new Status(2, pluginId, 75, message, e));
                }
            }

            public void run() throws Exception {
                IProject[] prereqs = null;
                if (trigger != 15) {
                    prereqs = BuildManager.this.currentBuilder.build(trigger, args, monitor);
                } else {
                    BuildManager.this.currentBuilder.clean(monitor);
                }
                if (prereqs == null) {
                    prereqs = new IProject[]{};
                }
                BuildManager.this.currentBuilder.setInterestingProjects((IProject[])prereqs.clone());
            }
        };
    }

    public void handleEvent(LifecycleEvent event) {
        IProject project = null;
        switch (event.kind) {
            case 16: 
            case 64: {
                project = (IProject)event.resource;
                if (!project.isAccessible()) break;
                this.setBuildersPersistentInfo(project, null);
            }
        }
    }

    public boolean hasBeenBuilt(IProject project) {
        return this.builtProjects.contains(project);
    }

    private void hookEndBuild(IncrementalProjectBuilder builder) {
        if (Policy.MONITOR_BUILDERS) {
            EventStats.endBuild();
        }
        if (!Policy.DEBUG_BUILD_INVOKING || this.timeStamp == -1L) {
            return;
        }
        Policy.debug("Builder finished: " + this.toString(builder) + " time: " + (System.currentTimeMillis() - this.timeStamp) + "ms");
        this.timeStamp = -1L;
    }

    private void hookStartBuild(IncrementalProjectBuilder builder, int trigger) {
        if (Policy.MONITOR_BUILDERS) {
            EventStats.startBuild(builder);
        }
        if (Policy.DEBUG_BUILD_INVOKING) {
            String type;
            this.timeStamp = System.currentTimeMillis();
            switch (trigger) {
                case 6: {
                    type = "FULL_BUILD";
                    break;
                }
                default: {
                    type = "INCREMENTAL_BUILD";
                }
            }
            Policy.debug("Invoking (" + type + ") on builder: " + this.toString(builder));
        }
    }

    protected IncrementalProjectBuilder initializeBuilder(String builderName, IProject project, MultiStatus status) throws CoreException {
        Map infos;
        IncrementalProjectBuilder builder = null;
        try {
            builder = this.instantiateBuilder(builderName);
        }
        catch (CoreException e) {
            status.add((IStatus)new ResourceStatus(75, project.getFullPath(), Policy.bind("events.instantiate.1", builderName), e));
            status.add(e.getStatus());
        }
        if (builder == null) {
            builder = new MissingBuilder(builderName);
        }
        if ((infos = this.getBuildersPersistentInfo(project)) != null) {
            BuilderPersistentInfo info = (BuilderPersistentInfo)infos.remove(builderName);
            if (info != null) {
                ElementTree tree = info.getLastBuiltTree();
                if (tree != null) {
                    builder.setLastBuiltTree(tree);
                }
                builder.setInterestingProjects(info.getInterestingProjects());
            }
            if (infos.size() == 0) {
                this.setBuildersPersistentInfo(project, null);
            }
        }
        return builder;
    }

    protected IncrementalProjectBuilder instantiateBuilder(String builderName) throws CoreException {
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", builderName);
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            return null;
        }
        String hasNature = configs[0].getAttribute("hasNature");
        String natureId = null;
        if (hasNature != null && hasNature.equalsIgnoreCase(Boolean.TRUE.toString())) {
            String builderId = extension.getUniqueIdentifier();
            natureId = this.workspace.getNatureManager().findNatureForBuilder(builderId);
            if (natureId == null) {
                return null;
            }
        }
        InternalBuilder builder = (InternalBuilder)configs[0].createExecutableExtension("run");
        builder.setPluginDescriptor(extension.getDeclaringPluginDescriptor());
        builder.setLabel(extension.getLabel());
        builder.setNatureId(natureId);
        return (IncrementalProjectBuilder)builder;
    }

    protected boolean isInterestingProject(IProject project) {
        if (project.equals(this.currentBuilder.getProject())) {
            return true;
        }
        IProject[] interestingProjects = this.currentBuilder.getInterestingProjects();
        for (int i = 0; i < interestingProjects.length; ++i) {
            if (!interestingProjects[i].equals(project)) continue;
            return true;
        }
        return false;
    }

    protected boolean needsBuild(InternalBuilder builder) {
        ElementTree oldTree = builder.getLastBuiltTree();
        ElementTree newTree = this.workspace.getElementTree();
        long start = System.currentTimeMillis();
        this.currentDelta = (DeltaDataTree)this.deltaTreeCache.getDelta(null, oldTree, newTree);
        if (this.currentDelta == null) {
            if (Policy.DEBUG_NEEDS_BUILD) {
                String message = "Checking if need to build. Starting delta computation between: " + oldTree.toString() + " and " + newTree.toString();
                Policy.debug(message);
            }
            this.currentDelta = newTree.getDataTree().forwardDeltaWith(oldTree.getDataTree(), ResourceComparator.getComparator(false));
            if (Policy.DEBUG_NEEDS_BUILD) {
                Policy.debug("End delta computation. (" + (System.currentTimeMillis() - start) + "ms).");
            }
            this.deltaTreeCache.cache(null, oldTree, newTree, this.currentDelta);
        }
        if (this.currentDelta.findNodeAt(builder.getProject().getFullPath()) != null) {
            if (Policy.DEBUG_NEEDS_BUILD) {
                Policy.debug(this.toString(builder) + " needs building because of changes in: " + builder.getProject().getName());
            }
            return true;
        }
        IProject[] projects = builder.getInterestingProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (this.currentDelta.findNodeAt(projects[i].getFullPath()) == null) continue;
            if (Policy.DEBUG_NEEDS_BUILD) {
                Policy.debug(this.toString(builder) + " needs building because of changes in: " + projects[i].getName());
            }
            return true;
        }
        return false;
    }

    protected void removeBuilders(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] oldSpec = desc.getBuildSpec();
        int oldLength = oldSpec.length;
        if (oldLength == 0) {
            return;
        }
        int remaining = 0;
        for (int i = 0; i < oldSpec.length; ++i) {
            if (oldSpec[i].getBuilderName().equals(builderId)) {
                oldSpec[i] = null;
                continue;
            }
            ++remaining;
        }
        if (remaining == oldSpec.length) {
            return;
        }
        ICommand[] newSpec = new ICommand[remaining];
        int newIndex = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (oldSpec[i] == null) continue;
            newSpec[newIndex++] = oldSpec[i];
        }
        desc.setBuildSpec(newSpec);
        project.setDescription(desc, 0, null);
    }

    public void requestRebuild() {
        this.rebuildRequested = true;
    }

    public void setBuildersPersistentInfo(IProject project, Map map) {
        try {
            project.setSessionProperty(ICoreConstants.K_BUILD_MAP, map);
        }
        catch (CoreException e) {
            ResourceStatus error = new ResourceStatus(4, 1, project.getFullPath(), "Project missing in setBuildersPersistentInfo", null);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)error);
        }
    }

    public void shutdown(IProgressMonitor monitor) {
        this.autoBuildJob.cancel();
    }

    public void startup(IProgressMonitor monitor) {
        this.workspace.addLifecycleListener(this);
    }

    protected String toString(InternalBuilder builder) {
        String name = builder.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name + "(" + builder.getProject().getName() + ")";
    }

    protected boolean validateNature(InternalBuilder builder, String builderId) throws CoreException {
        String nature = builder.getNatureId();
        if (nature == null) {
            return true;
        }
        IProject project = builder.getProject();
        if (!project.hasNature(nature)) {
            this.removeBuilders(project, builderId);
            return false;
        }
        return project.isNatureEnabled(nature);
    }

    class MissingBuilder
    extends IncrementalProjectBuilder {
        private boolean hasBeenBuilt = false;
        private String name;

        MissingBuilder(String name) {
            this.name = name;
        }

        protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
            if (!this.hasBeenBuilt) {
                this.hasBeenBuilt = true;
                String msg = Policy.bind("events.skippingBuilder", new String[]{this.name, this.getProject().getName()});
                Status status = new Status(2, "org.eclipse.core.resources", 1, msg, null);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            }
            return null;
        }
    }

    class DeltaCache {
        private Object delta;
        private ElementTree newTree;
        private ElementTree oldTree;
        private IPath projectPath;

        DeltaCache() {
        }

        public void cache(IPath project, ElementTree oldTree, ElementTree newTree, Object delta) {
            this.projectPath = project;
            this.oldTree = oldTree;
            this.newTree = newTree;
            this.delta = delta;
        }

        public void flush() {
            this.projectPath = null;
            this.oldTree = null;
            this.newTree = null;
            this.delta = null;
        }

        public Object getDelta(IPath project, ElementTree oldTree, ElementTree newTree) {
            boolean pathsEqual;
            if (this.delta == null) {
                return null;
            }
            boolean bl = this.projectPath == null ? project == null : (pathsEqual = this.projectPath.equals(project));
            if (pathsEqual && this.oldTree == oldTree && this.newTree == newTree) {
                return this.delta;
            }
            return null;
        }
    }
}

