/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.resources.MarkerTypeDefinition;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class MarkerTypeDefinitionCache {
    protected HashMap definitions;
    protected HashMap lookup;

    public MarkerTypeDefinitionCache() {
        this.initializeCache();
    }

    private void computeSuperTypes(String id) {
        HashSet<String> entry = new HashSet<String>(5);
        ArrayList<String> queue = new ArrayList<String>(5);
        queue.add(id);
        while (!queue.isEmpty()) {
            Set newEntries;
            String type = (String)queue.remove(0);
            entry.add(type);
            MarkerTypeDefinition def = (MarkerTypeDefinition)this.definitions.get(type);
            if (def == null || (newEntries = def.getSuperTypes()) == null) continue;
            queue.addAll(newEntries);
        }
        this.lookup.put(id, entry);
    }

    private void initializeCache() {
        this.loadDefinitions();
        this.lookup = new HashMap(this.definitions.size());
        Iterator i = this.definitions.keySet().iterator();
        while (i.hasNext()) {
            this.computeSuperTypes((String)i.next());
        }
    }

    public boolean isPersistent(String type) {
        MarkerTypeDefinition def = (MarkerTypeDefinition)this.definitions.get(type);
        return def != null && def.persistent();
    }

    public boolean isSubtype(String type, String superType) {
        Set entry = (Set)this.lookup.get(type);
        return entry != null && entry.contains(superType);
    }

    private void loadDefinitions() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "markers");
        IExtension[] types = point.getExtensions();
        this.definitions = new HashMap(types.length);
        for (int i = 0; i < types.length; ++i) {
            this.definitions.put(types[i].getUniqueIdentifier(), new MarkerTypeDefinition(types[i]));
        }
    }
}

