/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.model;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.ant.internal.ui.editor.model.AntTaskNode;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.xml.sax.Attributes;

public class AntImportNode
extends AntTaskNode {
    private String fFile = null;

    public AntImportNode(Task task, Attributes attributes) {
        super(task);
        this.fFile = attributes.getValue("file");
    }

    public String getFile() {
        return this.fFile;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antImport");
    }

    public String getLabel() {
        StringBuffer label = new StringBuffer(this.getTask().getTaskName());
        label.append(' ');
        label.append(this.fFile);
        if (this.isExternal()) {
            this.appendEntityName(label);
        }
        return label.toString();
    }

    public boolean configure(boolean validateFully) {
        if (this.configured) {
            return false;
        }
        try {
            this.getTask().maybeConfigure();
            this.getTask().execute();
            this.configured = true;
            return true;
        }
        catch (BuildException be) {
            this.handleBuildException(be, "problem_imports");
            return false;
        }
    }

    public IFile getIFile() {
        IFile file;
        if (this.isExternal()) {
            file = AntUtil.getFileForLocation(this.getFilePath(), null);
        } else {
            String path = this.getFile();
            file = AntUtil.getFileForLocation(path, this.getAntModel().getEditedFile().getParentFile());
        }
        return file;
    }
}

