/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.List;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public class CharacterLiteral
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(class$org$eclipse$jdt$core$dom$CharacterLiteral == null ? (class$org$eclipse$jdt$core$dom$CharacterLiteral = CharacterLiteral.class$("org.eclipse.jdt.core.dom.CharacterLiteral")) : class$org$eclipse$jdt$core$dom$CharacterLiteral, "escapedValue", class$java$lang$String == null ? (class$java$lang$String = CharacterLiteral.class$("java.lang.String")) : class$java$lang$String, MANDATORY);
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "'X'";
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$CharacterLiteral;
    static /* synthetic */ Class class$java$lang$String;

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    CharacterLiteral(AST ast) {
        super(ast);
    }

    final List internalStructuralPropertiesForType(int apiLevel) {
        return CharacterLiteral.propertyDescriptors(apiLevel);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == ESCAPED_VALUE_PROPERTY) {
            if (get) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    final int getNodeType0() {
        return 13;
    }

    ASTNode clone0(AST target) {
        CharacterLiteral result = new CharacterLiteral(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setEscapedValue(this.getEscapedValue());
        return result;
    }

    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.ast.scanner;
        char[] source = value.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 51: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (InvalidInputException e) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = value;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    public char charValue() {
        String s = this.getEscapedValue();
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\'' || s.charAt(len - 1) != '\'') {
            throw new IllegalArgumentException();
        }
        char c = s.charAt(1);
        if (c == '\'') {
            throw new IllegalArgumentException();
        }
        if (c == '\\') {
            if (len == 4) {
                char nextChar = s.charAt(2);
                switch (nextChar) {
                    case 'b': {
                        return '\b';
                    }
                    case 't': {
                        return '\t';
                    }
                    case 'n': {
                        return '\n';
                    }
                    case 'f': {
                        return '\f';
                    }
                    case 'r': {
                        return '\r';
                    }
                    case '\"': {
                        return '\"';
                    }
                    case '\'': {
                        return '\'';
                    }
                    case '\\': {
                        return '\\';
                    }
                    case '0': {
                        return '\u0000';
                    }
                    case '1': {
                        return '\u0001';
                    }
                    case '2': {
                        return '\u0002';
                    }
                    case '3': {
                        return '\u0003';
                    }
                    case '4': {
                        return '\u0004';
                    }
                    case '5': {
                        return '\u0005';
                    }
                    case '6': {
                        return '\u0006';
                    }
                    case '7': {
                        return '\u0007';
                    }
                }
                throw new IllegalArgumentException("illegal character literal");
            }
            if (len == 8) {
                int currentPosition = 2;
                int c1 = 0;
                int c2 = 0;
                int c3 = 0;
                int c4 = 0;
                if (s.charAt(currentPosition++) == 'u') {
                    if ((c1 = Character.getNumericValue(s.charAt(currentPosition++))) > 15 || c1 < 0 || (c2 = Character.getNumericValue(s.charAt(currentPosition++))) > 15 || c2 < 0 || (c3 = Character.getNumericValue(s.charAt(currentPosition++))) > 15 || c3 < 0 || (c4 = Character.getNumericValue(s.charAt(currentPosition++))) > 15 || c4 < 0) {
                        throw new IllegalArgumentException("illegal character literal");
                    }
                    return (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                }
                throw new IllegalArgumentException("illegal character literal");
            }
            throw new IllegalArgumentException("illegal character literal");
        }
        return c;
    }

    public void setCharValue(char value) {
        StringBuffer b = new StringBuffer(3);
        b.append('\'');
        switch (value) {
            case '\b': {
                b.append("\\b");
                break;
            }
            case '\t': {
                b.append("\\t");
                break;
            }
            case '\n': {
                b.append("\\n");
                break;
            }
            case '\f': {
                b.append("\\f");
                break;
            }
            case '\r': {
                b.append("\\r");
                break;
            }
            case '\"': {
                b.append("\\\"");
                break;
            }
            case '\'': {
                b.append("\\'");
                break;
            }
            case '\\': {
                b.append("\\\\");
                break;
            }
            case '\u0000': {
                b.append("\\0");
                break;
            }
            case '\u0001': {
                b.append("\\1");
                break;
            }
            case '\u0002': {
                b.append("\\2");
                break;
            }
            case '\u0003': {
                b.append("\\3");
                break;
            }
            case '\u0004': {
                b.append("\\4");
                break;
            }
            case '\u0005': {
                b.append("\\5");
                break;
            }
            case '\u0006': {
                b.append("\\6");
                break;
            }
            case '\u0007': {
                b.append("\\7");
                break;
            }
            default: {
                b.append(value);
            }
        }
        b.append('\'');
        this.setEscapedValue(b.toString());
    }

    int memSize() {
        int size = 44 + CharacterLiteral.stringSize(this.escapedValue);
        return size;
    }

    int treeSize() {
        return this.memSize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CharacterLiteral.createPropertyList(class$org$eclipse$jdt$core$dom$CharacterLiteral == null ? (class$org$eclipse$jdt$core$dom$CharacterLiteral = CharacterLiteral.class$("org.eclipse.jdt.core.dom.CharacterLiteral")) : class$org$eclipse$jdt$core$dom$CharacterLiteral);
        CharacterLiteral.addProperty(ESCAPED_VALUE_PROPERTY);
        PROPERTY_DESCRIPTORS = CharacterLiteral.reapPropertyList();
    }
}

