/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayInitializer
extends Expression {
    public Expression[] expressions;
    public ArrayBinding binding;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int max = this.expressions.length;
            for (int i = 0; i < max; ++i) {
                flowInfo = this.expressions[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            }
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        int expressionLength = this.expressions == null ? 0 : this.expressions.length;
        codeStream.generateInlinedValue(expressionLength);
        codeStream.newArray(currentScope, this.binding);
        if (this.expressions != null) {
            int elementsTypeID = this.binding.dimensions > 1 ? -1 : this.binding.leafComponentType.id;
            block5: for (int i = 0; i < expressionLength; ++i) {
                Expression expr = this.expressions[i];
                if (expr.constant != NotAConstant) {
                    switch (elementsTypeID) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 10: {
                            if (expr.constant.longValue() == 0L) continue block5;
                            codeStream.dup();
                            codeStream.generateInlinedValue(i);
                            expr.generateCode(currentScope, codeStream, true);
                            codeStream.arrayAtPut(elementsTypeID, false);
                            break;
                        }
                        case 8: 
                        case 9: {
                            double constantValue = expr.constant.doubleValue();
                            if (constantValue != -0.0 && constantValue == 0.0) continue block5;
                            codeStream.dup();
                            codeStream.generateInlinedValue(i);
                            expr.generateCode(currentScope, codeStream, true);
                            codeStream.arrayAtPut(elementsTypeID, false);
                            break;
                        }
                        case 5: {
                            if (!expr.constant.booleanValue()) continue block5;
                            codeStream.dup();
                            codeStream.generateInlinedValue(i);
                            expr.generateCode(currentScope, codeStream, true);
                            codeStream.arrayAtPut(elementsTypeID, false);
                            break;
                        }
                        default: {
                            if (expr instanceof NullLiteral) continue block5;
                            codeStream.dup();
                            codeStream.generateInlinedValue(i);
                            expr.generateCode(currentScope, codeStream, true);
                            codeStream.arrayAtPut(elementsTypeID, false);
                            break;
                        }
                    }
                    continue;
                }
                if (expr instanceof NullLiteral) continue;
                codeStream.dup();
                codeStream.generateInlinedValue(i);
                expr.generateCode(currentScope, codeStream, true);
                codeStream.arrayAtPut(elementsTypeID, false);
            }
        }
        if (!valueRequired) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('{');
        if (this.expressions != null) {
            int j = 20;
            for (int i = 0; i < this.expressions.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.expressions[i].printExpression(0, output);
                if (--j != 0) continue;
                output.append('\n');
                ArrayInitializer.printIndent(indent + 1, output);
                j = 20;
            }
        }
        return output.append('}');
    }

    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedTb) {
        this.constant = NotAConstant;
        if (expectedTb.isArrayType()) {
            this.binding = (ArrayBinding)expectedTb;
            if (this.expressions == null) {
                return this.binding;
            }
            TypeBinding expectedElementsTb = this.binding.elementsType(scope);
            if (expectedElementsTb.isBaseType()) {
                int length = this.expressions.length;
                for (int i = 0; i < length; ++i) {
                    TypeBinding expressionTb;
                    Expression expression = this.expressions[i];
                    TypeBinding typeBinding = expressionTb = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(scope, expectedElementsTb) : expression.resolveType(scope);
                    if (expressionTb == null) {
                        return null;
                    }
                    if (expression.isConstantValueOfTypeAssignableToType(expressionTb, expectedElementsTb)) {
                        expression.implicitWidening(expectedElementsTb, expressionTb);
                        continue;
                    }
                    if (BaseTypeBinding.isWidening(expectedElementsTb.id, expressionTb.id)) {
                        expression.implicitWidening(expectedElementsTb, expressionTb);
                        continue;
                    }
                    scope.problemReporter().typeMismatchErrorActualTypeExpectedType(expression, expressionTb, expectedElementsTb);
                    return null;
                }
            } else {
                int length = this.expressions.length;
                for (int i = 0; i < length; ++i) {
                    if (this.expressions[i].resolveTypeExpecting(scope, expectedElementsTb) != null) continue;
                    return null;
                }
            }
            return this.binding;
        }
        TypeBinding leafElementType = null;
        int dim = 1;
        if (this.expressions == null) {
            leafElementType = scope.getJavaLangObject();
        } else {
            Expression currentExpression = this.expressions[0];
            while (currentExpression != null && currentExpression instanceof ArrayInitializer) {
                ++dim;
                Expression[] subExprs = ((ArrayInitializer)currentExpression).expressions;
                if (subExprs == null) {
                    leafElementType = scope.getJavaLangObject();
                    currentExpression = null;
                    break;
                }
                currentExpression = ((ArrayInitializer)currentExpression).expressions[0];
            }
            if (currentExpression != null) {
                leafElementType = currentExpression.resolveType(scope);
            }
        }
        if (leafElementType != null) {
            ArrayBinding probableTb = scope.createArray(leafElementType, dim);
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this, probableTb, expectedTb);
        }
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expressions != null) {
            int expressionsLength = this.expressions.length;
            for (int i = 0; i < expressionsLength; ++i) {
                this.expressions[i].traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

