/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jface.text.Region;

public class OrganizeImportsOperation
implements IWorkspaceRunnable {
    private Region fRange;
    private ImportsStructure fImportsStructure;
    private boolean fDoSave;
    private boolean fIgnoreLowerCaseNames;
    private IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private IProblem fParsingError;
    private CompilationUnit fASTRoot;

    public OrganizeImportsOperation(ImportsStructure impStructure, Region range, boolean ignoreLowerCaseNames, boolean save, IChooseImportQuery chooseImportQuery) {
        this.fImportsStructure = impStructure;
        this.fRange = range;
        this.fDoSave = save;
        this.fIgnoreLowerCaseNames = ignoreLowerCaseNames;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fParsingError = null;
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(impStructure.getCompilationUnit());
        parser.setResolveBindings(true);
        this.fASTRoot = (CompilationUnit)parser.createAST(null);
    }

    public OrganizeImportsOperation(ICompilationUnit cu, String[] importOrder, int importThreshold, boolean ignoreLowerCaseNames, boolean save, boolean doResolve, IChooseImportQuery chooseImportQuery) throws CoreException {
        this(new ImportsStructure(cu, importOrder, importThreshold, false), null, ignoreLowerCaseNames, save, chooseImportQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ICompilationUnit cu = this.fImportsStructure.getCompilationUnit();
            this.fNumberOfImportsAdded = 0;
            monitor.beginTask(CodeGenerationMessages.getFormattedString("OrganizeImportsOperation.description", cu.getElementName()), 4);
            ArrayList oldSingleImports = new ArrayList();
            ArrayList<String> oldDemandImports = new ArrayList<String>();
            Collection references = this.findTypeReferences(oldSingleImports, oldDemandImports);
            if (references == null) {
                return;
            }
            int nOldImports = oldDemandImports.size() + oldSingleImports.size();
            oldDemandImports.add("");
            oldDemandImports.add("java.lang");
            oldDemandImports.add(cu.getParent().getElementName());
            monitor.worked(1);
            TypeReferenceProcessor processor = new TypeReferenceProcessor(oldSingleImports, oldDemandImports, this.fASTRoot, this.fImportsStructure, this.fIgnoreLowerCaseNames);
            ArrayList<TypeInfo[]> openChoices = new ArrayList<TypeInfo[]>();
            ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>();
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2);
            try {
                subMonitor.beginTask("", references.size());
                Iterator refIterator = references.iterator();
                while (refIterator.hasNext()) {
                    SimpleName typeRef = (SimpleName)refIterator.next();
                    TypeInfo[] openChoice = processor.process(typeRef, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                    if (openChoice == null) continue;
                    openChoices.add(openChoice);
                    sourceRanges.add(new SourceRange(typeRef.getStartPosition(), typeRef.getLength()));
                }
            }
            finally {
                subMonitor.done();
            }
            processor = null;
            if (openChoices.size() > 0 && this.fChooseImportQuery != null) {
                ISourceRange[] ranges;
                TypeInfo[][] choices = (TypeInfo[][])openChoices.toArray((T[])new TypeInfo[openChoices.size()][]);
                TypeInfo[] chosen = this.fChooseImportQuery.chooseImports(choices, ranges = sourceRanges.toArray(new ISourceRange[sourceRanges.size()]));
                if (chosen == null) {
                    throw new OperationCanceledException();
                }
                for (int i = 0; i < chosen.length; ++i) {
                    TypeInfo typeInfo = chosen[i];
                    this.fImportsStructure.addImport(typeInfo.getFullyQualifiedName());
                }
            }
            this.fImportsStructure.create(this.fDoSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fNumberOfImportsAdded = this.fImportsStructure.getNumberOfImportsCreated() - nOldImports;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isAffected(IProblem problem) {
        return this.fRange == null || this.fRange.getOffset() <= problem.getSourceEnd() && this.fRange.getOffset() + this.fRange.getLength() > problem.getSourceStart();
    }

    private Collection findTypeReferences(ArrayList oldSingleImports, ArrayList oldDemandImports) {
        IProblem[] problems = this.fASTRoot.getProblems();
        for (int i = 0; i < problems.length; ++i) {
            IProblem curr = problems[i];
            if (!curr.isError() || (curr.getID() & 0x40000000) == 0 || !this.isAffected(curr)) continue;
            this.fParsingError = problems[i];
            return null;
        }
        List imports = this.fASTRoot.imports();
        for (int i = 0; i < imports.size(); ++i) {
            ImportDeclaration curr = (ImportDeclaration)imports.get(i);
            String id = ASTResolving.getFullName(curr.getName());
            if (curr.isOnDemand()) {
                oldDemandImports.add(id);
                continue;
            }
            oldSingleImports.add(id);
        }
        ArrayList result = new ArrayList();
        ImportReferencesCollector visitor = new ImportReferencesCollector(this.fRange, result);
        this.fASTRoot.accept((ASTVisitor)visitor);
        return result;
    }

    public IProblem getParseError() {
        return this.fParsingError;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private static class TypeReferenceProcessor {
        private ArrayList fOldSingleImports;
        private ArrayList fOldDemandImports;
        private HashSet fImportsAdded;
        private ImportsStructure fImpStructure;
        private ArrayList fTypeRefsFound;
        private boolean fDoIgnoreLowerCaseNames;
        private IJavaSearchScope fSearchScope;
        private IPackageFragment fCurrPackage;
        private ScopeAnalyzer fAnalyzer;

        public TypeReferenceProcessor(ArrayList oldSingleImports, ArrayList oldDemandImports, CompilationUnit root, ImportsStructure impStructure, boolean ignoreLowerCaseNames) {
            this.fOldSingleImports = oldSingleImports;
            this.fOldDemandImports = oldDemandImports;
            this.fImpStructure = impStructure;
            this.fDoIgnoreLowerCaseNames = ignoreLowerCaseNames;
            this.fAnalyzer = new ScopeAnalyzer(root);
            ICompilationUnit cu = this.fImpStructure.getCompilationUnit();
            this.fSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{cu.getJavaProject()});
            this.fCurrPackage = (IPackageFragment)cu.getParent();
            this.fTypeRefsFound = new ArrayList();
            this.fImportsAdded = new HashSet();
        }

        private boolean needsImport(ITypeBinding typeBinding, SimpleName ref) {
            if (!typeBinding.isTopLevel() && !typeBinding.isMember()) {
                return false;
            }
            int modifiers = typeBinding.getModifiers();
            if (Modifier.isPrivate((int)modifiers)) {
                return false;
            }
            ITypeBinding currTypeBinding = Bindings.getBindingOfParentType((ASTNode)ref);
            if (currTypeBinding == null) {
                return false;
            }
            if (!Modifier.isPublic((int)modifiers) && !currTypeBinding.getPackage().getName().equals(typeBinding.getPackage().getName())) {
                return false;
            }
            ASTNode parent = ref.getParent();
            if (parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof TypeDeclaration && parent.getParent() instanceof CompilationUnit) {
                return true;
            }
            if (typeBinding.isMember()) {
                IBinding[] visibleTypes = this.fAnalyzer.getDeclarationsInScope(ref, 4);
                for (int i = 0; i < visibleTypes.length; ++i) {
                    if (visibleTypes[i] != typeBinding) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TypeInfo[] process(SimpleName ref, IProgressMonitor monitor) throws CoreException {
            block18: {
                String typeName = ref.getIdentifier();
                if (this.fImportsAdded.contains(typeName)) {
                    return null;
                }
                try {
                    IBinding binding = ref.resolveBinding();
                    if (binding != null) {
                        ITypeBinding typeBinding;
                        if (binding.getKind() == 2) {
                            typeBinding = (ITypeBinding)binding;
                            if (typeBinding.isArray()) {
                                typeBinding = typeBinding.getElementType();
                            }
                            if (this.needsImport(typeBinding, ref)) {
                                this.fImpStructure.addImport(typeBinding);
                                this.fImportsAdded.add(typeName);
                            }
                        }
                        typeBinding = null;
                        return typeBinding;
                    }
                    this.fImportsAdded.add(typeName);
                    ArrayList typeRefsFound = this.fTypeRefsFound;
                    this.findTypeRefs(typeName, typeRefsFound, monitor);
                    int nFound = typeRefsFound.size();
                    if (nFound == 0) {
                        TypeInfo[] typeInfoArray = null;
                        return typeInfoArray;
                    }
                    if (nFound == 1) {
                        TypeInfo typeRef = (TypeInfo)typeRefsFound.get(0);
                        this.fImpStructure.addImport(typeRef.getFullyQualifiedName());
                        TypeInfo[] typeInfoArray = null;
                        return typeInfoArray;
                    }
                    String containerToImport = null;
                    boolean ambiguousImports = false;
                    for (int i = 0; i < nFound; ++i) {
                        TypeInfo typeRef = (TypeInfo)typeRefsFound.get(i);
                        String fullName = typeRef.getFullyQualifiedName();
                        String containerName = typeRef.getTypeContainerName();
                        if (this.fOldSingleImports.contains(fullName)) {
                            this.fImpStructure.addImport(fullName);
                            TypeInfo[] typeInfoArray = null;
                            return typeInfoArray;
                        }
                        if (!this.fOldDemandImports.contains(containerName)) continue;
                        if (containerToImport == null) {
                            containerToImport = containerName;
                            continue;
                        }
                        ambiguousImports = true;
                    }
                    if (containerToImport != null && !ambiguousImports) {
                        this.fImpStructure.addImport(containerToImport, typeName);
                        break block18;
                    }
                    TypeInfo[] typeInfoArray = typeRefsFound.toArray(new TypeInfo[nFound]);
                    return typeInfoArray;
                }
                finally {
                    this.fTypeRefsFound.clear();
                }
            }
            return null;
        }

        private void findTypeRefs(String simpleTypeName, Collection typeRefsFound, IProgressMonitor monitor) throws JavaModelException {
            char ch;
            if (this.fDoIgnoreLowerCaseNames && simpleTypeName.length() > 0 && Strings.isLowerCase(ch = simpleTypeName.charAt(0)) && Character.isLetter(ch)) {
                return;
            }
            TypeInfo[] infos = AllTypesCache.getTypesForName(simpleTypeName, this.fSearchScope, monitor);
            for (int i = 0; i < infos.length; ++i) {
                TypeInfo curr = infos[i];
                IType type = curr.resolveType(this.fSearchScope);
                if (type == null || !JavaModelUtil.isVisible((IMember)type, this.fCurrPackage)) continue;
                typeRefsFound.add(curr);
            }
        }
    }

    public static interface IChooseImportQuery {
        public TypeInfo[] chooseImports(TypeInfo[][] var1, ISourceRange[] var2);
    }
}

