/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.ui.JavaUI;

public class JavaDocVMInstallListener
implements IVMInstallChangedListener {
    public void init() {
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        for (int i = 0; i < types.length; ++i) {
            IVMInstall[] installs = types[i].getVMInstalls();
            for (int j = 0; j < installs.length; ++j) {
                this.updateJavadocLocations(installs[j]);
            }
        }
        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
    }

    public void remove() {
        JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
    }

    private void updateJavadocLocations(IVMInstall install) {
        LibraryLocation[] locations;
        URL url = install.getJavadocLocation();
        if (url != null && (locations = JavaRuntime.getLibraryLocations((IVMInstall)install)) != null) {
            for (int i = 0; i < locations.length; ++i) {
                IPath path = locations[i].getSystemLibraryPath();
                if (path == null) continue;
                JavaUI.setLibraryJavadocLocation(path, url);
            }
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION.equals(property) || IVMInstallChangedListener.PROPERTY_JAVADOC_LOCATION.equals(property) || IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS.equals(property)) {
            this.updateJavadocLocations((IVMInstall)event.getSource());
        }
    }

    public void vmAdded(IVMInstall vm) {
        this.updateJavadocLocations(vm);
    }

    public void vmRemoved(IVMInstall vm) {
    }
}

