/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchQuery;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.custom.BusyIndicator;

public abstract class FindOccurrencesEngine {
    private boolean USE_NEW_SEARCH = true;
    private IOccurrencesFinder fFinder;

    protected FindOccurrencesEngine(IOccurrencesFinder finder) {
        this.fFinder = finder;
    }

    public static FindOccurrencesEngine create(IJavaElement root, IOccurrencesFinder finder) {
        if (root == null || finder == null) {
            return null;
        }
        ICompilationUnit unit = (ICompilationUnit)root.getAncestor(5);
        if (unit != null) {
            return new FindOccurencesCUEngine(unit, finder);
        }
        IClassFile cf = (IClassFile)root.getAncestor(6);
        if (cf != null) {
            return new FindOccurencesClassFileEngine(cf, finder);
        }
        return null;
    }

    protected abstract CompilationUnit createAST();

    protected abstract IJavaElement getInput();

    protected abstract ISourceReference getSourceReference();

    protected abstract IResource getMarkerOwner() throws JavaModelException;

    protected abstract void addSpecialAttributes(Map var1) throws JavaModelException;

    protected IOccurrencesFinder getOccurrencesFinder() {
        return this.fFinder;
    }

    public String run(int offset, int length) throws JavaModelException {
        ISourceReference sr = this.getSourceReference();
        if (sr.getSourceRange() == null) {
            return SearchMessages.getString("FindOccurrencesEngine.noSource.text");
        }
        CompilationUnit root = this.createAST();
        if (root == null) {
            return SearchMessages.getString("FindOccurrencesEngine.cannotParse.text");
        }
        String message = this.fFinder.initialize(root, offset, length);
        if (message != null) {
            return message;
        }
        Document document = new Document(this.getSourceReference().getSource());
        if (this.USE_NEW_SEARCH) {
            this.performNewSearch(this.fFinder, (IDocument)document, this.getInput());
            return null;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable((IDocument)document){
            private final /* synthetic */ IDocument val$document;
            {
                this.val$document = val$document;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                ISearchResultView view = FindOccurrencesEngine.this.startSearch();
                FindOccurrencesEngine.this.fFinder.perform();
                IResource file = FindOccurrencesEngine.this.getMarkerOwner();
                IMarker[] markers = FindOccurrencesEngine.this.fFinder.createMarkers(file, this.val$document);
                for (int i = 0; i < markers.length; ++i) {
                    IMarker marker = markers[i];
                    Map attributes = marker.getAttributes();
                    FindOccurrencesEngine.this.addSpecialAttributes(attributes);
                    marker.setAttributes(attributes);
                    FindOccurrencesEngine.this.addMatch(view, file, marker);
                }
                FindOccurrencesEngine.this.searchFinished(view);
            }
        };
        this.run(runnable);
        return null;
    }

    private ISearchResultView startSearch() {
        SearchUI.activateSearchResultView();
        ISearchResultView view = SearchUI.getSearchResultView();
        IJavaElement element = this.getInput();
        if (view != null) {
            this.fFinder.searchStarted(view, element.getElementName());
        }
        return view;
    }

    private void addMatch(ISearchResultView view, IResource file, IMarker marker) {
        if (view != null) {
            view.addMatch("", this.getGroupByKey(marker), file, marker);
        }
    }

    private void searchFinished(ISearchResultView view) {
        if (view != null) {
            view.searchFinished();
        }
    }

    private Object getGroupByKey(IMarker marker) {
        try {
            return marker.getAttribute("lineNumber");
        }
        catch (CoreException coreException) {
            return marker;
        }
    }

    private void run(final IWorkspaceRunnable runnable) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    JavaCore.run((IWorkspaceRunnable)runnable, null);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
        });
    }

    private void performNewSearch(IOccurrencesFinder finder, IDocument document, IJavaElement element) {
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQuery((ISearchQuery)new OccurrencesSearchQuery(finder, document, element));
    }

    private static class FindOccurencesCUEngine
    extends FindOccurrencesEngine {
        private ICompilationUnit fCUnit;

        public FindOccurencesCUEngine(ICompilationUnit unit, IOccurrencesFinder finder) {
            super(finder);
            this.fCUnit = unit;
        }

        protected CompilationUnit createAST() {
            return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCUnit, true, null);
        }

        protected IJavaElement getInput() {
            return this.fCUnit;
        }

        protected IResource getMarkerOwner() throws JavaModelException {
            ICompilationUnit original = WorkingCopyUtil.getOriginal(this.fCUnit);
            return original.getUnderlyingResource();
        }

        protected void addSpecialAttributes(Map attributes) {
        }

        protected ISourceReference getSourceReference() {
            return this.fCUnit;
        }
    }

    private static class FindOccurencesClassFileEngine
    extends FindOccurrencesEngine {
        private IClassFile fClassFile;

        public FindOccurencesClassFileEngine(IClassFile file, IOccurrencesFinder finder) {
            super(finder);
            this.fClassFile = file;
        }

        protected CompilationUnit createAST() {
            return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fClassFile, true, null);
        }

        protected IJavaElement getInput() {
            return this.fClassFile;
        }

        protected IResource getMarkerOwner() {
            return this.fClassFile.getJavaProject().getProject();
        }

        protected void addSpecialAttributes(Map attributes) throws JavaModelException {
            attributes.put("org.eclipse.ui.editorID", "org.eclipse.jdt.ui.ClassFileEditor");
            JavaCore.addJavaElementMarkerAttributes((Map)attributes, (IJavaElement)this.fClassFile.getType());
            attributes.put("org.eclipse.jdt.internal.ui.search.handleID", this.fClassFile.getType().getHandleIdentifier());
        }

        protected ISourceReference getSourceReference() {
            return this.fClassFile;
        }
    }
}

