/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class JavaSearchEditorOpener {
    private IEditorPart fEditor;

    public IEditorPart open(Match match) throws PartInitException, JavaModelException {
        IWorkbenchPage wbPage = JavaPlugin.getActivePage();
        Object element = this.getElementToOpen(match);
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(element, wbPage);
        }
        return this.showWithoutReuse(element, wbPage);
    }

    protected Object getElementToOpen(Match match) {
        return match.getElement();
    }

    private IEditorPart showWithoutReuse(Object element, IWorkbenchPage wbPage) throws PartInitException, JavaModelException {
        return EditorUtility.openInEditor(element, false);
    }

    private IEditorPart showWithReuse(Object element, IWorkbenchPage wbPage) throws JavaModelException, PartInitException {
        IFile file = this.getFile(element);
        if (file != null) {
            String editorID = this.getEditorID(file);
            return this.showInEditor(wbPage, (IEditorInput)new FileEditorInput(file), editorID);
        }
        IClassFile cf = this.getClassFile(element);
        if (cf != null) {
            return this.showInEditor(wbPage, new InternalClassFileEditorInput(cf), "org.eclipse.jdt.ui.ClassFileEditor");
        }
        return null;
    }

    private IFile getFile(Object element) throws JavaModelException {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof IJavaElement) {
            IJavaElement jElement = (IJavaElement)element;
            ICompilationUnit cu = (ICompilationUnit)jElement.getAncestor(5);
            if (cu != null) {
                return (IFile)cu.getCorrespondingResource();
            }
            IClassFile cf = (IClassFile)jElement.getAncestor(6);
            if (cf != null) {
                return (IFile)cf.getCorrespondingResource();
            }
        }
        return null;
    }

    private String getEditorID(IFile file) throws PartInitException {
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        if (desc == null) {
            return SearchPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        for (int i = 0; i < editorRefs.length; ++i) {
            if (!editor.equals(editorRefs[i].getEditor(false))) continue;
            return editorRefs[i].isPinned();
        }
        return false;
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IEditorInput input, String editorId) {
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        } else {
            boolean showsSameInputType;
            boolean isOpen = false;
            if (this.fEditor != null) {
                IEditorReference[] parts = page.getEditorReferences();
                int i = 0;
                while (!isOpen && i < parts.length) {
                    isOpen = this.fEditor == parts[i++].getEditor(false);
                }
            }
            boolean canBeReused = isOpen && !this.fEditor.isDirty() && !this.isPinned(this.fEditor);
            boolean bl = showsSameInputType = this.fEditor != null && this.fEditor.getSite().getId().equals(editorId);
            if (canBeReused && !showsSameInputType) {
                page.closeEditor(this.fEditor, false);
                this.fEditor = null;
            }
            if (canBeReused && showsSameInputType) {
                ((IReusableEditor)this.fEditor).setInput(input);
                page.bringToTop((IWorkbenchPart)this.fEditor);
                editor = this.fEditor;
            } else {
                try {
                    editor = page.openEditor(input, editorId, false);
                    this.fEditor = editor instanceof IReusableEditor ? editor : null;
                }
                catch (PartInitException ex) {
                    MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)SearchMessages.getString("Search.Error.openEditor.title"), (String)SearchMessages.getString("Search.Error.openEditor.message"));
                    return null;
                }
            }
        }
        return editor;
    }

    private IClassFile getClassFile(Object element) {
        if (!(element instanceof IJavaElement)) {
            return null;
        }
        if (element instanceof IClassFile) {
            return (IClassFile)element;
        }
        IJavaElement jElement = (IJavaElement)element;
        if (jElement instanceof IMember) {
            return ((IMember)jElement).getClassFile();
        }
        return null;
    }
}

