/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IStatusListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.StatusListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class RemoteFolderMemberFetcher
implements IUpdateMessageListener,
IStatusListener {
    private final RemoteFolder parentFolder;
    private CVSTag tag;
    List folders = new ArrayList();
    List files = new ArrayList();
    boolean exists = true;
    List exceptions = new ArrayList();

    protected RemoteFolderMemberFetcher(RemoteFolder parentFolder, CVSTag tag) {
        this.tag = tag;
        this.parentFolder = parentFolder;
    }

    public void fetchMembers(IProgressMonitor monitor) throws CVSException {
        this.fetchMembers(monitor, this.tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchMembers(IProgressMonitor monitor, CVSTag tag) throws CVSException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RemoteFolder.getMembers"), 100);
        try {
            this.updateParentFolderChildren();
            IStatus status = this.performUpdate(Policy.subMonitorFor(progress, 50), tag);
            this.updateParentFolderChildren();
            Policy.checkCanceled(monitor);
            this.performErrorCheck(status, Policy.bind("RemoteFolder.errorFetchingMembers"));
            ICVSFile[] remoteFiles = this.getFiles();
            if (remoteFiles.length > 0) {
                this.updateFileRevisions(remoteFiles, Policy.subMonitorFor(progress, 50));
            } else {
                progress.worked(50);
            }
        }
        catch (CVSServerException e) {
            if (!e.isNoTagException() && e.containsErrors()) {
                throw e;
            }
            if (tag == null) {
                throw e;
            }
            Policy.checkCanceled(progress);
            this.fetchMembers(Policy.subMonitorFor(progress, 50), null);
        }
        finally {
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus performUpdate(IProgressMonitor progress, CVSTag tag) throws CVSException {
        progress.beginTask(null, 100);
        Session session = new Session(this.parentFolder.getRepository(), this.parentFolder, false);
        session.open(Policy.subMonitorFor(progress, 10), false);
        try {
            ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
            localOptions.add(Update.RETRIEVE_ABSENT_DIRECTORIES);
            if (tag != null) {
                localOptions.add(Update.makeTagOption(tag));
            }
            IStatus iStatus = Command.UPDATE.execute(session, new Command.GlobalOption[]{Command.DO_NOT_CHANGE}, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new ICVSResource[]{this.parentFolder}, (ICommandOutputListener)new UpdateListener(this), Policy.subMonitorFor(progress, 90));
            return iStatus;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileRevisions(ICVSFile[] files, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
        try {
            CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
            Session session = new Session(this.parentFolder.getRepository(), this.parentFolder, false);
            session.open(Policy.subMonitorFor(monitor, 10), false);
            try {
                IStatus status = Command.STATUS.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, files, (ICommandOutputListener)new StatusListener(this), Policy.subMonitorFor(monitor, 90));
                this.performErrorCheck(status, Policy.bind("RemoteFolder.errorFetchingRevisions"));
            }
            finally {
                session.close();
            }
        }
        finally {
            CVSProviderPlugin.getPlugin().setQuietness(quietness);
        }
    }

    private void performErrorCheck(IStatus status, String errorTitle) throws CVSException {
        if (status.getCode() == -10) {
            if (this.folders.size() + this.files.size() == 0) {
                throw new CVSServerException(status);
            }
            CVSProviderPlugin.log((CoreException)((Object)new CVSServerException(status)));
        }
        if (!this.exists) {
            throw new CVSException((IStatus)new CVSStatus(4, -17, Policy.bind("RemoteFolder.doesNotExist", this.parentFolder.getRepositoryRelativePath())));
        }
        if (!this.exceptions.isEmpty()) {
            if (this.exceptions.size() == 1) {
                throw (CVSException)((Object)this.exceptions.get(0));
            }
            MultiStatus multi = new MultiStatus("org.eclipse.team.cvs.core", 0, errorTitle, null);
            for (int i = 0; i < this.exceptions.size(); ++i) {
                multi.merge(((CVSException)((Object)this.exceptions.get(i))).getStatus());
            }
            throw new CVSException((IStatus)multi);
        }
    }

    public void directoryInformation(ICVSFolder commandRoot, String stringPath, boolean newDirectory) {
        try {
            IPath path = this.parentFolder.getRelativePathFromRootRelativePath(commandRoot, (IPath)new Path(stringPath));
            if (newDirectory && path.segmentCount() == 1) {
                this.recordFolder(path.lastSegment());
            }
        }
        catch (CVSException e) {
            this.exceptions.add(e);
        }
    }

    public void directoryDoesNotExist(ICVSFolder parent, String stringPath) {
        try {
            IPath path = this.parentFolder.getRelativePathFromRootRelativePath(parent, (IPath)new Path(stringPath));
            if (path.isEmpty()) {
                this.parentDoesNotExist();
            }
        }
        catch (CVSException e) {
            this.exceptions.add(e);
        }
    }

    public void fileInformation(int type, ICVSFolder parent, String filename) {
        try {
            Path filePath = new Path(filename);
            filePath = this.parentFolder.getRelativePathFromRootRelativePath(parent, (IPath)filePath);
            if (filePath.segmentCount() == 1) {
                String properFilename = filePath.lastSegment();
                this.recordFile(properFilename);
            }
        }
        catch (CVSException e) {
            this.exceptions.add(e);
        }
    }

    public void fileDoesNotExist(ICVSFolder parent, String filename) {
    }

    public void fileStatus(ICVSFolder commandRoot, String path, String remoteRevision) {
        if (remoteRevision == "") {
            return;
        }
        try {
            ((RemoteFile)this.parentFolder.getChild(Util.getLastSegment(path))).setRevision(remoteRevision);
        }
        catch (CVSException e) {
            this.exceptions.add(e);
        }
    }

    protected RemoteFolder recordFolder(String name) {
        RemoteFolder folder = new RemoteFolder(this.parentFolder, this.parentFolder.getRepository(), Util.appendPath(this.parentFolder.getRepositoryRelativePath(), name), this.tag);
        this.folders.add(folder);
        return folder;
    }

    protected RemoteFile recordFile(String name) {
        RemoteFile file = new RemoteFile(this.parentFolder, 0, name, null, null, this.tag);
        this.files.add(file);
        return file;
    }

    protected void parentDoesNotExist() {
        this.exists = false;
    }

    protected void updateParentFolderChildren() {
        this.parentFolder.setChildren(this.getFetchedChildren());
    }

    protected ICVSFile[] getFiles() {
        return this.files.toArray(new ICVSFile[this.files.size()]);
    }

    public ICVSRemoteResource[] getFetchedChildren() {
        ICVSRemoteResource resource;
        ICVSRemoteResource[] resources = new ICVSRemoteResource[this.folders.size() + this.files.size()];
        int count = 0;
        Iterator iter = this.folders.iterator();
        while (iter.hasNext()) {
            resource = (ICVSRemoteResource)iter.next();
            resources[count++] = resource;
        }
        iter = this.files.iterator();
        while (iter.hasNext()) {
            resource = (ICVSRemoteResource)iter.next();
            resources[count++] = resource;
        }
        return resources;
    }
}

