/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.decorators.DecoratorOverlayIcon;

class OverlayCache {
    private Map cache = new HashMap();

    OverlayCache() {
    }

    Image getImageFor(DecoratorOverlayIcon icon) {
        Image image = (Image)this.cache.get((Object)icon);
        if (image == null) {
            image = icon.createImage();
            this.cache.put(icon, image);
        }
        return image;
    }

    void disposeAll() {
        Iterator it = this.cache.values().iterator();
        while (it.hasNext()) {
            Image image = (Image)it.next();
            image.dispose();
        }
        this.cache.clear();
    }

    Image applyDescriptors(Image source, ImageDescriptor[] descriptors) {
        Rectangle bounds = source.getBounds();
        Point size = new Point(bounds.width, bounds.height);
        DecoratorOverlayIcon icon = new DecoratorOverlayIcon(source, descriptors, size);
        return this.getImageFor(icon);
    }
}

