/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.internal.debug.ui.console.JavaExceptionHyperLink;
import org.eclipse.jdt.internal.debug.ui.console.JavaNativeStackTraceHyperlink;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceHyperlink;
import org.eclipse.jdt.internal.debug.ui.console.StringMatcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

public class JavaConsoleTracker
implements IConsoleLineTracker {
    private IConsole fConsole;
    private StringMatcher fJavaMatcher;
    private StringMatcher fNativeMatcher;
    private Pattern fJavaQualifiedNamePattern;
    private boolean fInTrace = false;
    String fPrevText = null;
    private IRegion fPrevLine = null;

    public void init(IConsole console) {
        this.fConsole = console;
        this.fJavaMatcher = new StringMatcher("*(*.java:*)", false, false);
        this.fNativeMatcher = new StringMatcher("*(Native Method)", false, false);
        this.fJavaQualifiedNamePattern = Pattern.compile("([$_A-Za-z][$_A-Za-z0-9]*[.])*[$_A-Za-z][$_A-Za-z0-9]*Exception");
    }

    public void lineAppended(IRegion line) {
        try {
            int offset = line.getOffset();
            int length = line.getLength();
            String text = this.fConsole.getDocument().get(offset, length);
            boolean standardMatch = false;
            int index = -1;
            if (this.fJavaMatcher.match(text)) {
                standardMatch = true;
                index = text.lastIndexOf(32);
            } else if (this.fNativeMatcher.match(text)) {
                index = text.lastIndexOf(32, text.length() - 15);
            }
            if (index >= 0) {
                if (!this.fInTrace) {
                    Matcher m;
                    this.fInTrace = true;
                    if (this.fPrevText != null && (m = this.fJavaQualifiedNamePattern.matcher(this.fPrevText)).find()) {
                        int start = m.start();
                        int end = m.end();
                        int size = end - start;
                        JavaExceptionHyperLink link = new JavaExceptionHyperLink(this.fConsole, this.fPrevText.substring(start, end));
                        this.fConsole.addLink((IConsoleHyperlink)link, start += this.fPrevLine.getOffset(), size);
                    }
                }
                int linkOffset = offset + index + 1;
                int linkLength = length - index - 1;
                JavaStackTraceHyperlink link = null;
                link = standardMatch ? new JavaStackTraceHyperlink(this.fConsole) : new JavaNativeStackTraceHyperlink(this.fConsole);
                this.fConsole.addLink((IConsoleHyperlink)link, linkOffset, linkLength);
            } else if (this.fInTrace) {
                this.fInTrace = false;
            }
            this.fPrevText = text;
            this.fPrevLine = line;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void dispose() {
        this.fConsole = null;
        this.fJavaMatcher = null;
        this.fNativeMatcher = null;
    }
}

