/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ExpressionManager;

public class WatchExpression
implements IWatchExpression {
    protected String fExpressionText;
    protected IWatchExpressionResult fResult;
    protected IDebugTarget fDebugTarget;
    protected IDebugElement fCurrentContext;
    private boolean fEnabled = true;
    private boolean fPending = false;

    public WatchExpression(String expression) {
        this.fExpressionText = expression;
    }

    public WatchExpression(String expressionText, boolean enabled) {
        this(expressionText);
        this.fEnabled = enabled;
    }

    public void evaluate() {
        if (this.fCurrentContext == null) {
            return;
        }
        IDebugElement context = this.fCurrentContext;
        this.fDebugTarget = context.getDebugTarget();
        IWatchExpressionListener listener = new IWatchExpressionListener(){

            public void watchEvaluationFinished(IWatchExpressionResult result) {
                WatchExpression.this.setPending(false);
                WatchExpression.this.setResult(result);
            }
        };
        this.setPending(true);
        IWatchExpressionDelegate delegate = DebugPlugin.getDefault().getExpressionManager().newWatchExpressionDelegate(context.getModelIdentifier());
        if (delegate != null) {
            delegate.evaluateExpression(this.getExpressionText(), context, listener);
        } else {
            listener.watchEvaluationFinished(new IWatchExpressionResult(){

                public IValue getValue() {
                    return null;
                }

                public boolean hasErrors() {
                    return true;
                }

                public String[] getErrorMessages() {
                    return new String[]{DebugCoreMessages.getString("WatchExpression.0")};
                }

                public String getExpressionText() {
                    return WatchExpression.this.getExpressionText();
                }

                public DebugException getException() {
                    return null;
                }
            });
        }
    }

    public void setExpressionContext(IDebugElement context) {
        this.fCurrentContext = context;
        if (context == null) {
            this.setResult(null);
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.evaluate();
    }

    public void setResult(IWatchExpressionResult result) {
        this.fResult = result;
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent(this, 16)});
    }

    private void watchExpressionChanged() {
        ((ExpressionManager)DebugPlugin.getDefault().getExpressionManager()).watchExpressionChanged(this);
    }

    public String getExpressionText() {
        return this.fExpressionText;
    }

    public IValue getValue() {
        if (this.fResult == null) {
            return null;
        }
        return this.fResult.getValue();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void dispose() {
    }

    public String getModelIdentifier() {
        if (this.fCurrentContext != null) {
            return this.fCurrentContext.getModelIdentifier();
        }
        return DebugPlugin.getUniqueIdentifier();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.watchExpressionChanged();
        this.evaluate();
    }

    public void setExpressionText(String expression) {
        this.fExpressionText = expression;
        this.watchExpressionChanged();
        this.evaluate();
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isPending() {
        return this.fPending;
    }

    protected void setPending(boolean pending) {
        this.fPending = pending;
        this.watchExpressionChanged();
    }

    public boolean hasErrors() {
        return this.fResult != null && this.fResult.hasErrors();
    }

    public String[] getErrorMessages() {
        if (this.fResult == null) {
            return new String[0];
        }
        return this.fResult.getErrorMessages();
    }
}

