/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.DirtyBufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.SavedBufferValidationState;

public abstract class BufferValidationState {
    protected IFile fFile;
    protected boolean fExisted;

    public static BufferValidationState create(IFile file) {
        ITextFileBuffer buffer = BufferValidationState.getBuffer(file);
        if (buffer == null) {
            return new SavedBufferValidationState(file);
        }
        if (buffer.isDirty()) {
            return new DirtyBufferValidationState(file);
        }
        return new SavedBufferValidationState(file);
    }

    public RefactoringStatus isValid() {
        if (!this.fExisted) {
            if (this.fFile.exists()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("TextChanges.error.existing", this.fFile.getFullPath().toString()));
            }
        } else if (!this.fFile.exists()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("TextChanges.error.not_existing", this.fFile.getFullPath().toString()));
        }
        return new RefactoringStatus();
    }

    public void dispose() {
    }

    protected BufferValidationState(IFile file) {
        this.fFile = file;
        this.fExisted = file.exists();
    }

    protected IDocument getDocument() {
        ITextFileBuffer buffer = BufferValidationState.getBuffer(this.fFile);
        if (buffer == null) {
            return null;
        }
        return buffer.getDocument();
    }

    protected static boolean isDirty(IFile file) {
        ITextFileBuffer buffer = BufferValidationState.getBuffer(file);
        if (buffer == null) {
            return false;
        }
        return buffer.isDirty();
    }

    protected static ITextFileBuffer getBuffer(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        ITextFileBuffer buffer = manager.getTextFileBuffer(path);
        return buffer;
    }
}

