/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.model.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.pde.internal.ui.model.IDocumentAttribute;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.IDocumentTextNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginAttribute;

public abstract class PluginDocumentNode
implements IDocumentNode {
    private IDocumentNode fParent;
    private ArrayList fChildren = new ArrayList();
    private boolean fIsErrorNode;
    private int fLength = -1;
    private int fOffset = -1;
    protected HashMap fAttributes = new HashMap();
    private String fTag;
    private int fIndent = 0;
    private IDocumentNode fPreviousSibling;
    protected IDocumentTextNode fTextNode;

    public IDocumentNode[] getChildNodes() {
        return this.fChildren.toArray(new IDocumentNode[this.fChildren.size()]);
    }

    public int indexOf(IDocumentNode child) {
        return this.fChildren.indexOf(child);
    }

    public IDocumentNode getChildAt(int index) {
        if (index < this.fChildren.size()) {
            return (IDocumentNode)this.fChildren.get(index);
        }
        return null;
    }

    public IDocumentNode getParentNode() {
        return this.fParent;
    }

    public void setParentNode(IDocumentNode node) {
        this.fParent = node;
    }

    public void addChildNode(IDocumentNode child) {
        this.addChildNode(child, this.fChildren.size());
    }

    public void addChildNode(IDocumentNode child, int position) {
        this.fChildren.add(position, child);
        if (position > 0 && this.fChildren.size() > 1) {
            child.setPreviousSibling((IDocumentNode)this.fChildren.get(position - 1));
        }
        if (this.fChildren.size() > 1 && position < this.fChildren.size() - 1) {
            ((IDocumentNode)this.fChildren.get(position + 1)).setPreviousSibling(child);
        }
        child.setParentNode(this);
    }

    public IDocumentNode removeChildNode(IDocumentNode child) {
        int index = this.fChildren.indexOf(child);
        if (index != -1) {
            this.fChildren.remove(child);
            if (index < this.fChildren.size()) {
                IDocumentNode prevSibling = index == 0 ? null : (IDocumentNode)this.fChildren.get(index - 1);
                ((IDocumentNode)this.fChildren.get(index)).setPreviousSibling(prevSibling);
                return child;
            }
        }
        return null;
    }

    public boolean isErrorNode() {
        return this.fIsErrorNode;
    }

    public void setIsErrorNode(boolean isErrorNode) {
        this.fIsErrorNode = isErrorNode;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setXMLAttribute(IDocumentAttribute attribute) {
        this.fAttributes.put(attribute.getAttributeName(), attribute);
    }

    public String getXMLAttributeValue(String name) {
        PluginAttribute attr = (PluginAttribute)this.fAttributes.get(name);
        return attr == null ? null : attr.getValue();
    }

    public void setXMLTagName(String tag) {
        this.fTag = tag;
    }

    public String getXMLTagName() {
        return this.fTag;
    }

    public IDocumentAttribute getDocumentAttribute(String name) {
        return (IDocumentAttribute)this.fAttributes.get(name);
    }

    public int getLineIndent() {
        return this.fIndent;
    }

    public void setLineIndent(int indent) {
        this.fIndent = indent;
    }

    public IDocumentAttribute[] getNodeAttributes() {
        ArrayList list = new ArrayList();
        Iterator iter = this.fAttributes.values().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list.toArray(new IDocumentAttribute[list.size()]);
    }

    public IDocumentNode getPreviousSibling() {
        return this.fPreviousSibling;
    }

    public void setPreviousSibling(IDocumentNode sibling) {
        this.fPreviousSibling = sibling;
    }

    protected String getIndent() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.fIndent; ++i) {
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public void swap(IDocumentNode child1, IDocumentNode child2) {
        int index1 = this.fChildren.indexOf(child1);
        int index2 = this.fChildren.indexOf(child2);
        this.fChildren.set(index1, child2);
        this.fChildren.set(index2, child1);
        child1.setPreviousSibling(index2 == 0 ? null : (IDocumentNode)this.fChildren.get(index2 - 1));
        child2.setPreviousSibling(index1 == 0 ? null : (IDocumentNode)this.fChildren.get(index1 - 1));
        if (index1 < this.fChildren.size() - 1) {
            ((IDocumentNode)this.fChildren.get(index1 + 1)).setPreviousSibling(child2);
        }
        if (index2 < this.fChildren.size() - 1) {
            ((IDocumentNode)this.fChildren.get(index2 + 1)).setPreviousSibling(child1);
        }
    }

    public void addTextNode(IDocumentTextNode textNode) {
        this.fTextNode = textNode;
    }

    public IDocumentTextNode getTextNode() {
        return this.fTextNode;
    }

    public void removeTextNode() {
        this.fTextNode = null;
    }

    public void removeDocumentAttribute(IDocumentAttribute attr) {
        this.fAttributes.remove(attr.getAttributeName());
    }
}

