/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.internal.model.PluginParser;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class RegistryLoader {
    private Factory factory;
    private boolean debug = false;
    private long lastTick = System.currentTimeMillis();

    private RegistryLoader(Factory factory, boolean debug) {
        this.debug = debug;
        this.factory = factory;
    }

    private void debug(String msg) {
        long thisTick = System.currentTimeMillis();
        System.out.println("RegistryLoader: " + msg + " [+" + (thisTick - this.lastTick) + "ms]");
        this.lastTick = thisTick;
    }

    private String[] getPathMembers(URL path) {
        String[] list = null;
        String protocol = path.getProtocol();
        if (protocol.equals("file")) {
            list = new File(path.getFile()).list();
        }
        return list == null ? new String[]{} : list;
    }

    private boolean parseProblem(String message) {
        this.factory.error((IStatus)new Status(2, "org.eclipse.core.runtime", 1, message, null));
        return true;
    }

    private PluginRegistryModel parseRegistry(URL[] pluginPath) {
        long startTick = System.currentTimeMillis();
        PluginRegistryModel result = this.processManifestFiles(pluginPath);
        if (InternalPlatform.DEBUG) {
            long endTick = System.currentTimeMillis();
            this.debug("Parsed Registry: " + (endTick - startTick) + "ms");
        }
        return result;
    }

    public static PluginRegistryModel parseRegistry(URL[] pluginPath, Factory factory, boolean debug) {
        return new RegistryLoader(factory, debug).parseRegistry(pluginPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginModel processManifestFile(URL manifest) {
        InputStream is = null;
        try {
            is = manifest.openStream();
        }
        catch (IOException e) {
            if (this.debug) {
                this.debug("No plugin found for: " + manifest);
            }
            return null;
        }
        PluginModel result = null;
        try {
            try {
                InputSource in = new InputSource(is);
                in.setSystemId(manifest.getFile());
                result = new PluginParser(this.factory).parsePlugin(in);
            }
            finally {
                is.close();
            }
        }
        catch (SAXParseException se) {
            this.factory.error((IStatus)new Status(2, "org.eclipse.core.runtime", 1, Policy.bind((String)"parse.errorProcessing", (String)manifest.toString()), null));
        }
        catch (Exception e) {
            this.factory.error((IStatus)new Status(2, "org.eclipse.core.runtime", 1, Policy.bind((String)"parse.errorProcessing", (String)(manifest.toString() + ":  " + e.getMessage())), null));
        }
        return result;
    }

    private PluginRegistryModel processManifestFiles(URL[] pluginPath) {
        PluginRegistryModel result = this.factory.createPluginRegistry();
        for (int i = 0; i < pluginPath.length; ++i) {
            this.processPluginPathEntry(result, pluginPath[i]);
        }
        return result;
    }

    private void processPluginPathEntry(PluginRegistryModel registry, URL location) {
        if (this.debug) {
            this.debug("Path - " + location);
        }
        if (location.getFile().endsWith("/")) {
            String[] members = this.getPathMembers(location);
            for (int j = 0; j < members.length; ++j) {
                boolean found = false;
                try {
                    found = this.processPluginPathFile(registry, new URL(location, members[j] + "/plugin.xml"));
                    if (!found) {
                        found = this.processPluginPathFile(registry, new URL(location, members[j] + "/fragment.xml"));
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                if (!this.debug) continue;
                this.debug(found ? "Processed - " : "Processed (not found) - " + members[j]);
            }
        } else {
            boolean found = this.processPluginPathFile(registry, location);
            if (this.debug) {
                this.debug(found ? "Processed - " : "Processed (not found) - " + location);
            }
        }
    }

    private boolean processPluginPathFile(PluginRegistryModel registry, URL location) {
        PluginModel entry = this.processManifestFile(location);
        if (entry == null) {
            return false;
        }
        if (!this.requiredPluginModel(entry, location)) {
            entry = null;
            return false;
        }
        entry.setVersion(this.getQualifiedVersion(entry, location));
        if (entry instanceof PluginDescriptorModel) {
            if (entry.getId() == null || entry.getVersion() == null) {
                return this.parseProblem(Policy.bind((String)"parse.nullPluginIdentifier", (String)location.toString()));
            }
            if (registry.getPlugin(entry.getId(), entry.getVersion()) != null) {
                return this.parseProblem(Policy.bind((String)"parse.duplicatePlugin", (String)entry.getId(), (String)location.toString()));
            }
            registry.addPlugin((PluginDescriptorModel)entry);
        } else {
            if (entry.getId() == null || entry.getVersion() == null) {
                return this.parseProblem(Policy.bind((String)"parse.nullFragmentIdentifier", (String)location.toString()));
            }
            if (entry instanceof PluginFragmentModel) {
                registry.addFragment((PluginFragmentModel)entry);
            } else {
                return this.parseProblem(Policy.bind((String)"parse.unknownEntry", (String)location.toString()));
            }
        }
        String url = location.toString();
        url = url.substring(0, 1 + url.lastIndexOf(47));
        entry.setRegistry(registry);
        entry.setLocation(url);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getQualifiedVersion(PluginModel entry, URL base) {
        String string;
        InputStream is;
        block17: {
            PluginVersionIdentifier v;
            String qualifier;
            block15: {
                String string2;
                block16: {
                    block13: {
                        String string3;
                        block14: {
                            if (entry == null || entry.getVersion() == null || entry.getId() == null) {
                                return null;
                            }
                            is = null;
                            URL manifest = null;
                            manifest = new URL(base, "buildmanifest.properties");
                            Properties props = new Properties();
                            is = manifest.openStream();
                            props.load(is);
                            String key = "plugin@" + entry.getId();
                            qualifier = props.getProperty(key);
                            if (qualifier != null) break block13;
                            string3 = entry.getVersion();
                            Object var11_11 = null;
                            if (is == null) break block14;
                            try {
                                is.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        return string3;
                    }
                    v = new PluginVersionIdentifier(entry.getVersion());
                    if (v.getQualifierComponent().equals("")) break block15;
                    string2 = entry.getVersion();
                    Object var11_12 = null;
                    if (is == null) break block16;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return string2;
            }
            string = new PluginVersionIdentifier(v.getMajorComponent(), v.getMinorComponent(), v.getServiceComponent(), qualifier).toString();
            Object var11_13 = null;
            if (is == null) break block17;
            try {
                is.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        return string;
        catch (Exception e) {
            String string4;
            block18: {
                try {
                    string4 = entry.getVersion();
                    Object var11_14 = null;
                    if (is == null) break block18;
                }
                catch (Throwable throwable) {
                    block19: {
                        Object var11_15 = null;
                        if (is == null) break block19;
                        try {
                            is.close();
                        }
                        catch (IOException e2) {}
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return string4;
        }
    }

    private boolean requiredPluginModel(PluginModel plugin, URL location) {
        int versionLength;
        String name = plugin.getName();
        String id = plugin.getId();
        String version = plugin.getVersion();
        int nameLength = name == null ? 0 : name.length();
        int idLength = id == null ? 0 : id.length();
        int n = versionLength = version == null ? 0 : version.length();
        if (nameLength <= 0) {
            this.parseProblem(Policy.bind((String)"parse.missingPluginName", (String)location.toString()));
            return false;
        }
        if (idLength <= 0) {
            this.parseProblem(Policy.bind((String)"parse.missingPluginId", (String)location.toString()));
            return false;
        }
        if (versionLength <= 0) {
            this.parseProblem(Policy.bind((String)"parse.missingPluginVersion", (String)location.toString()));
            return false;
        }
        if (plugin instanceof PluginFragmentModel) {
            int pNameVersion;
            String pluginName = ((PluginFragmentModel)plugin).getPlugin();
            String pluginVersion = ((PluginFragmentModel)plugin).getPluginVersion();
            int pNameLength = pluginName == null ? 0 : pluginName.length();
            int n2 = pNameVersion = pluginVersion == null ? 0 : pluginVersion.length();
            if (pNameLength <= 0) {
                this.parseProblem(Policy.bind((String)"parse.missingFPName", (String)location.toString()));
                return false;
            }
            if (pNameVersion <= 0) {
                this.parseProblem(Policy.bind((String)"parse.missingFPVersion", (String)location.toString()));
                return false;
            }
        }
        return true;
    }
}

