/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.operations.UpdateUtils;

public class DeltaInstallHandler
extends BaseInstallHandler {
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String FRAGMENT_XML = "fragment.xml";
    private static final String META_MANIFEST = "META-INF/MANIFEST.MF";
    protected IFeature oldFeature;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeInstall(IFeatureContentConsumer consumer) throws CoreException {
        if (this.pluginEntries == null) {
            return;
        }
        if (!this.feature.isPatch()) {
            IFeature[] oldFeatures = UpdateUtils.getInstalledFeatures(this.feature);
            if (oldFeatures.length == 0) {
                return;
            }
            this.oldFeature = oldFeatures[0];
        } else {
            this.oldFeature = UpdateUtils.getPatchedFeature(this.feature);
            if (this.oldFeature == null) {
                return;
            }
        }
        IPluginEntry[] oldPlugins = this.oldFeature.getPluginEntries();
        for (int i = 0; i < this.pluginEntries.length; ++i) {
            IPluginEntry newPlugin = this.pluginEntries[i];
            IPluginEntry oldPlugin = this.getPluginEntry(oldPlugins, newPlugin.getVersionedIdentifier().getIdentifier());
            if (oldPlugin == null) continue;
            try {
                this.overlayPlugin(oldPlugin, newPlugin, consumer);
                continue;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, UpdateUtils.getPluginId(), 1, "", (Throwable)e));
            }
        }
    }

    protected IPluginEntry getPluginEntry(IPluginEntry[] plugins, String id) {
        for (int i = 0; i < plugins.length; ++i) {
            if (!plugins[i].getVersionedIdentifier().getIdentifier().equals(id)) continue;
            return plugins[i];
        }
        return null;
    }

    protected boolean referenceExists(ContentReference[] references, ContentReference ref) {
        String id = ref.getIdentifier();
        if (id == null) {
            return false;
        }
        for (int i = 0; i < references.length; ++i) {
            if (!id.equals(references[i].getIdentifier())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void overlayPlugin(IPluginEntry oldPlugin, IPluginEntry newPlugin, IFeatureContentConsumer consumer) throws CoreException, IOException {
        if (newPlugin instanceof PluginEntry && !((PluginEntry)newPlugin).isUnpack()) {
            return;
        }
        ContentReference[] oldReferences = this.oldFeature.getFeatureContentProvider().getPluginEntryContentReferences(oldPlugin, null);
        ContentReference[] newReferences = this.feature.getFeatureContentProvider().getPluginEntryContentReferences(newPlugin, null);
        URL newURL = new URL(consumer.getFeature().getSite().getURL(), "plugins/" + newPlugin.getVersionedIdentifier().toString());
        String pluginPath = newURL.getFile();
        for (int i = 0; i < oldReferences.length; ++i) {
            if (this.isPluginManifest(oldReferences[i]) || this.referenceExists(newReferences, oldReferences[i])) continue;
            InputStream input = null;
            input = oldReferences[i].getInputStream();
            File targetFile = new File(pluginPath, oldReferences[i].getIdentifier());
            UpdateManagerUtils.copyToLocal(input, targetFile.getAbsolutePath(), null);
            UpdateManagerUtils.checkPermissions(oldReferences[i], pluginPath);
            Object var12_12 = null;
            if (input == null) continue;
            try {
                input.close();
            }
            catch (IOException ioe) {}
            continue;
            {
                catch (IOException e) {
                    var12_12 = null;
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (IOException ioe) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var12_12 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    protected boolean isPluginManifest(ContentReference ref) {
        String id = ref.getIdentifier();
        return PLUGIN_XML.equals(id) || FRAGMENT_XML.equals(id) || META_MANIFEST.equals(id);
    }
}

