/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.variables;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.internal.variables.DynamicVariable;
import org.eclipse.core.internal.variables.ListenerList;
import org.eclipse.core.internal.variables.StringSubstitutionEngine;
import org.eclipse.core.internal.variables.ValueVariable;
import org.eclipse.core.internal.variables.VariablesMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.IValueVariableListener;
import org.eclipse.core.variables.VariablesPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StringVariableManager
implements IStringVariableManager {
    private Map fDynamicVariables;
    private Map fValueVariables;
    private ListenerList fListeners = new ListenerList(5);
    private static final int ADDED = 0;
    private static final int CHANGED = 1;
    private static final int REMOVED = 2;
    private static StringVariableManager fgManager;
    private boolean fInitializing = false;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String VALUE_VARIABLES_TAG = "valueVariables";
    private static final String VALUE_VARIABLE_TAG = "valueVariable";
    private static final String NAME_TAG = "name";
    private static final String VALUE_TAG = "value";
    private static final String DESCRIPTION_TAG = "description";
    private static final String INITIALIZED_TAG = "contributed";
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private static final String PREF_VALUE_VARIABLES;

    private StringVariableNotifier getNotifier() {
        return new StringVariableNotifier();
    }

    public static StringVariableManager getDefault() {
        if (fgManager == null) {
            fgManager = new StringVariableManager();
        }
        return fgManager;
    }

    private StringVariableManager() {
    }

    private void initialize() {
        if (this.fDynamicVariables == null) {
            this.fInitializing = true;
            this.fDynamicVariables = new HashMap(5);
            this.fValueVariables = new HashMap(5);
            this.loadPersistedValueVariables();
            this.loadContributedValueVariables();
            this.loadDynamicVariables();
            this.fInitializing = false;
        }
    }

    private void loadDynamicVariables() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.variables", "dynamicVariables");
        IConfigurationElement[] elements = point.getConfigurationElements();
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            String name = element.getAttribute("name");
            if (name == null) {
                VariablesPlugin.logMessage(MessageFormat.format("Variable extension missing required 'name' attribute: {0}", element.getDeclaringExtension().getLabel()), null);
                continue;
            }
            String description = element.getAttribute("description");
            DynamicVariable variable = new DynamicVariable(name, description, element);
            this.fDynamicVariables.put(variable.getName(), variable);
        }
    }

    private void loadPersistedValueVariables() {
        String variablesString = VariablesPlugin.getDefault().getPluginPreferences().getString(PREF_VALUE_VARIABLES);
        if (variablesString.length() == 0) {
            return;
        }
        Node root = null;
        Throwable ex = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(variablesString.getBytes("UTF-8"));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            root = parser.parse(stream).getDocumentElement();
        }
        catch (UnsupportedEncodingException e) {
            ex = e;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (FactoryConfigurationError e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        if (ex != null) {
            VariablesPlugin.logMessage("An exception occurred while loading persisted value variables.", ex);
            return;
        }
        if (!root.getNodeName().equals(VALUE_VARIABLES_TAG)) {
            VariablesPlugin.logMessage("Invalid format encountered while loading persisted value variables.", null);
            return;
        }
        NodeList list = root.getChildNodes();
        int numItems = list.getLength();
        for (int i = 0; i < numItems; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if (!element.getNodeName().equals(VALUE_VARIABLE_TAG)) {
                VariablesPlugin.logMessage(MessageFormat.format("Invalid XML element encountered while loading value variables: {0}", node.getNodeName()), null);
                continue;
            }
            String name = element.getAttribute("name");
            if (name.length() > 0) {
                String value = element.getAttribute(VALUE_TAG);
                String description = element.getAttribute("description");
                boolean initialized = TRUE_VALUE.equals(element.getAttribute(INITIALIZED_TAG));
                ValueVariable variable = new ValueVariable(name, description, null);
                if (initialized) {
                    variable.setValue(value);
                }
                this.fValueVariables.put(name, variable);
                continue;
            }
            VariablesPlugin.logMessage("Invalid variable entry encountered while loading value variables. Variable name is null.", null);
        }
    }

    private void loadContributedValueVariables() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.variables", VALUE_VARIABLES_TAG);
        IConfigurationElement[] elements = point.getConfigurationElements();
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            String name = element.getAttribute("name");
            if (name == null) {
                VariablesPlugin.logMessage(MessageFormat.format("Variable extension missing required 'name' attribute: {0}", element.getDeclaringExtension().getLabel()), null);
                continue;
            }
            String description = element.getAttribute("description");
            ValueVariable variable = new ValueVariable(name, description, element);
            ValueVariable existing = (ValueVariable)this.getValueVariable(name);
            if (existing != null && existing.isInitialized()) {
                variable.setValue(existing.getValue());
            }
            this.fValueVariables.put(variable.getName(), variable);
        }
    }

    public IStringVariable[] getVariables() {
        this.initialize();
        ArrayList list = new ArrayList(this.fDynamicVariables.size() + this.fValueVariables.size());
        list.addAll(this.fDynamicVariables.values());
        list.addAll(this.fValueVariables.values());
        return list.toArray(new IStringVariable[list.size()]);
    }

    public IValueVariable[] getValueVariables() {
        this.initialize();
        return this.fValueVariables.values().toArray(new IValueVariable[this.fValueVariables.size()]);
    }

    public IDynamicVariable[] getDynamicVariables() {
        this.initialize();
        return this.fDynamicVariables.values().toArray(new IDynamicVariable[this.fDynamicVariables.size()]);
    }

    public String performStringSubstitution(String expression) throws CoreException {
        return this.performStringSubstitution(expression, true);
    }

    public IValueVariable newValueVariable(String name, String description) {
        IConfigurationElement element = null;
        ValueVariable existing = (ValueVariable)this.getValueVariable(name);
        if (existing != null && existing.isContributed()) {
            element = existing.getConfigurationElement();
        }
        return new ValueVariable(name, description, element);
    }

    public void addVariables(IValueVariable[] variables) throws CoreException {
        IValueVariable variable;
        int i;
        this.initialize();
        MultiStatus status = new MultiStatus(VariablesPlugin.getUniqueIdentifier(), 120, VariablesMessages.getString("StringVariableManager.26"), null);
        for (i = 0; i < variables.length; ++i) {
            variable = variables[i];
            if (this.getValueVariable(variable.getName()) == null) continue;
            status.add((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 120, MessageFormat.format(VariablesMessages.getString("StringVariableManager.27"), variable.getName()), null));
        }
        if (status.isOK()) {
            for (i = 0; i < variables.length; ++i) {
                variable = variables[i];
                this.fValueVariables.put(variable.getName(), variable);
            }
            IValueVariable[] copy = new IValueVariable[variables.length];
            System.arraycopy(variables, 0, copy, 0, variables.length);
            this.getNotifier().notify(copy, 0);
            return;
        }
        throw new CoreException((IStatus)status);
    }

    public void removeVariables(IValueVariable[] variables) {
        this.initialize();
        ArrayList<IValueVariable> removed = new ArrayList<IValueVariable>(variables.length);
        for (int i = 0; i < variables.length; ++i) {
            IValueVariable variable = variables[i];
            if (this.fValueVariables.remove(variable.getName()) == null) continue;
            removed.add(variable);
        }
        if (removed.size() > 0) {
            this.getNotifier().notify(removed.toArray(new IValueVariable[removed.size()]), 2);
        }
    }

    public IDynamicVariable getDynamicVariable(String name) {
        this.initialize();
        return (IDynamicVariable)this.fDynamicVariables.get(name);
    }

    public IValueVariable getValueVariable(String name) {
        this.initialize();
        return (IValueVariable)this.fValueVariables.get(name);
    }

    public void addValueVariableListener(IValueVariableListener listener) {
        this.fListeners.add(listener);
    }

    public void removeValueVariableListener(IValueVariableListener listener) {
        this.fListeners.remove(listener);
    }

    private String getValueVariablesAsXML() throws IOException, ParserConfigurationException, TransformerException {
        IValueVariable[] variables = this.getValueVariables();
        Document document = this.getDocument();
        Element rootElement = document.createElement(VALUE_VARIABLES_TAG);
        document.appendChild(rootElement);
        for (int i = 0; i < variables.length; ++i) {
            String description;
            ValueVariable variable = (ValueVariable)variables[i];
            Element element = document.createElement(VALUE_VARIABLE_TAG);
            element.setAttribute("name", variable.getName());
            String value = variable.getValue();
            if (value != null) {
                element.setAttribute(VALUE_TAG, value);
            }
            if ((description = variable.getDescription()) != null) {
                element.setAttribute("description", description);
            }
            element.setAttribute(INITIALIZED_TAG, variable.isInitialized() ? TRUE_VALUE : FALSE_VALUE);
            rootElement.appendChild(element);
        }
        return this.serializeDocument(document);
    }

    private Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    private String serializeDocument(Document doc) throws TransformerException, UnsupportedEncodingException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    private void storeValueVariables() {
        Preferences prefs = VariablesPlugin.getDefault().getPluginPreferences();
        String variableString = "";
        if (!this.fValueVariables.isEmpty()) {
            try {
                variableString = this.getValueVariablesAsXML();
            }
            catch (IOException e) {
                VariablesPlugin.log((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 4, "An exception occurred while storing launch configuration variables.", (Throwable)e));
                return;
            }
            catch (ParserConfigurationException e) {
                VariablesPlugin.log((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 4, "An exception occurred while storing launch configuration variables.", (Throwable)e));
                return;
            }
            catch (TransformerException e) {
                VariablesPlugin.log((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 4, "An exception occurred while storing launch configuration variables.", (Throwable)e));
                return;
            }
        }
        prefs.setValue(PREF_VALUE_VARIABLES, variableString);
        VariablesPlugin.getDefault().savePluginPreferences();
    }

    protected void notifyChanged(ValueVariable variable) {
        IValueVariable existing;
        if (!this.fInitializing && variable.equals(existing = this.getValueVariable(variable.getName()))) {
            this.getNotifier().notify(new IValueVariable[]{variable}, 1);
        }
    }

    public String generateVariableExpression(String varName, String arg) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("${");
        buffer.append(varName);
        if (arg != null) {
            buffer.append(":");
            buffer.append(arg);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String performStringSubstitution(String expression, boolean reportUndefinedVariables) throws CoreException {
        return new StringSubstitutionEngine().performStringSubstitution(expression, reportUndefinedVariables, true, this);
    }

    public void validateStringVariables(String expression) throws CoreException {
        new StringSubstitutionEngine().validateStringVariables(expression, this);
    }

    static {
        PREF_VALUE_VARIABLES = VariablesPlugin.getUniqueIdentifier() + ".valueVariables";
    }

    class StringVariableNotifier
    implements ISafeRunnable {
        private IValueVariableListener fListener;
        private int fType;
        private IValueVariable[] fVariables;

        StringVariableNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, VariablesPlugin.getUniqueIdentifier(), 120, "An exception occurred during string variable change notification", exception);
            VariablesPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.variablesAdded(this.fVariables);
                    break;
                }
                case 2: {
                    this.fListener.variablesRemoved(this.fVariables);
                    break;
                }
                case 1: {
                    this.fListener.variablesChanged(this.fVariables);
                }
            }
        }

        public void notify(IValueVariable[] variables, int update) {
            this.fVariables = variables;
            this.fType = update;
            Object[] copiedListeners = StringVariableManager.this.fListeners.getListeners();
            for (int i = 0; i < copiedListeners.length; ++i) {
                this.fListener = (IValueVariableListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
            }
            this.fVariables = null;
            this.fListener = null;
            StringVariableManager.this.storeValueVariables();
        }
    }
}

